/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.manager.AccountLoginPolicy;
import org.cloudfoundry.identity.uaa.authentication.manager.LoginPolicy;
import org.cloudfoundry.identity.uaa.provider.LockoutPolicy;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class PeriodLockoutPolicy
implements AccountLoginPolicy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final LoginPolicy loginPolicy;

    public PeriodLockoutPolicy(LoginPolicy loginPolicy) {
        this.loginPolicy = loginPolicy;
    }

    public LockoutPolicy getDefaultLockoutPolicy() {
        return this.loginPolicy.getLockoutPolicyRetriever().getDefaultLockoutPolicy();
    }

    @Override
    public boolean isAllowed(UaaUser user, Authentication a) throws AuthenticationException {
        LoginPolicy.Result result = this.loginPolicy.isAllowed(user.getId());
        if (result.isAllowed()) {
            return true;
        }
        this.logger.warn((Object)("User " + user.getUsername() + " and id " + user.getId() + " has " + result.getFailureCount() + " failed logins within the last checking period."));
        return false;
    }

    public LoginPolicy getLoginPolicy() {
        return this.loginPolicy;
    }
}

