/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.invitations;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeType;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.invitations.InvitationsRequest;
import org.cloudfoundry.identity.uaa.invitations.InvitationsResponse;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceConflictException;
import org.cloudfoundry.identity.uaa.util.DomainFilter;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Controller
public class InvitationsEndpoint {
    public static final int INVITATION_EXPIRY_DAYS = 7;
    private ScimUserProvisioning users;
    private IdentityProviderProvisioning providers;
    private ClientServicesExtension clients;
    private ExpiringCodeStore expiringCodeStore;
    private Pattern emailPattern = Pattern.compile("^(.+)@(.+)\\.(.+)$");

    public InvitationsEndpoint(ScimUserProvisioning users, IdentityProviderProvisioning providers, ClientServicesExtension clients, ExpiringCodeStore expiringCodeStore) {
        this.users = users;
        this.providers = providers;
        this.clients = clients;
        this.expiringCodeStore = expiringCodeStore;
    }

    @RequestMapping(value={"/invite_users"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResponseEntity<InvitationsResponse> inviteUsers(@RequestBody InvitationsRequest invitations, @RequestParam(value="client_id", required=false) String clientId, @RequestParam(value="redirect_uri") String redirectUri) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof OAuth2Authentication) {
            OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)authentication;
            if (clientId == null) {
                clientId = oAuth2Authentication.getOAuth2Request().getClientId();
            }
        }
        InvitationsResponse invitationsResponse = new InvitationsResponse();
        List<IdentityProvider> activeProviders = this.providers.retrieveActive(IdentityZoneHolder.get().getId());
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String subdomainHeader = request.getHeader("X-Identity-Zone-Subdomain");
        String zoneIdHeader = request.getHeader("X-Identity-Zone-Id");
        ClientDetails client = null;
        if (!StringUtils.hasText((String)subdomainHeader) && !StringUtils.hasText((String)zoneIdHeader)) {
            client = this.clients.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
        }
        for (String email : invitations.getEmails()) {
            try {
                if (email != null && this.emailPattern.matcher(email).matches()) {
                    List<IdentityProvider> providers = DomainFilter.filter(activeProviders, client, email);
                    if (providers.size() == 1) {
                        ScimUser user = this.findOrCreateUser(email, providers.get(0).getOriginKey());
                        String accountsUrl = UaaUrlUtils.getUaaUrl("/invitations/accept", !IdentityZoneHolder.isUaa());
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("user_id", user.getId());
                        data.put("email", user.getPrimaryEmail());
                        data.put("client_id", clientId);
                        data.put("redirect_uri", redirectUri);
                        data.put("origin", user.getOrigin());
                        Timestamp expiry = new Timestamp(System.currentTimeMillis() + 604800000L);
                        ExpiringCode code = this.expiringCodeStore.generateCode(JsonUtils.writeValueAsString(data), expiry, ExpiringCodeType.INVITATION.name(), IdentityZoneHolder.get().getId());
                        String invitationLink = accountsUrl + "?code=" + code.getCode();
                        try {
                            URL inviteLink = new URL(invitationLink);
                            invitationsResponse.getNewInvites().add(InvitationsResponse.success((String)user.getPrimaryEmail(), (String)user.getId(), (String)user.getOrigin(), (URL)inviteLink));
                        }
                        catch (MalformedURLException mue) {
                            invitationsResponse.getFailedInvites().add(InvitationsResponse.failure((String)email, (String)"invitation.exception.url", (String)String.format("Malformed url", invitationLink)));
                        }
                        continue;
                    }
                    if (providers.size() == 0) {
                        invitationsResponse.getFailedInvites().add(InvitationsResponse.failure((String)email, (String)"provider.non-existent", (String)"No authentication provider found."));
                        continue;
                    }
                    invitationsResponse.getFailedInvites().add(InvitationsResponse.failure((String)email, (String)"provider.ambiguous", (String)"Multiple authentication providers found."));
                    continue;
                }
                invitationsResponse.getFailedInvites().add(InvitationsResponse.failure((String)email, (String)"email.invalid", (String)String.format(email + " is invalid email.", new Object[0])));
            }
            catch (ScimResourceConflictException x) {
                invitationsResponse.getFailedInvites().add(InvitationsResponse.failure((String)email, (String)"user.ambiguous", (String)"Multiple users with the same origin matched to the email address."));
            }
            catch (UaaException uaae) {
                invitationsResponse.getFailedInvites().add(InvitationsResponse.failure((String)email, (String)"invitation.exception", (String)uaae.getMessage()));
            }
        }
        return new ResponseEntity((Object)invitationsResponse, HttpStatus.OK);
    }

    protected ScimUser findOrCreateUser(String email, String origin) {
        List results = this.users.query(String.format("email eq \"%s\" and origin eq \"%s\"", email = email.trim().toLowerCase(), origin), IdentityZoneHolder.get().getId());
        if (results == null || results.size() == 0) {
            ScimUser user = new ScimUser(null, email, "", "");
            user.setPrimaryEmail(email.toLowerCase());
            user.setOrigin(origin);
            user.setVerified(false);
            user.setActive(true);
            return this.users.createUser(user, new RandomValueStringGenerator(12).generate(), IdentityZoneHolder.get().getId());
        }
        if (results.size() == 1) {
            return (ScimUser)results.get(0);
        }
        throw new ScimResourceConflictException(String.format("Ambiguous users found for email:%s with origin:%s", email, origin));
    }
}

