/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.resources.jdbc;

import java.util.Collection;
import org.cloudfoundry.identity.uaa.resources.jdbc.HsqlDbLimitSqlAdapter;
import org.cloudfoundry.identity.uaa.resources.jdbc.LimitSqlAdapter;
import org.cloudfoundry.identity.uaa.resources.jdbc.MySqlLimitSqlAdapter;
import org.cloudfoundry.identity.uaa.resources.jdbc.PostgresLimitSqlAdapter;
import org.cloudfoundry.identity.uaa.resources.jdbc.SQLServerLimitSqlAdapter;
import org.springframework.util.StringUtils;

public class LimitSqlAdapterFactory {
    public static LimitSqlAdapter getLimitSqlAdapter() {
        return LimitSqlAdapterFactory.getLimitSqlAdapter(System.getProperty("spring.profiles.active", ""));
    }

    public static LimitSqlAdapter getLimitSqlAdapter(String profiles) {
        if (StringUtils.hasText((String)profiles)) {
            if (profiles.contains("sqlserver")) {
                return new SQLServerLimitSqlAdapter();
            }
            if (profiles.contains("postgresql")) {
                return new PostgresLimitSqlAdapter();
            }
            if (profiles.contains("mysql")) {
                return new MySqlLimitSqlAdapter();
            }
            if (profiles.contains("hsqldb")) {
                return new HsqlDbLimitSqlAdapter();
            }
        }
        return new HsqlDbLimitSqlAdapter();
    }

    public static LimitSqlAdapter getLimitSqlAdapter(Collection<String> profiles) {
        if (profiles != null) {
            if (profiles.contains("sqlserver")) {
                return new SQLServerLimitSqlAdapter();
            }
            if (profiles.contains("postgresql")) {
                return new PostgresLimitSqlAdapter();
            }
            if (profiles.contains("mysql")) {
                return new MySqlLimitSqlAdapter();
            }
            if (profiles.contains("hsqldb")) {
                return new HsqlDbLimitSqlAdapter();
            }
        }
        return new HsqlDbLimitSqlAdapter();
    }
}

