/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.SystemDeletable;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.resources.ResourceMonitor;
import org.cloudfoundry.identity.uaa.security.ContextSensitiveOAuth2SecurityExpressionMethods;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.util.DefaultJdbcListFactory;
import org.springframework.security.oauth2.common.util.JdbcListFactory;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MultitenantJdbcClientDetailsService
extends ClientServicesExtension
implements ResourceMonitor<ClientDetails>,
SystemDeletable {
    protected static final Log logger = LogFactory.getLog(MultitenantJdbcClientDetailsService.class);
    private static final String GET_CREATED_BY_SQL = "select created_by from oauth_client_details where client_id=? and identity_zone_id=?";
    private static final String CLIENT_FIELDS_FOR_UPDATE = "resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified, required_user_groups";
    private static final String CLIENT_FIELDS = "client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified, required_user_groups";
    private static final String BASE_FIND_STATEMENT = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified, required_user_groups from oauth_client_details";
    private static final String DEFAULT_FIND_STATEMENT = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified, required_user_groups from oauth_client_details where identity_zone_id = :identityZoneId order by client_id";
    private static final String DEFAULT_SELECT_STATEMENT = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified, required_user_groups from oauth_client_details where client_id = ? and identity_zone_id = ?";
    private static final String DEFAULT_INSERT_STATEMENT = "insert into oauth_client_details (client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified, required_user_groups, client_id, identity_zone_id, created_by) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String DEFAULT_UPDATE_STATEMENT = "update oauth_client_details set " + "resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified, required_user_groups".replaceAll(", ", "=?, ") + "=? where client_id = ? and identity_zone_id = ?";
    private static final String DEFAULT_UPDATE_SECRET_STATEMENT = "update oauth_client_details set client_secret = ? where client_id = ? and identity_zone_id = ?";
    static final String DEFAULT_DELETE_STATEMENT = "delete from oauth_client_details where client_id = ? and identity_zone_id = ?";
    private static final String DELETE_CLIENTS_BY_ZONE = "delete from oauth_client_details where identity_zone_id = ?";
    private RowMapper<ClientDetails> rowMapper = new ClientDetailsRowMapper();
    private String selectClientDetailsSql = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified, required_user_groups from oauth_client_details where client_id = ? and identity_zone_id = ?";
    private PasswordEncoder passwordEncoder = NoOpPasswordEncoder.getInstance();
    private final JdbcTemplate jdbcTemplate;
    private JdbcListFactory listFactory;

    public MultitenantJdbcClientDetailsService(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate, (String)"JDbcTemplate required");
        this.jdbcTemplate = jdbcTemplate;
        this.listFactory = new DefaultJdbcListFactory((NamedParameterJdbcOperations)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate));
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    public ClientDetails loadClientByClientId(String clientId, String zoneId) throws InvalidClientException {
        ClientDetails details;
        try {
            details = (ClientDetails)this.jdbcTemplate.queryForObject(this.selectClientDetailsSql, (RowMapper)new ClientDetailsRowMapper(), new Object[]{clientId, zoneId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoSuchClientException("No client with requested id: " + clientId);
        }
        return details;
    }

    @Override
    public void addClientDetails(ClientDetails clientDetails, String zoneId) throws ClientAlreadyExistsException {
        try {
            this.jdbcTemplate.update(DEFAULT_INSERT_STATEMENT, this.getInsertClientDetailsFields(clientDetails, zoneId));
        }
        catch (DuplicateKeyException e) {
            throw new ClientAlreadyExistsException("Client already exists: " + clientDetails.getClientId(), (Throwable)e);
        }
    }

    @Override
    public void updateClientDetails(ClientDetails clientDetails, String zoneId) throws NoSuchClientException {
        int count = this.jdbcTemplate.update(DEFAULT_UPDATE_STATEMENT, this.getFieldsForUpdate(clientDetails, zoneId));
        if (count != 1) {
            throw new NoSuchClientException("No client found with id = " + clientDetails.getClientId() + " in identity zone " + IdentityZoneHolder.get().getName());
        }
    }

    @Override
    public void updateClientSecret(String clientId, String secret, String zoneId) throws NoSuchClientException {
        int count = this.jdbcTemplate.update(DEFAULT_UPDATE_SECRET_STATEMENT, new Object[]{this.passwordEncoder.encode((CharSequence)secret), clientId, zoneId});
        if (count != 1) {
            throw new NoSuchClientException("No client found with id = " + clientId);
        }
    }

    @Override
    public void removeClientDetails(String clientId, String zoneId) throws NoSuchClientException {
        this.deleteByClient(clientId, zoneId);
    }

    @Override
    public List<ClientDetails> listClientDetails(String zoneId) {
        return this.listFactory.getList(DEFAULT_FIND_STATEMENT, Collections.singletonMap("identityZoneId", zoneId), this.rowMapper);
    }

    private Object[] getInsertClientDetailsFields(ClientDetails clientDetails, String zoneId) {
        Object[] fieldsForUpdate = this.getFieldsForUpdate(clientDetails, zoneId);
        Object[] clientDetailFieldsForUpdate = new Object[fieldsForUpdate.length + 2];
        System.arraycopy(fieldsForUpdate, 0, clientDetailFieldsForUpdate, 1, fieldsForUpdate.length);
        clientDetailFieldsForUpdate[0] = clientDetails.getClientSecret() != null ? this.passwordEncoder.encode((CharSequence)clientDetails.getClientSecret()) : null;
        clientDetailFieldsForUpdate[clientDetailFieldsForUpdate.length - 1] = this.getUserId();
        return clientDetailFieldsForUpdate;
    }

    private Object[] getFieldsForUpdate(ClientDetails clientDetails, String zoneId) {
        String json;
        HashMap additionalInformation = new HashMap(clientDetails.getAdditionalInformation());
        Collection requiredGroups = (Collection)additionalInformation.remove("required_user_groups");
        try {
            json = JsonUtils.writeValueAsString(additionalInformation);
        }
        catch (Exception e) {
            logger.warn((Object)("Could not serialize additional information: " + clientDetails), (Throwable)e);
            throw new InvalidDataAccessResourceUsageException("Could not serialize additional information:" + clientDetails.getClientId(), (Throwable)e);
        }
        return new Object[]{this.collectionToString(clientDetails.getResourceIds()), this.collectionToString(clientDetails.getScope()), this.collectionToString(clientDetails.getAuthorizedGrantTypes()), this.collectionToString(clientDetails.getRegisteredRedirectUri()), this.collectionToString(clientDetails.getAuthorities()), clientDetails.getAccessTokenValiditySeconds(), clientDetails.getRefreshTokenValiditySeconds(), json, this.getAutoApproveScopes(clientDetails), new Timestamp(System.currentTimeMillis()), this.collectionToString(requiredGroups), clientDetails.getClientId(), zoneId};
    }

    private String collectionToString(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return StringUtils.collectionToCommaDelimitedString(collection);
    }

    private String getAutoApproveScopes(ClientDetails clientDetails) {
        if (clientDetails.isAutoApprove("true")) {
            return "true";
        }
        HashSet<String> scopes = new HashSet<String>();
        for (String scope : clientDetails.getScope()) {
            if (!clientDetails.isAutoApprove(scope)) continue;
            scopes.add(scope);
        }
        return StringUtils.collectionToCommaDelimitedString(scopes);
    }

    @Override
    public int deleteByIdentityZone(String zoneId) {
        return this.jdbcTemplate.update(DELETE_CLIENTS_BY_ZONE, new Object[]{zoneId});
    }

    @Override
    public int deleteByClient(String clientId, String zoneId) {
        int count = this.jdbcTemplate.update(DEFAULT_DELETE_STATEMENT, new Object[]{clientId, zoneId});
        if (count == 0) {
            throw new NoSuchClientException("No client found with id = " + clientId);
        }
        return count;
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    @Override
    public void addClientSecret(String clientId, String newSecret, String zoneId) throws NoSuchClientException {
        ClientDetails clientDetails = this.loadClientByClientId(clientId, zoneId);
        String encodedNewSecret = this.passwordEncoder.encode((CharSequence)newSecret);
        StringBuilder newSecretBuilder = new StringBuilder().append(clientDetails.getClientSecret() == null ? "" : clientDetails.getClientSecret() + " ").append(encodedNewSecret);
        int count = this.jdbcTemplate.update(DEFAULT_UPDATE_SECRET_STATEMENT, new Object[]{newSecretBuilder.toString(), clientId, zoneId});
        if (count != 1) {
            throw new NoSuchClientException("No client found with id = " + clientId);
        }
    }

    @Override
    public void deleteClientSecret(String clientId, String zoneId) throws NoSuchClientException {
        ClientDetails clientDetails = this.loadClientByClientId(clientId, zoneId);
        String clientSecret = clientDetails.getClientSecret().split(" ")[1];
        int count = this.jdbcTemplate.update(DEFAULT_UPDATE_SECRET_STATEMENT, new Object[]{clientSecret, clientId, zoneId});
        if (count != 1) {
            throw new NoSuchClientException("Unable to update client with " + clientId);
        }
    }

    @Override
    public int getTotalCount() {
        Integer count = (Integer)this.jdbcTemplate.queryForObject("select count(*) from oauth_client_details", Integer.class);
        if (count != null) {
            return count;
        }
        return 0;
    }

    protected String getUserId() {
        String userId = null;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        if (authentication.getPrincipal() instanceof UaaPrincipal) {
            userId = ((UaaPrincipal)authentication.getPrincipal()).getId();
        } else if (authentication.getPrincipal() instanceof String) {
            ContextSensitiveOAuth2SecurityExpressionMethods contextSensitiveOAuth2SecurityExpressionMethods = new ContextSensitiveOAuth2SecurityExpressionMethods(authentication);
            userId = this.getCreatedByForClientAndZone((String)authentication.getPrincipal(), contextSensitiveOAuth2SecurityExpressionMethods.getAuthenticationZoneId());
        }
        return userId;
    }

    String getCreatedByForClientAndZone(String clientId, String zoneId) {
        return (String)this.jdbcTemplate.queryForObject(GET_CREATED_BY_SQL, new Object[]{clientId, zoneId}, String.class);
    }

    private static class ClientDetailsRowMapper
    implements RowMapper<ClientDetails> {
        private ClientDetailsRowMapper() {
        }

        public ClientDetails mapRow(ResultSet rs, int rowNum) throws SQLException {
            String requiredUserGroups;
            BaseClientDetails details = new BaseClientDetails(rs.getString(1), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(7), rs.getString(6));
            details.setClientSecret(rs.getString(2));
            if (rs.getObject(8) != null) {
                details.setAccessTokenValiditySeconds(Integer.valueOf(rs.getInt(8)));
            }
            if (rs.getObject(9) != null) {
                details.setRefreshTokenValiditySeconds(Integer.valueOf(rs.getInt(9)));
            }
            String json = rs.getString(10);
            String scopes = rs.getString(11);
            Set<String> autoApproveScopes = new HashSet();
            if (scopes != null) {
                autoApproveScopes = StringUtils.commaDelimitedListToSet((String)scopes);
            }
            if (json != null) {
                try {
                    Map additionalInformation = (Map)JsonUtils.readValue((String)json, Map.class);
                    Object autoApprovedFromAddInfo = additionalInformation.remove("autoapprove");
                    details.setAdditionalInformation(additionalInformation);
                    if (autoApprovedFromAddInfo != null) {
                        if (autoApprovedFromAddInfo instanceof Boolean && ((Boolean)autoApprovedFromAddInfo).booleanValue() || "true".equals(autoApprovedFromAddInfo)) {
                            autoApproveScopes.add("true");
                        } else if (autoApprovedFromAddInfo instanceof Collection) {
                            Collection approvedScopes = (Collection)autoApprovedFromAddInfo;
                            autoApproveScopes.addAll(approvedScopes);
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not decode JSON for additional information: " + details), (Throwable)e);
                }
            }
            details.setAutoApproveScopes(autoApproveScopes);
            if (rs.getObject(12) != null) {
                details.addAdditionalInformation("lastModified", (Object)rs.getTimestamp(12));
            }
            if (StringUtils.isEmpty((Object)(requiredUserGroups = rs.getString(13)))) {
                details.addAdditionalInformation("required_user_groups", Collections.emptySet());
            } else {
                details.addAdditionalInformation("required_user_groups", (Object)StringUtils.commaDelimitedListToSet((String)requiredUserGroups));
            }
            return details;
        }
    }
}

