/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.user.UserInfo;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class InMemoryUaaUserDatabase
implements UaaUserDatabase {
    private final Map<String, UaaUser> users = new HashMap<String, UaaUser>();
    private final Map<String, UaaUser> ids = new HashMap<String, UaaUser>();
    private final Map<String, UserInfo> userInfo = new HashMap<String, UserInfo>();

    public InMemoryUaaUserDatabase(Collection<UaaUser> users) {
        for (UaaUser user : users) {
            this.addUser(user);
        }
    }

    public void addUser(UaaUser user) {
        this.ids.put(user.getId(), user);
        this.users.put(user.getUsername() + "-" + user.getOrigin(), user);
    }

    @Override
    public UaaUser retrieveUserByName(String username, String origin) throws UsernameNotFoundException {
        UaaUser u = this.users.get(username + "-" + origin);
        if (u == null) {
            throw new UsernameNotFoundException("User " + username + " not found");
        }
        return u;
    }

    @Override
    public UaaUser retrieveUserById(String id) throws UsernameNotFoundException {
        UaaUser u = this.ids.get(id);
        if (u == null) {
            throw new UsernameNotFoundException("User ID:" + id + " not found");
        }
        return u;
    }

    @Override
    public UaaUser retrieveUserByEmail(String email, String origin) throws UsernameNotFoundException {
        return this.users.values().stream().filter(u -> origin.equalsIgnoreCase(u.getOrigin()) && email.equalsIgnoreCase(u.getEmail())).findAny().orElse(null);
    }

    @Override
    public UserInfo getUserInfo(String id) {
        return this.userInfo.get(id);
    }

    @Override
    public UserInfo storeUserInfo(String id, UserInfo i) {
        UserInfo info = new UserInfo().setUserAttributes(i.getUserAttributes()).setRoles(i.getRoles());
        this.userInfo.put(id, info);
        return i;
    }

    @Override
    public void updateLastLogonTime(String id) {
        this.retrieveUserById(id).setLastLogonTime(System.currentTimeMillis());
    }

    public UaaUser updateUser(String userId, UaaUser user) throws UsernameNotFoundException {
        if (!this.ids.containsKey(userId)) {
            throw new UsernameNotFoundException("User " + userId + " not found");
        }
        this.ids.put(userId, user);
        return user;
    }

    public void clear() {
        this.ids.clear();
        this.users.clear();
    }
}

