/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.approval;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.audit.event.ApprovalModifiedEvent;
import org.cloudfoundry.identity.uaa.audit.event.SystemDeletable;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class JdbcApprovalStore
implements ApprovalStore,
ApplicationEventPublisherAware,
SystemDeletable {
    private final JdbcTemplate jdbcTemplate;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RowMapper<Approval> rowMapper = new AuthorizationRowMapper();
    private static final String TABLE_NAME = "authz_approvals";
    private static final String FIELDS = "user_id,client_id,scope,expiresAt,status,lastModifiedAt,identity_zone_id";
    private static final String ADD_AUTHZ_SQL = String.format("insert into %s ( %s ) values (?,?,?,?,?,?,?)", "authz_approvals", "user_id,client_id,scope,expiresAt,status,lastModifiedAt,identity_zone_id");
    private static final String REFRESH_AUTHZ_SQL = String.format("update %s set lastModifiedAt=?, expiresAt=?, status=? where user_id=? and client_Id=? and scope=? and identity_zone_id=?", "authz_approvals");
    private static final String GET_AUTHZ_SQL = String.format("select %s from %s", "user_id,client_id,scope,expiresAt,status,lastModifiedAt,identity_zone_id", "authz_approvals");
    private static final String DELETE_AUTHZ_SQL = String.format("delete from %s", "authz_approvals");
    private static final String EXPIRE_AUTHZ_SQL = String.format("update %s set expiresAt = :expiry", "authz_approvals");
    protected static final String DELETE_ZONE_APPROVALS = "delete from authz_approvals where identity_zone_id = ?";
    protected static final String DELETE_CLIENT_APPROVALS = "delete from authz_approvals where client_id = ? and identity_zone_id = ?";
    protected static final String DELETE_USER_APPROVALS = "delete from authz_approvals where user_id = ? and identity_zone_id = ?";
    public static final String DELETE_OF_USER_APPROVALS_BY_PROVIDER = "delete from authz_approvals where user_id in (select id from users where identity_zone_id = ? and origin = ?)";
    private boolean handleRevocationsAsExpiry = false;
    private ApplicationEventPublisher applicationEventPublisher;

    public JdbcApprovalStore(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setHandleRevocationsAsExpiry(boolean handleRevocationsAsExpiry) {
        this.handleRevocationsAsExpiry = handleRevocationsAsExpiry;
    }

    public boolean refreshApproval(final Approval approval, final String zoneId) {
        this.logger.debug((Object)String.format("refreshing approval: [%s]", approval));
        int refreshed = this.jdbcTemplate.update(REFRESH_AUTHZ_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setTimestamp(1, new Timestamp(approval.getLastUpdatedAt().getTime()));
                ps.setTimestamp(2, new Timestamp(approval.getExpiresAt().getTime()));
                ps.setString(3, (approval.getStatus() == null ? Approval.ApprovalStatus.APPROVED : approval.getStatus()).toString());
                ps.setString(4, approval.getUserId());
                ps.setString(5, approval.getClientId());
                ps.setString(6, approval.getScope());
                ps.setString(7, zoneId);
            }
        });
        if (refreshed != 1) {
            throw new DataIntegrityViolationException("Attempt to refresh non-existent authorization");
        }
        return true;
    }

    @Override
    public boolean addApproval(final Approval approval, final String zoneId) {
        block2: {
            this.logger.debug((Object)String.format("adding approval: [%s]", approval));
            try {
                this.refreshApproval(approval, IdentityZoneHolder.get().getId());
            }
            catch (DataIntegrityViolationException ex) {
                int count = this.jdbcTemplate.update(ADD_AUTHZ_SQL, new PreparedStatementSetter(){

                    public void setValues(PreparedStatement ps) throws SQLException {
                        ps.setString(1, approval.getUserId());
                        ps.setString(2, approval.getClientId());
                        ps.setString(3, approval.getScope());
                        ps.setTimestamp(4, new Timestamp(approval.getExpiresAt().getTime()));
                        ps.setString(5, (approval.getStatus() == null ? Approval.ApprovalStatus.APPROVED : approval.getStatus()).toString());
                        ps.setTimestamp(6, new Timestamp(approval.getLastUpdatedAt().getTime()));
                        ps.setString(7, zoneId);
                    }
                });
                if (count != 0) break block2;
                throw new EmptyResultDataAccessException("Approval add failed", 1);
            }
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.publish(new ApprovalModifiedEvent(approval, authentication));
        return true;
    }

    @Override
    public boolean revokeApproval(final Approval approval, final String zoneId) {
        String sql = this.handleRevocationsAsExpiry ? EXPIRE_AUTHZ_SQL : DELETE_AUTHZ_SQL;
        sql = sql + " WHERE user_id = ? AND client_id = ? AND scope = ? AND identity_zone_id = ?";
        int count = this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int pos = 1;
                ps.setString(pos++, approval.getUserId());
                ps.setString(pos++, approval.getClientId());
                ps.setString(pos++, approval.getScope());
                ps.setString(pos++, zoneId);
            }
        });
        return count > 0;
    }

    @Override
    public boolean revokeApprovalsForUser(final String userId, final String zoneId) {
        String sql = this.handleRevocationsAsExpiry ? EXPIRE_AUTHZ_SQL : DELETE_AUTHZ_SQL;
        sql = sql + " WHERE user_id = ? AND identity_zone_id = ?";
        int count = this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int pos = 1;
                ps.setString(pos++, userId);
                ps.setString(pos++, zoneId);
            }
        });
        return count > 0;
    }

    @Override
    public boolean revokeApprovalsForClient(final String clientId, final String zoneId) {
        String sql = this.handleRevocationsAsExpiry ? EXPIRE_AUTHZ_SQL : DELETE_AUTHZ_SQL;
        sql = sql + " WHERE client_id = ? AND identity_zone_id = ?";
        int count = this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int pos = 1;
                ps.setString(pos++, clientId);
                ps.setString(pos++, zoneId);
            }
        });
        return count > 0;
    }

    @Override
    public boolean revokeApprovalsForClientAndUser(final String clientId, final String userId, final String zoneId) {
        String sql = this.handleRevocationsAsExpiry ? EXPIRE_AUTHZ_SQL : DELETE_AUTHZ_SQL;
        sql = sql + " WHERE user_id = ? AND client_id = ? AND identity_zone_id = ?";
        int count = this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int pos = 1;
                ps.setString(pos++, userId);
                ps.setString(pos++, clientId);
                ps.setString(pos++, zoneId);
            }
        });
        return count > 0;
    }

    public boolean purgeExpiredApprovals() {
        this.logger.debug((Object)"Purging expired approvals from database");
        try {
            int deleted = this.jdbcTemplate.update(DELETE_AUTHZ_SQL + " where expiresAt <= ?", ps -> ps.setTimestamp(1, new Timestamp(new Date().getTime())));
            this.logger.debug((Object)(deleted + " expired approvals deleted"));
        }
        catch (DataAccessException ex) {
            this.logger.error((Object)"Error purging expired approvals", (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    public List<Approval> getApprovalsForUser(final String userId, final String zoneId) {
        String sql = GET_AUTHZ_SQL + " WHERE user_id = ? AND identity_zone_id = ?";
        return this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int pos = 1;
                ps.setString(pos++, userId);
                ps.setString(pos++, zoneId);
            }
        }, this.rowMapper);
    }

    @Override
    public List<Approval> getApprovalsForClient(final String clientId, final String zoneId) {
        String sql = GET_AUTHZ_SQL + " WHERE client_id = ? AND identity_zone_id = ?";
        return this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int pos = 1;
                ps.setString(pos++, clientId);
                ps.setString(pos++, zoneId);
            }
        }, this.rowMapper);
    }

    @Override
    public List<Approval> getApprovals(final String userId, final String clientId, final String zoneId) {
        String sql = GET_AUTHZ_SQL + " WHERE user_id = ? AND client_id = ? AND identity_zone_id = ?";
        return this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int pos = 1;
                ps.setString(pos++, userId);
                ps.setString(pos++, clientId);
                ps.setString(pos++, zoneId);
            }
        }, this.rowMapper);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void publish(ApplicationEvent event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent(event);
        }
    }

    @Override
    public int deleteByIdentityZone(String zoneId) {
        int approvalCount = this.jdbcTemplate.update(DELETE_ZONE_APPROVALS, new Object[]{zoneId});
        this.getLogger().debug((Object)String.format("Deleted zone approvals '%s' and count:%s", zoneId, approvalCount));
        return approvalCount;
    }

    @Override
    public int deleteByOrigin(String origin, String zoneId) {
        int approvalCount = this.jdbcTemplate.update(DELETE_OF_USER_APPROVALS_BY_PROVIDER, new Object[]{origin, zoneId});
        this.getLogger().debug((Object)String.format("Deleted provider approvals '%s'/%s and count:%s", origin, zoneId, approvalCount));
        return approvalCount;
    }

    @Override
    public int deleteByClient(String clientId, String zoneId) {
        int approvalCount = this.jdbcTemplate.update(DELETE_CLIENT_APPROVALS, new Object[]{clientId, zoneId});
        this.getLogger().debug((Object)String.format("Deleted client '%s' and %s approvals", clientId, approvalCount));
        return approvalCount;
    }

    @Override
    public int deleteByUser(String userId, String zoneId) {
        int approvalCount = this.jdbcTemplate.update(DELETE_USER_APPROVALS, new Object[]{userId, zoneId});
        this.getLogger().debug((Object)String.format("Deleted user '%s' and %s approvals", userId, approvalCount));
        return approvalCount;
    }

    @Override
    public Log getLogger() {
        return this.logger;
    }

    private static class AuthorizationRowMapper
    implements RowMapper<Approval> {
        private AuthorizationRowMapper() {
        }

        public Approval mapRow(ResultSet rs, int rowNum) throws SQLException {
            String userId = rs.getString(1);
            String clientId = rs.getString(2);
            String scope = rs.getString(3);
            Timestamp expiresAt = rs.getTimestamp(4);
            String status = rs.getString(5);
            Timestamp lastUpdatedAt = rs.getTimestamp(6);
            Approval approval = new Approval().setUserId(userId).setClientId(clientId).setScope(scope).setExpiresAt((Date)expiresAt).setStatus(Approval.ApprovalStatus.valueOf((String)status)).setLastUpdatedAt((Date)lastUpdatedAt);
            return approval;
        }
    }
}

