/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import com.google.zxing.WriterException;
import com.warrenstrange.googleauth.GoogleAuthenticatorException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.authentication.event.MfaAuthenticationFailureEvent;
import org.cloudfoundry.identity.uaa.authentication.event.MfaAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.mfa.MfaProvider;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderProvisioning;
import org.cloudfoundry.identity.uaa.mfa.UserGoogleMfaCredentials;
import org.cloudfoundry.identity.uaa.mfa.UserGoogleMfaCredentialsProvisioning;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@SessionAttributes(value={"uaaMfaCredentials"})
@RequestMapping(value={"/login/mfa"})
public class TotpMfaEndpoint
implements ApplicationEventPublisherAware {
    private UserGoogleMfaCredentialsProvisioning mfaCredentialsProvisioning;
    private MfaProviderProvisioning mfaProviderProvisioning;
    private Log logger = LogFactory.getLog(TotpMfaEndpoint.class);
    private String mfaCompleteUrl = "/login/mfa/completed";
    private ApplicationEventPublisher eventPublisher;
    private UaaUserDatabase userDatabase;

    @ModelAttribute(value="uaaMfaCredentials")
    public UserGoogleMfaCredentials getUaaMfaCredentials() throws UaaPrincipalIsNotInSession {
        UaaPrincipal principal = this.getSessionAuthPrincipal();
        UserGoogleMfaCredentials result = this.mfaCredentialsProvisioning.getUserGoogleMfaCredentials(principal.getId());
        if (result == null) {
            result = this.mfaCredentialsProvisioning.createUserCredentials(principal.getId());
            result.setMfaProviderId(this.getMfaProvider().getId());
        }
        return result;
    }

    public void setMfaCompleteUrl(String mfaCompleteUrl) {
        this.mfaCompleteUrl = mfaCompleteUrl;
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.GET})
    public String generateQrUrl(Model model, @ModelAttribute(value="uaaMfaCredentials") UserGoogleMfaCredentials credentials) throws NoSuchAlgorithmException, WriterException, IOException, UaaPrincipalIsNotInSession {
        UaaPrincipal uaaPrincipal = this.getSessionAuthPrincipal();
        MfaProvider provider = this.getMfaProvider();
        if (this.mfaCredentialsProvisioning.activeUserCredentialExists(uaaPrincipal.getId(), provider.getId())) {
            return "redirect:/login/mfa/verify";
        }
        String url = this.mfaCredentialsProvisioning.getOtpAuthURL(provider.getConfig().getIssuer(), credentials, uaaPrincipal.getName());
        model.addAttribute("qrurl", (Object)url);
        model.addAttribute("identity_zone", (Object)IdentityZoneHolder.get().getName());
        return "mfa/qr_code";
    }

    @RequestMapping(value={"/manual"}, method={RequestMethod.GET})
    public String manualRegistration(Model model, @ModelAttribute(value="uaaMfaCredentials") UserGoogleMfaCredentials credentials) throws UaaPrincipalIsNotInSession {
        UaaPrincipal uaaPrincipal = this.getSessionAuthPrincipal();
        MfaProvider provider = this.getMfaProvider();
        if (this.mfaCredentialsProvisioning.activeUserCredentialExists(uaaPrincipal.getId(), provider.getId())) {
            return "redirect:/login/mfa/verify";
        }
        model.addAttribute("issuer", (Object)provider.getConfig().getIssuer());
        model.addAttribute("username", (Object)uaaPrincipal.getName());
        model.addAttribute("mfa_secret", (Object)credentials.getSecretKey());
        model.addAttribute("identity_zone", (Object)IdentityZoneHolder.get().getName());
        return "mfa/manual_registration";
    }

    @RequestMapping(value={"/verify"}, method={RequestMethod.GET})
    public ModelAndView totpAuthorize(Model model) throws UaaPrincipalIsNotInSession {
        UaaPrincipal uaaPrincipal = this.getSessionAuthPrincipal();
        return this.renderEnterCodePage(model, uaaPrincipal);
    }

    @RequestMapping(value={"/verify.do"}, method={RequestMethod.POST})
    public ModelAndView validateCode(Model model, @RequestParam(value="code") String code, @ModelAttribute(value="uaaMfaCredentials") UserGoogleMfaCredentials credentials, SessionStatus sessionStatus) throws UaaPrincipalIsNotInSession {
        UaaAuthentication uaaAuth = this.getUaaAuthentication();
        UaaPrincipal uaaPrincipal = this.getSessionAuthPrincipal();
        try {
            Integer codeValue = Integer.valueOf(code);
            if (this.mfaCredentialsProvisioning.isValidCode(credentials, codeValue)) {
                if (this.mfaCredentialsProvisioning.getUserGoogleMfaCredentials(uaaPrincipal.getId()) == null) {
                    this.mfaCredentialsProvisioning.saveUserCredentials(credentials);
                }
                HashSet<String> authMethods = new HashSet<String>(uaaAuth.getAuthenticationMethods());
                authMethods.addAll(Arrays.asList("otp", "mfa"));
                uaaAuth.setAuthenticationMethods(authMethods);
                this.publish(new MfaAuthenticationSuccessEvent(this.getUaaUser(uaaPrincipal), uaaAuth, this.getMfaProvider().getType().toValue()));
                sessionStatus.setComplete();
                return new ModelAndView((View)new RedirectView(this.mfaCompleteUrl, true));
            }
            this.logger.debug((Object)("Code authorization failed for user: " + uaaPrincipal.getId()));
            this.publish(new MfaAuthenticationFailureEvent(this.getUaaUser(uaaPrincipal), uaaAuth, this.getMfaProvider().getType().toValue()));
            model.addAttribute("error", (Object)"Incorrect code, please try again.");
        }
        catch (GoogleAuthenticatorException | NumberFormatException e) {
            this.logger.debug((Object)("Error validating the code for user: " + uaaPrincipal.getId() + ". Error: " + e.getMessage()));
            this.publish(new MfaAuthenticationFailureEvent(this.getUaaUser(uaaPrincipal), uaaAuth, this.getMfaProvider().getType().toValue()));
            model.addAttribute("error", (Object)"Incorrect code, please try again.");
        }
        return this.renderEnterCodePage(model, uaaPrincipal);
    }

    public void setUserGoogleMfaCredentialsProvisioning(UserGoogleMfaCredentialsProvisioning userGoogleMfaCredentialsProvisioning) {
        this.mfaCredentialsProvisioning = userGoogleMfaCredentialsProvisioning;
    }

    public void setMfaProviderProvisioning(MfaProviderProvisioning mfaProviderProvisioning) {
        this.mfaProviderProvisioning = mfaProviderProvisioning;
    }

    @ExceptionHandler(value={UaaPrincipalIsNotInSession.class})
    public ModelAndView handleUaaPrincipalIsNotInSession() {
        return new ModelAndView("redirect:/login", Collections.emptyMap());
    }

    private ModelAndView renderEnterCodePage(Model model, UaaPrincipal uaaPrincipal) {
        model.addAttribute("is_first_time_user", (Object)this.mfaCredentialsProvisioning.isFirstTimeMFAUser(uaaPrincipal));
        model.addAttribute("identity_zone", (Object)IdentityZoneHolder.get().getName());
        return new ModelAndView("mfa/enter_code", model.asMap());
    }

    private UaaPrincipal getSessionAuthPrincipal() throws UaaPrincipalIsNotInSession {
        UaaPrincipal principal;
        UaaAuthentication uaaAuth = this.getUaaAuthentication();
        if (uaaAuth != null && (principal = uaaAuth.getPrincipal()) != null) {
            return principal;
        }
        throw new UaaPrincipalIsNotInSession();
    }

    private UaaAuthentication getUaaAuthentication() {
        Authentication a = SecurityContextHolder.getContext().getAuthentication();
        return a instanceof UaaAuthentication ? (UaaAuthentication)a : null;
    }

    public void setUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    private MfaProvider getMfaProvider() {
        String providerName = IdentityZoneHolder.get().getConfig().getMfaConfig().getProviderName();
        return this.mfaProviderProvisioning.retrieveByName(providerName, IdentityZoneHolder.get().getId());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    private void publish(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    private UaaUser getUaaUser(UaaPrincipal principal) {
        try {
            UaaUser user = this.userDatabase.retrieveUserByName(principal.getName(), principal.getOrigin());
            if (user != null) {
                return user;
            }
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public class UaaPrincipalIsNotInSession
    extends Exception {
    }
}

