/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.client.ClientDetailsValidator;
import org.cloudfoundry.identity.uaa.client.InvalidClientDetailsException;
import org.cloudfoundry.identity.uaa.resources.QueryableResourceManager;
import org.cloudfoundry.identity.uaa.security.DefaultSecurityContextAccessor;
import org.cloudfoundry.identity.uaa.security.SecurityContextAccessor;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClientAdminEndpointsValidator
implements InitializingBean,
ClientDetailsValidator {
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final Set<String> VALID_GRANTS = new HashSet<String>(Arrays.asList("implicit", "password", "client_credentials", "authorization_code", "refresh_token", "user_token", "urn:ietf:params:oauth:grant-type:saml2-bearer"));
    private static final Collection<String> NON_ADMIN_INVALID_GRANTS = new HashSet<String>(Arrays.asList("password"));
    private static final Collection<String> NON_ADMIN_VALID_AUTHORITIES = new HashSet<String>(Arrays.asList("uaa.none"));
    private QueryableResourceManager<ClientDetails> clientDetailsService;
    private SecurityContextAccessor securityContextAccessor = new DefaultSecurityContextAccessor();
    private Set<String> reservedClientIds = StringUtils.commaDelimitedListToSet((String)"uaa");

    public void setClientDetailsService(QueryableResourceManager<ClientDetails> clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setSecurityContextAccessor(SecurityContextAccessor securityContextAccessor) {
        this.securityContextAccessor = securityContextAccessor;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.clientDetailsService != null ? 1 : 0) != 0, (String)"A ClientDetailsService must be provided");
    }

    @Override
    public ClientDetails validate(ClientDetails prototype, ClientDetailsValidator.Mode mode) {
        return this.validate(prototype, mode == ClientDetailsValidator.Mode.CREATE, true);
    }

    public ClientDetails validate(ClientDetails prototype, boolean create, boolean checkAdmin) throws InvalidClientDetailsException {
        Set scopes;
        BaseClientDetails client = new BaseClientDetails(prototype);
        if (prototype instanceof BaseClientDetails && (scopes = ((BaseClientDetails)prototype).getAutoApproveScopes()) != null) {
            client.setAutoApproveScopes((Collection)((BaseClientDetails)prototype).getAutoApproveScopes());
        }
        client.setAdditionalInformation(prototype.getAdditionalInformation());
        String clientId = client.getClientId();
        if (create && this.reservedClientIds.contains(clientId)) {
            throw new InvalidClientDetailsException("Not allowed: " + clientId + " is a reserved client_id");
        }
        this.validateClientRedirectUri((ClientDetails)client);
        Set requestedGrantTypes = client.getAuthorizedGrantTypes();
        if (requestedGrantTypes.isEmpty()) {
            throw new InvalidClientDetailsException("An authorized grant type must be provided. Must be one of: " + VALID_GRANTS.toString());
        }
        ClientAdminEndpointsValidator.checkRequestedGrantTypes(requestedGrantTypes);
        if ((requestedGrantTypes.contains("authorization_code") || requestedGrantTypes.contains("password")) && !requestedGrantTypes.contains("refresh_token")) {
            this.logger.debug((Object)("requested grant type missing refresh_token: " + clientId));
            requestedGrantTypes.add("refresh_token");
        }
        if (checkAdmin && !this.securityContextAccessor.isAdmin() && !this.securityContextAccessor.getScopes().contains("clients.admin")) {
            for (String grant : requestedGrantTypes) {
                if (!NON_ADMIN_INVALID_GRANTS.contains(grant)) continue;
                throw new InvalidClientDetailsException(grant + " is not an allowed grant type for non-admin caller.");
            }
            if (requestedGrantTypes.contains("implicit") && requestedGrantTypes.contains("authorization_code")) {
                throw new InvalidClientDetailsException("Not allowed: implicit grant type is not allowed together with authorization_code");
            }
            String callerId = this.securityContextAccessor.getClientId();
            ClientDetails caller = null;
            try {
                caller = (ClientDetails)this.clientDetailsService.retrieve(callerId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (callerId != null && caller != null) {
                String callerPrefix = callerId + ".";
                String clientPrefix = clientId + ".";
                Set validScope = caller.getScope();
                for (String scope : client.getScope()) {
                    if (scope.startsWith(callerPrefix) || scope.startsWith(clientPrefix) || validScope.contains(scope)) continue;
                    throw new InvalidClientDetailsException(scope + " is not an allowed scope for caller=" + callerId + ". Must have prefix in [" + callerPrefix + "," + clientPrefix + "] or be one of: " + validScope.toString());
                }
            } else {
                String clientPrefix = clientId + ".";
                for (String scope : client.getScope()) {
                    if (scope.startsWith(clientPrefix)) continue;
                    throw new InvalidClientDetailsException(scope + " is not an allowed scope for null caller and client_id=" + clientId + ". Must start with '" + clientPrefix + "'");
                }
            }
            HashSet<String> validAuthorities = new HashSet<String>(NON_ADMIN_VALID_AUTHORITIES);
            if (requestedGrantTypes.contains("client_credentials")) {
                validAuthorities.add("uaa.resource");
            }
            for (String authority : AuthorityUtils.authorityListToSet((Collection)client.getAuthorities())) {
                if (validAuthorities.contains(authority)) continue;
                throw new InvalidClientDetailsException(authority + " is not an allowed authority for caller=" + callerId + ". Must be one of: " + ((Object)validAuthorities).toString());
            }
        }
        if (client.getAuthorities().isEmpty()) {
            client.setAuthorities((Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"uaa.none"));
        }
        client.setResourceIds(Collections.singleton("none"));
        if (client.getScope().isEmpty()) {
            client.setScope(Collections.singleton("uaa.none"));
        }
        if (requestedGrantTypes.contains("implicit") && StringUtils.hasText((String)client.getClientSecret())) {
            throw new InvalidClientDetailsException("Implicit grant should not have a client_secret");
        }
        if (create && (requestedGrantTypes.contains("client_credentials") || requestedGrantTypes.contains("authorization_code")) && !StringUtils.hasText((String)client.getClientSecret())) {
            throw new InvalidClientDetailsException("Client secret is required for client_credentials and authorization_code grant types");
        }
        return client;
    }

    public void validateClientRedirectUri(ClientDetails client) {
        Set uris = client.getRegisteredRedirectUri();
        for (String grant_type : Arrays.asList("authorization_code", "implicit")) {
            if (!client.getAuthorizedGrantTypes().contains(grant_type)) continue;
            if (this.isMissingRedirectUris(uris)) {
                throw new InvalidClientDetailsException(grant_type + " grant type requires at least one redirect URL.");
            }
            for (String uri : uris) {
                if (UaaUrlUtils.isValidRegisteredRedirectUrl(uri)) continue;
                throw new InvalidClientDetailsException(String.format("One of the redirect_uri is invalid: %s", uri));
            }
        }
    }

    private boolean isMissingRedirectUris(Set<String> uris) {
        return uris == null || uris.isEmpty();
    }

    public static void checkRequestedGrantTypes(Set<String> requestedGrantTypes) {
        for (String grant : requestedGrantTypes) {
            if (VALID_GRANTS.contains(grant)) continue;
            throw new InvalidClientDetailsException(grant + " is not an allowed grant type. Must be one of: " + VALID_GRANTS.toString());
        }
    }
}

