/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.codestore;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.util.Assert;

public class JdbcExpiringCodeStore
implements ExpiringCodeStore {
    public static final String tableName = "expiring_code_store";
    public static final String fields = "code, expiresat, data, intent, identity_zone_id";
    protected static final String insert = "insert into expiring_code_store (code, expiresat, data, intent, identity_zone_id) values (?,?,?,?,?)";
    protected static final String delete = "delete from expiring_code_store where code = ? and identity_zone_id = ?";
    protected static final String deleteIntent = "delete from expiring_code_store where intent = ? and identity_zone_id = ?";
    protected static final String deleteExpired = "delete from expiring_code_store where expiresat < ?";
    private static final JdbcExpiringCodeMapper rowMapper = new JdbcExpiringCodeMapper();
    protected static final String selectAllFields = "select code, expiresat, data, intent, identity_zone_id from expiring_code_store where code = ? and identity_zone_id = ?";
    private Log logger = LogFactory.getLog(this.getClass());
    private RandomValueStringGenerator generator = new RandomValueStringGenerator(10);
    private JdbcTemplate jdbcTemplate;
    private TimeService timeService;
    private AtomicLong lastExpired = new AtomicLong();
    private long expirationInterval = 60000L;

    public long getExpirationInterval() {
        return this.expirationInterval;
    }

    public void setExpirationInterval(long expirationInterval) {
        this.expirationInterval = expirationInterval;
    }

    protected JdbcExpiringCodeStore() {
    }

    public JdbcExpiringCodeStore(DataSource dataSource, TimeService timeService) {
        this.setDataSource(dataSource);
        this.setTimeService(timeService);
    }

    protected void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    protected void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    @Override
    public ExpiringCode generateCode(String data, Timestamp expiresAt, String intent) {
        this.cleanExpiredEntries();
        if (data == null || expiresAt == null) {
            throw new NullPointerException();
        }
        if (expiresAt.getTime() < this.timeService.getCurrentTimeMillis()) {
            throw new IllegalArgumentException();
        }
        for (int count = 0; count < 3; ++count) {
            String code = this.generator.generate();
            try {
                int update = this.jdbcTemplate.update(insert, new Object[]{code, expiresAt.getTime(), data, intent, IdentityZoneHolder.get().getId()});
                if (update == 1) {
                    ExpiringCode expiringCode = new ExpiringCode(code, expiresAt, data, intent);
                    return expiringCode;
                }
                this.logger.warn((Object)("Unable to store expiring code:" + code));
                continue;
            }
            catch (DataIntegrityViolationException x) {
                if (count != 3) continue;
                throw x;
            }
        }
        return null;
    }

    @Override
    public ExpiringCode retrieveCode(String code) {
        this.cleanExpiredEntries();
        if (code == null) {
            throw new NullPointerException();
        }
        try {
            ExpiringCode expiringCode = (ExpiringCode)this.jdbcTemplate.queryForObject(selectAllFields, (RowMapper)rowMapper, new Object[]{code, IdentityZoneHolder.get().getId()});
            if (expiringCode != null) {
                this.jdbcTemplate.update(delete, new Object[]{code, IdentityZoneHolder.get().getId()});
            }
            if (expiringCode.getExpiresAt().getTime() < this.timeService.getCurrentTimeMillis()) {
                expiringCode = null;
            }
            return expiringCode;
        }
        catch (EmptyResultDataAccessException x) {
            return null;
        }
    }

    @Override
    public void setGenerator(RandomValueStringGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void expireByIntent(String intent) {
        Assert.hasText((String)intent);
        this.jdbcTemplate.update(deleteIntent, new Object[]{intent, IdentityZoneHolder.get().getId()});
    }

    public int cleanExpiredEntries() {
        long lastCheck;
        long now = this.timeService.getCurrentTimeMillis();
        if (now - (lastCheck = this.lastExpired.get()) > this.expirationInterval && this.lastExpired.compareAndSet(lastCheck, now)) {
            int count = this.jdbcTemplate.update(deleteExpired, new Object[]{now});
            this.logger.debug((Object)("Expiring code sweeper complete, deleted " + count + " entries."));
            return count;
        }
        return 0;
    }

    protected static class JdbcExpiringCodeMapper
    implements RowMapper<ExpiringCode> {
        protected JdbcExpiringCodeMapper() {
        }

        public ExpiringCode mapRow(ResultSet rs, int rowNum) throws SQLException {
            String code = rs.getString("code");
            Timestamp expiresAt = new Timestamp(rs.getLong("expiresat"));
            String intent = rs.getString("intent");
            String data = rs.getString("data");
            return new ExpiringCode(code, expiresAt, data, intent);
        }
    }
}

