/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.ldap.extension;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.identity.uaa.provider.ldap.ExtendedLdapUserDetails;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.ldap.userdetails.LdapUserDetails;

public class ExtendedLdapUserImpl
implements ExtendedLdapUserDetails {
    private String mailAttributeName = "mail";
    private String givenNameAttributeName;
    private String familyNameAttributeName;
    private String phoneNumberAttributeName;
    private String dn;
    private String password;
    private String username;
    private Collection<? extends GrantedAuthority> authorities = AuthorityUtils.NO_AUTHORITIES;
    private boolean accountNonExpired = true;
    private boolean accountNonLocked = true;
    private boolean credentialsNonExpired = true;
    private boolean enabled = true;
    private Map<String, String[]> attributes = new HashMap<String, String[]>();

    public ExtendedLdapUserImpl(LdapUserDetails details) {
        this.setDn(details.getDn());
        this.setUsername(details.getUsername());
        this.setPassword(details.getPassword());
        this.setEnabled(details.isEnabled());
        this.setAccountNonExpired(details.isAccountNonExpired());
        this.setCredentialsNonExpired(details.isCredentialsNonExpired());
        this.setAccountNonLocked(details.isAccountNonLocked());
        this.setAuthorities(details.getAuthorities());
    }

    public ExtendedLdapUserImpl(LdapUserDetails details, Map<String, String[]> attributes) {
        this(details);
        this.attributes.putAll(attributes);
    }

    public void eraseCredentials() {
    }

    @Override
    public String[] getMail() {
        String[] mail = this.attributes.get(this.getMailAttributeName());
        if (mail == null) {
            mail = new String[]{};
        }
        return mail;
    }

    @Override
    public Map<String, String[]> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public String[] getAttribute(String name, boolean caseSensitive) {
        if (name == null) {
            return null;
        }
        String[] value = this.getAttributes().get(name);
        if (value != null || caseSensitive) {
            return this.getAttributes().get(name);
        }
        for (Map.Entry<String, String[]> a : this.getAttributes().entrySet()) {
            if (!a.getKey().equalsIgnoreCase(name)) continue;
            return a.getValue();
        }
        return null;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        this.accountNonExpired = accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        this.credentialsNonExpired = credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getMailAttributeName() {
        return this.mailAttributeName;
    }

    public void setMailAttributeName(String mailAttributeName) {
        this.mailAttributeName = mailAttributeName;
    }

    public void setPhoneNumberAttributeName(String phoneNumberAttributeName) {
        this.phoneNumberAttributeName = phoneNumberAttributeName;
    }

    public void setGivenNameAttributeName(String givenNameAttributeName) {
        this.givenNameAttributeName = givenNameAttributeName;
    }

    public void setFamilyNameAttributeName(String familyNameAttributeName) {
        this.familyNameAttributeName = familyNameAttributeName;
    }

    @Override
    public String getEmailAddress() {
        String[] mailAddresses = this.getMail();
        return mailAddresses.length == 0 ? null : mailAddresses[0];
    }

    @Override
    public String getGivenName() {
        return this.getFirst(this.givenNameAttributeName, false);
    }

    @Override
    public String getFamilyName() {
        return this.getFirst(this.familyNameAttributeName, false);
    }

    @Override
    public String getPhoneNumber() {
        return this.getFirst(this.phoneNumberAttributeName, false);
    }

    @Override
    public String getExternalId() {
        return this.getDn();
    }

    protected String getFirst(String attributeName, boolean caseSensitive) {
        String[] result = this.getAttribute(attributeName, caseSensitive);
        if (result != null && result.length > 0) {
            return result[0];
        }
        return null;
    }
}

