/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.EntityDeletedEvent;
import org.cloudfoundry.identity.uaa.authentication.SystemAuthentication;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderWrapper;
import org.cloudfoundry.identity.uaa.provider.KeystoneIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.LdapIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.LockoutPolicy;
import org.cloudfoundry.identity.uaa.provider.PasswordPolicy;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.BootstrapSamlIdentityProviderData;
import org.cloudfoundry.identity.uaa.util.LdapUtils;
import org.cloudfoundry.identity.uaa.util.UaaMapUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.json.JSONException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.core.Authentication;

public class IdentityProviderBootstrap
implements InitializingBean,
ApplicationListener<ContextRefreshedEvent>,
ApplicationEventPublisherAware {
    private static Log logger = LogFactory.getLog(IdentityProviderBootstrap.class);
    private IdentityProviderProvisioning provisioning;
    private List<IdentityProviderWrapper> providers = new LinkedList<IdentityProviderWrapper>();
    private BootstrapSamlIdentityProviderData configurator;
    private List<IdentityProviderWrapper> oauthIdpDefintions;
    private Map<String, Object> ldapConfig;
    private Map<String, Object> keystoneConfig;
    private Environment environment;
    private PasswordPolicy defaultPasswordPolicy;
    private LockoutPolicy defaultLockoutPolicy;
    private boolean disableInternalUserManagement;
    private List<String> originsToDelete = null;
    private ApplicationEventPublisher publisher;

    public IdentityProviderBootstrap(IdentityProviderProvisioning provisioning, Environment environment) {
        if (provisioning == null) {
            throw new NullPointerException("Constructor argument can't be null.");
        }
        this.provisioning = provisioning;
        this.environment = environment;
    }

    private void addOauthProviders() {
        if (this.oauthIdpDefintions == null) {
            return;
        }
        for (IdentityProviderWrapper wrapper : this.oauthIdpDefintions) {
            this.validateDuplicateAlias(wrapper.getProvider().getOriginKey());
            this.providers.add(wrapper);
        }
    }

    public void validateDuplicateAlias(String originKey) {
        for (IdentityProvider provider : this.providers.stream().map(IdentityProviderWrapper::getProvider).collect(Collectors.toList())) {
            if (!provider.getOriginKey().equals(originKey)) continue;
            throw new IllegalArgumentException("Provider alias " + originKey + " is not unique.");
        }
    }

    public void setSamlProviders(BootstrapSamlIdentityProviderData configurator) {
        this.configurator = configurator;
    }

    protected void addSamlProviders() {
        if (this.configurator == null) {
            return;
        }
        for (IdentityProviderWrapper<SamlIdentityProviderDefinition> wrapper : this.configurator.getSamlProviders()) {
            this.validateDuplicateAlias(wrapper.getProvider().getOriginKey());
            this.providers.add(wrapper);
        }
    }

    public void setLdapConfig(HashMap<String, Object> ldapConfig) {
        this.ldapConfig = ldapConfig;
    }

    protected void addLdapProvider() {
        boolean override;
        boolean ldapProfile = Arrays.asList(this.environment.getActiveProfiles()).contains("ldap");
        IdentityProvider provider = new IdentityProvider();
        provider.setActive(ldapProfile);
        provider.setOriginKey("ldap");
        provider.setType("ldap");
        provider.setName("UAA LDAP Provider");
        HashMap<String, Object> ldap = new HashMap<String, Object>();
        ldap.put("ldap", this.ldapConfig);
        LdapIdentityProviderDefinition json = this.getLdapConfigAsDefinition(ldap);
        provider.setConfig((AbstractIdentityProviderDefinition)json);
        provider.setActive(ldapProfile && json.isConfigured() != false);
        boolean bl = override = this.ldapConfig == null || this.ldapConfig.get("override") == null ? true : (Boolean)this.ldapConfig.get("override");
        if (!override) {
            IdentityProvider existing = this.getProviderByOrigin("ldap", IdentityZone.getUaa().getId());
            override = existing == null || existing.getConfig() == null;
        }
        IdentityProviderWrapper wrapper = new IdentityProviderWrapper(provider);
        wrapper.setOverride(override);
        this.providers.add(wrapper);
    }

    protected LdapIdentityProviderDefinition getLdapConfigAsDefinition(Map<String, Object> ldapConfig) {
        ldapConfig = UaaMapUtils.flatten(ldapConfig);
        this.populateLdapEnvironment(ldapConfig);
        if (ldapConfig.isEmpty()) {
            return new LdapIdentityProviderDefinition();
        }
        return LdapUtils.fromConfig(ldapConfig);
    }

    protected void populateLdapEnvironment(Map<String, Object> ldapConfig) {
        AbstractEnvironment env = (AbstractEnvironment)this.environment;
        for (String property : LdapIdentityProviderDefinition.LDAP_PROPERTY_NAMES) {
            if (!env.containsProperty(property) || LdapIdentityProviderDefinition.LDAP_PROPERTY_TYPES.get(property) == null) continue;
            ldapConfig.put(property, env.getProperty(property, (Class)LdapIdentityProviderDefinition.LDAP_PROPERTY_TYPES.get(property)));
        }
        Map<String, Object> stringProperties = UaaMapUtils.getPropertiesStartingWith((ConfigurableEnvironment)env, "ldap.");
        for (Map.Entry<String, Object> entry : stringProperties.entrySet()) {
            if (LdapIdentityProviderDefinition.LDAP_PROPERTY_NAMES.contains(entry.getKey())) continue;
            ldapConfig.put(entry.getKey(), entry.getValue());
        }
    }

    public void setKeystoneConfig(HashMap<String, Object> keystoneConfig) {
        this.keystoneConfig = keystoneConfig;
    }

    protected AbstractIdentityProviderDefinition getKeystoneDefinition(Map<String, Object> config) {
        return new KeystoneIdentityProviderDefinition(config);
    }

    protected void addKeystoneProvider() {
        boolean keystoneProfile = Arrays.asList(this.environment.getActiveProfiles()).contains("keystone");
        if (this.keystoneConfig != null || keystoneProfile) {
            boolean active = keystoneProfile && this.keystoneConfig != null;
            IdentityProvider provider = new IdentityProvider();
            provider.setOriginKey("keystone");
            provider.setType("keystone");
            provider.setName("UAA Keystone Provider");
            provider.setActive(active);
            provider.setConfig(this.getKeystoneDefinition(this.keystoneConfig));
            this.providers.add(new IdentityProviderWrapper(provider));
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.deleteIdentityProviders(IdentityZone.getUaa().getId());
    }

    public void afterPropertiesSet() throws Exception {
        this.providers.clear();
        this.addLdapProvider();
        this.addSamlProviders();
        this.addOauthProviders();
        this.addKeystoneProvider();
        String zoneId = IdentityZone.getUaa().getId();
        for (IdentityProviderWrapper wrapper : this.providers) {
            IdentityProvider provider = wrapper.getProvider();
            if (this.getOriginsToDelete().contains(provider.getOriginKey())) continue;
            IdentityProvider existing = this.getProviderByOrigin(provider.getOriginKey(), zoneId);
            provider.setIdentityZoneId(zoneId);
            if (existing == null) {
                this.provisioning.create(provider, zoneId);
                continue;
            }
            if (!wrapper.isOverride()) continue;
            provider.setId(existing.getId());
            provider.setCreated(existing.getCreated());
            provider.setVersion(existing.getVersion());
            provider.setLastModified(new Date(System.currentTimeMillis()));
            this.provisioning.update(provider, zoneId);
        }
        this.updateDefaultZoneUaaIDP();
    }

    public IdentityProvider getProviderByOrigin(String origin, String zoneId) {
        try {
            return this.provisioning.retrieveByOrigin(origin, zoneId);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }

    private void deleteIdentityProviders(String zoneId) {
        for (String origin : this.getOriginsToDelete()) {
            if ("uaa".equals(origin) || "ldap".equals(origin)) continue;
            try {
                logger.debug((Object)("Attempting to deactivating identity provider:" + origin));
                IdentityProvider provider = this.provisioning.retrieveByOrigin(origin, zoneId);
                EntityDeletedEvent<IdentityProvider> event = new EntityDeletedEvent<IdentityProvider>(provider, (Authentication)SystemAuthentication.SYSTEM_AUTHENTICATION);
                if (this.publisher != null) {
                    this.publisher.publishEvent(event);
                    logger.debug((Object)("Identity provider deactivated:" + origin));
                    continue;
                }
                logger.warn((Object)String.format("Unable to delete identity provider with origin '%s', no application publisher", origin));
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {}
        }
    }

    protected void updateDefaultZoneUaaIDP() throws JSONException {
        String zoneId = IdentityZone.getUaa().getId();
        IdentityProvider internalIDP = this.provisioning.retrieveByOrigin("uaa", IdentityZone.getUaa().getId());
        UaaIdentityProviderDefinition identityProviderDefinition = new UaaIdentityProviderDefinition(this.defaultPasswordPolicy, this.defaultLockoutPolicy, this.disableInternalUserManagement);
        internalIDP.setConfig((AbstractIdentityProviderDefinition)identityProviderDefinition);
        String disableInternalAuth = this.environment.getProperty("disableInternalAuth");
        internalIDP.setActive(!this.getBooleanValue(disableInternalAuth, false));
        this.provisioning.update(internalIDP, zoneId);
    }

    protected boolean getBooleanValue(String s, boolean defaultValue) {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    public void setDefaultPasswordPolicy(PasswordPolicy defaultPasswordPolicy) {
        this.defaultPasswordPolicy = defaultPasswordPolicy;
    }

    public void setDefaultLockoutPolicy(LockoutPolicy defaultLockoutPolicy) {
        this.defaultLockoutPolicy = defaultLockoutPolicy;
    }

    public boolean isDisableInternalUserManagement() {
        return this.disableInternalUserManagement;
    }

    public void setDisableInternalUserManagement(boolean disableInternalUserManagement) {
        this.disableInternalUserManagement = disableInternalUserManagement;
    }

    public void setOauthIdpDefinitions(List<IdentityProviderWrapper> oauthIdpDefintions) {
        this.oauthIdpDefintions = oauthIdpDefintions;
    }

    public void setOriginsToDelete(List<String> originsToDelete) {
        this.originsToDelete = originsToDelete;
    }

    public List<String> getOriginsToDelete() {
        return Optional.ofNullable(this.originsToDelete).orElse(Collections.emptyList());
    }
}

