/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.metrics;

import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.TimeServiceImpl;

public class IdleTimer {
    TimeService timeService = new TimeServiceImpl();
    private long inflightRequests = 0L;
    private long idleTime = 0L;
    private long lastIdleStart = this.timeService.getCurrentTimeMillis();
    private final long startTime = this.timeService.getCurrentTimeMillis();
    private long requestCount = 0L;

    public synchronized void endRequest() {
        switch ((int)(--this.inflightRequests)) {
            case 0: {
                this.lastIdleStart = this.timeService.getCurrentTimeMillis();
                break;
            }
            case -1: {
                throw new IllegalStateException("Illegal end request invocation, no request in flight");
            }
        }
        ++this.requestCount;
    }

    public synchronized void startRequest() {
        switch ((int)(++this.inflightRequests)) {
            case 1: {
                this.idleTime += this.timeService.getCurrentTimeMillis() - this.lastIdleStart;
                break;
            }
        }
    }

    public long getInflightRequests() {
        return this.inflightRequests;
    }

    public synchronized long getIdleTime() {
        if (this.inflightRequests == 0L) {
            return this.timeService.getCurrentTimeMillis() - this.lastIdleStart + this.idleTime;
        }
        return this.idleTime;
    }

    public long getRunTime() {
        return this.timeService.getCurrentTimeMillis() - this.startTime;
    }

    protected long getRequestCount() {
        return this.requestCount;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }
}

