/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider;

import java.util.Map;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderConfigValidator;

public class IdentityProviderConfigValidationDelegator
implements IdentityProviderConfigValidator {
    private Map<String, IdentityProviderConfigValidator> delegates;

    public void setDelegates(Map<String, IdentityProviderConfigValidator> delegates) {
        this.delegates = delegates;
    }

    @Override
    public void validate(IdentityProvider<? extends AbstractIdentityProviderDefinition> provider) {
        String type;
        if (provider == null) {
            throw new IllegalArgumentException("Provider cannot be null");
        }
        switch (type = provider.getType()) {
            case "oauth2.0": 
            case "oidc1.0": {
                this.delegates.get("xoauth").validate(provider);
                break;
            }
            case "uaa": {
                this.delegates.get("uaa").validate(provider);
                break;
            }
            case "ldap": {
                this.delegates.get("ldap").validate(provider);
            }
        }
    }
}

