/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.identity.uaa.impl.config.LegacyTokenKey;
import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.KeyInfoBuilder;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.util.StringUtils;

public class KeyInfoService {
    private String uaaBaseURL;

    public KeyInfoService(String uaaBaseURL) {
        this.uaaBaseURL = uaaBaseURL;
    }

    public KeyInfo getKey(String keyId) {
        return this.getKeys().get(keyId);
    }

    public Map<String, KeyInfo> getKeys() {
        IdentityZoneConfiguration config = IdentityZoneHolder.get().getConfig();
        if (config == null || config.getTokenPolicy().getKeys() == null || config.getTokenPolicy().getKeys().isEmpty()) {
            config = IdentityZoneHolder.getUaaZone().getConfig();
        }
        HashMap<String, KeyInfo> keys = new HashMap<String, KeyInfo>();
        for (Map.Entry entry : config.getTokenPolicy().getKeys().entrySet()) {
            KeyInfo keyInfo = KeyInfoBuilder.build((String)entry.getKey(), (String)entry.getValue(), UaaUrlUtils.addSubdomainToUrl(this.uaaBaseURL));
            keys.put((String)entry.getKey(), keyInfo);
        }
        if (keys.isEmpty()) {
            keys.put("legacy-token-key", LegacyTokenKey.getLegacyTokenKeyInfo());
        }
        return keys;
    }

    public KeyInfo getActiveKey() {
        return this.getKeys().get(this.getActiveKeyId());
    }

    private String getActiveKeyId() {
        Map<String, KeyInfo> keys;
        IdentityZoneConfiguration config = IdentityZoneHolder.get().getConfig();
        if (config == null) {
            return IdentityZoneHolder.getUaaZone().getConfig().getTokenPolicy().getActiveKeyId();
        }
        String activeKeyId = config.getTokenPolicy().getActiveKeyId();
        if (!StringUtils.hasText((String)activeKeyId) && (keys = this.getKeys()).size() == 1) {
            activeKeyId = (String)keys.keySet().stream().findAny().get();
        }
        if (!StringUtils.hasText((String)activeKeyId)) {
            activeKeyId = IdentityZoneHolder.getUaaZone().getConfig().getTokenPolicy().getActiveKeyId();
        }
        if (!StringUtils.hasText((String)activeKeyId)) {
            activeKeyId = "legacy-token-key";
        }
        return activeKeyId;
    }
}

