/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.util.LinkedMaskingMultiValueMap;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class RestAuthenticationManager
implements AuthenticationManager {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private RestOperations restTemplate = new RestTemplate();
    private static String DEFAULT_LOGIN_URL = "http://uaa.cloudfoundry.com/authenticate";
    private String remoteUrl = DEFAULT_LOGIN_URL;
    private boolean nullPassword = false;

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public RestOperations getRestTemplate() {
        return this.restTemplate;
    }

    public RestAuthenticationManager() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            protected boolean hasError(HttpStatus statusCode) {
                return statusCode.series() == HttpStatus.Series.SERVER_ERROR;
            }
        });
        this.restTemplate = restTemplate;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        HttpHeaders headers = this.getHeaders();
        ResponseEntity response = this.restTemplate.exchange(this.remoteUrl, HttpMethod.POST, new HttpEntity(this.getParameters(username, password), (MultiValueMap)headers), Map.class, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK || response.getStatusCode() == HttpStatus.CREATED) {
            if (this.evaluateResponse(authentication, (ResponseEntity<Map>)response)) {
                this.logger.info((Object)("Successful authentication request for " + authentication.getName()));
                return new UsernamePasswordAuthenticationToken((Object)username, (Object)(this.nullPassword ? null : ""), UaaAuthority.USER_AUTHORITIES);
            }
        } else {
            if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                this.logger.info((Object)"Failed authentication request");
                throw new BadCredentialsException("Authentication failed");
            }
            if (response.getStatusCode() == HttpStatus.INTERNAL_SERVER_ERROR) {
                this.logger.info((Object)"Internal error from UAA. Please Check the UAA logs.");
            } else {
                this.logger.error((Object)("Unexpected status code " + response.getStatusCode() + " from the UAA. Is a compatible version running?"));
            }
        }
        throw new RuntimeException("Could not authenticate with remote server");
    }

    protected boolean evaluateResponse(Authentication authentication, ResponseEntity<Map> response) {
        String userFromUaa = (String)((Map)response.getBody()).get("username");
        return userFromUaa.equals(authentication.getPrincipal().toString());
    }

    protected Object getParameters(String username, String password) {
        LinkedMaskingMultiValueMap parameters = new LinkedMaskingMultiValueMap("password");
        parameters.set("username", username);
        parameters.set("password", password);
        return parameters;
    }

    protected HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        return headers;
    }

    public boolean isNullPassword() {
        return this.nullPassword;
    }

    public void setNullPassword(boolean nullPassword) {
        this.nullPassword = nullPassword;
    }
}

