/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.cloudfoundry.identity.uaa.provider.saml.ConfigMetadataProvider;
import org.cloudfoundry.identity.uaa.provider.saml.FixedHttpMetaDataProvider;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProvider;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderHolder;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderProvisioning;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;

public class SamlServiceProviderConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(SamlServiceProviderConfigurator.class);
    private FixedHttpMetaDataProvider fixedHttpMetaDataProvider;
    private BasicParserPool parserPool;
    private SamlServiceProviderProvisioning providerProvisioning;
    private Set<String> supportedNameIDs = new HashSet<String>(Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));

    public List<SamlServiceProviderHolder> getSamlServiceProviders() {
        return this.getSamlServiceProvidersForZone(IdentityZoneHolder.get());
    }

    public List<SamlServiceProviderHolder> getSamlServiceProvidersForZone(IdentityZone zone) {
        LinkedList<SamlServiceProviderHolder> result = new LinkedList<SamlServiceProviderHolder>();
        for (SamlServiceProvider provider : this.providerProvisioning.retrieveActive(zone.getId())) {
            try {
                SamlServiceProviderHolder samlServiceProviderHolder = new SamlServiceProviderHolder(this.getExtendedMetadataDelegate(provider), provider);
                result.add(samlServiceProviderHolder);
            }
            catch (MetadataProviderException e) {
                LOG.error("Unable to configure SAML SP Metadata for ServiceProvider:" + provider.getEntityId(), (Throwable)e);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public void validateSamlServiceProvider(SamlServiceProvider provider) throws MetadataProviderException {
        this.validateSamlServiceProvider(provider, IdentityZoneHolder.get());
    }

    synchronized void validateSamlServiceProvider(SamlServiceProvider provider, IdentityZone zone) throws MetadataProviderException {
        if (provider == null) {
            throw new NullPointerException();
        }
        if (!StringUtils.hasText((String)provider.getIdentityZoneId())) {
            throw new NullPointerException("You must set the SAML SP Identity Zone Id.");
        }
        if (!zone.getId().equals(provider.getIdentityZoneId())) {
            throw new IllegalArgumentException("The SAML SP Identity Zone Id does not match the curent zone.");
        }
        ExtendedMetadataDelegate added = this.getExtendedMetadataDelegate(provider);
        String metadataEntityId = ((ConfigMetadataProvider)added.getDelegate()).getEntityID();
        if (provider.getEntityId() == null) {
            provider.setEntityId(metadataEntityId);
        } else if (!metadataEntityId.equals(provider.getEntityId())) {
            throw new MetadataProviderException("Metadata entity id does not match SAML SP entity id: " + provider.getEntityId());
        }
        added.initialize();
        SPSSODescriptor spSsoDescriptor = added.getEntityDescriptor(metadataEntityId).getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (null != spSsoDescriptor && null != spSsoDescriptor.getNameIDFormats() && !spSsoDescriptor.getNameIDFormats().isEmpty() && !spSsoDescriptor.getNameIDFormats().stream().anyMatch(format -> this.supportedNameIDs.contains(format.getFormat()))) {
            throw new MetadataProviderException("UAA does not support any of the NameIDFormats specified in the metadata for entity: " + provider.getEntityId());
        }
        List<SamlServiceProviderHolder> serviceProviders = this.getSamlServiceProvidersForZone(zone);
    }

    public ExtendedMetadataDelegate getExtendedMetadataDelegate(SamlServiceProvider provider) throws MetadataProviderException {
        ExtendedMetadataDelegate metadata;
        switch (provider.getConfig().getType()) {
            case DATA: {
                metadata = this.configureXMLMetadata(provider);
                break;
            }
            case URL: {
                metadata = this.configureURLMetadata(provider);
                break;
            }
            default: {
                throw new MetadataProviderException("Invalid metadata type for alias[" + provider.getEntityId() + "]:" + provider.getConfig().getMetaDataLocation());
            }
        }
        return metadata;
    }

    protected ExtendedMetadataDelegate configureXMLMetadata(SamlServiceProvider provider) {
        ConfigMetadataProvider configMetadataProvider = new ConfigMetadataProvider(provider.getIdentityZoneId(), provider.getEntityId(), provider.getConfig().getMetaDataLocation());
        configMetadataProvider.setParserPool((ParserPool)this.getParserPool());
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setLocal(false);
        extendedMetadata.setAlias(provider.getEntityId());
        ExtendedMetadataDelegate delegate = new ExtendedMetadataDelegate((MetadataProvider)configMetadataProvider, extendedMetadata);
        delegate.setMetadataTrustCheck(provider.getConfig().isMetadataTrustCheck());
        return delegate;
    }

    protected ExtendedMetadataDelegate configureURLMetadata(SamlServiceProvider provider) throws MetadataProviderException {
        byte[] metadata;
        SamlServiceProviderDefinition def = provider.getConfig().clone();
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setAlias(provider.getEntityId());
        try {
            metadata = this.fixedHttpMetaDataProvider.fetchMetadata(def.getMetaDataLocation(), def.isSkipSslValidation());
        }
        catch (RestClientException e) {
            throw new MetadataProviderException("Unavailable Metadata Provider", (Exception)((Object)e));
        }
        catch (URISyntaxException e) {
            throw new MetadataProviderException("Invalid metadata URI: " + def.getMetaDataLocation(), (Exception)e);
        }
        def.setMetaDataLocation(new String(metadata, StandardCharsets.UTF_8));
        return this.configureXMLMetadata(provider);
    }

    public SamlServiceProviderProvisioning getProviderProvisioning() {
        return this.providerProvisioning;
    }

    public void setProviderProvisioning(SamlServiceProviderProvisioning providerProvisioning) {
        this.providerProvisioning = providerProvisioning;
    }

    public BasicParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(BasicParserPool parserPool) {
        this.parserPool = parserPool;
    }

    public void setSupportedNameIDs(Set<String> supportedNameIDs) {
        this.supportedNameIDs = supportedNameIDs;
    }

    public void setFixedHttpMetaDataProvider(FixedHttpMetaDataProvider fixedHttpMetaDataProvider) {
        this.fixedHttpMetaDataProvider = fixedHttpMetaDataProvider;
    }
}

