/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class UaaUserApprovalHandler
implements UserApprovalHandler {
    private Log logger = LogFactory.getLog(this.getClass());
    private boolean useTokenServices = true;
    private String approvalParameter = "user_oauth_approval";
    private ClientServicesExtension clientDetailsService;
    private OAuth2RequestFactory requestFactory;
    private AuthorizationServerTokenServices tokenServices;

    public void setTokenServices(AuthorizationServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void setRequestFactory(OAuth2RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public void setApprovalParameter(String approvalParameter) {
        this.approvalParameter = approvalParameter;
    }

    public void setClientDetailsService(ClientServicesExtension clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setUseTokenServices(boolean useTokenServices) {
        this.useTokenServices = useTokenServices;
    }

    public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        Set requestedScopes;
        ClientDetails client;
        if (!userAuthentication.isAuthenticated()) {
            return false;
        }
        if (authorizationRequest.isApproved()) {
            return true;
        }
        String clientId = authorizationRequest.getClientId();
        boolean approved = false;
        if (this.clientDetailsService != null && this.isAutoApprove(client = this.clientDetailsService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId()), requestedScopes = authorizationRequest.getScope())) {
            approved = true;
        }
        return approved;
    }

    private boolean isAutoApprove(ClientDetails client, Collection<String> scopes) {
        BaseClientDetails baseClient = (BaseClientDetails)client;
        if (baseClient.getAutoApproveScopes() != null) {
            if (baseClient.getAutoApproveScopes().contains("true")) {
                return true;
            }
            if (baseClient.getAutoApproveScopes().containsAll(scopes)) {
                return true;
            }
        }
        return false;
    }

    public AuthorizationRequest checkForPreApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        boolean approved = false;
        String clientId = authorizationRequest.getClientId();
        Set scopes = authorizationRequest.getScope();
        if (this.clientDetailsService != null) {
            try {
                ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
                approved = true;
                for (String scope : scopes) {
                    if (client.isAutoApprove(scope)) continue;
                    approved = false;
                }
                if (approved) {
                    authorizationRequest.setApproved(true);
                    return authorizationRequest;
                }
            }
            catch (ClientRegistrationException e) {
                this.logger.warn((Object)("Client registration problem prevent autoapproval check for client=" + clientId));
            }
        }
        OAuth2Request storedOAuth2Request = this.requestFactory.createOAuth2Request(authorizationRequest);
        OAuth2Authentication authentication = new OAuth2Authentication(storedOAuth2Request, userAuthentication);
        if (this.logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Looking up existing token for ");
            builder.append("client_id=" + clientId);
            builder.append(", scope=" + scopes);
            builder.append(" and username=" + userAuthentication.getName());
            this.logger.debug((Object)builder.toString());
        }
        OAuth2AccessToken accessToken = this.tokenServices.getAccessToken(authentication);
        this.logger.debug((Object)("Existing access token=" + accessToken));
        if (accessToken != null && !accessToken.isExpired()) {
            this.logger.debug((Object)("User already approved with token=" + accessToken));
            approved = true;
        } else {
            this.logger.debug((Object)"Checking explicit approval");
            approved = userAuthentication.isAuthenticated() && approved;
        }
        authorizationRequest.setApproved(approved);
        return authorizationRequest;
    }

    public AuthorizationRequest updateAfterApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        Map approvalParameters = authorizationRequest.getApprovalParameters();
        String flag = (String)approvalParameters.get(this.approvalParameter);
        boolean approved = flag != null && flag.toLowerCase().equals("true");
        authorizationRequest.setApproved(approved);
        return authorizationRequest;
    }

    public Map<String, Object> getUserApprovalRequest(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(authorizationRequest.getRequestParameters());
        return model;
    }
}

