/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.web;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.StringUtils;

public class UaaSavedRequestCache
extends HttpSessionRequestCache
implements Filter {
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (this.shouldSaveFormRedirectParameter(request) && this.notAuthenticated()) {
            this.saveClientRedirect(request, request.getParameter("form_redirect_uri"));
        }
        chain.doFilter((ServletRequest)request, res);
    }

    public boolean notAuthenticated() {
        return SecurityContextHolder.getContext().getAuthentication() == null || !SecurityContextHolder.getContext().getAuthentication().isAuthenticated();
    }

    public void saveRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.shouldSaveFormRedirectParameter(request)) {
            this.saveClientRedirect(request, request.getParameter("form_redirect_uri"));
        } else if (HttpMethod.GET.name().equals(request.getMethod())) {
            this.saveClientRedirect(request, UrlUtils.buildFullRequestUrl((HttpServletRequest)request));
        } else {
            super.saveRequest(request, response);
        }
    }

    public void saveClientRedirect(HttpServletRequest request, String redirectUrl) {
        HttpSession session = request.getSession(true);
        session.setAttribute("SPRING_SECURITY_SAVED_REQUEST", (Object)new ClientRedirectSavedRequest(request, redirectUrl));
    }

    protected boolean shouldSaveFormRedirectParameter(HttpServletRequest request) {
        String formRedirect = request.getParameter("form_redirect_uri");
        if (!HttpMethod.POST.name().equals(request.getMethod())) {
            return false;
        }
        if (StringUtils.isEmpty((Object)formRedirect)) {
            return false;
        }
        if (!UaaUrlUtils.uriHasMatchingHost(formRedirect, request.getServerName())) {
            return false;
        }
        if (UaaSavedRequestCache.hasSavedRequest(request)) {
            return false;
        }
        return HttpMethod.POST.name().equals(request.getMethod());
    }

    protected static boolean hasSavedRequest(HttpServletRequest request) {
        return UaaSavedRequestCache.getSavedRequest(request) != null;
    }

    protected static SavedRequest getSavedRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session == null ? null : (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public static class ClientRedirectSavedRequest
    extends DefaultSavedRequest {
        private final String redirectUrl;
        private final Map<String, String[]> parameters;

        public ClientRedirectSavedRequest(HttpServletRequest request, String redirectUrl) {
            super(request, req -> req.getServerPort());
            this.redirectUrl = redirectUrl;
            this.parameters = Collections.unmodifiableMap(UaaUrlUtils.getParameterMap(redirectUrl));
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }

        public List<Cookie> getCookies() {
            return Collections.emptyList();
        }

        public String getMethod() {
            return HttpMethod.GET.name();
        }

        public List<String> getHeaderValues(String name) {
            return Collections.emptyList();
        }

        public Collection<String> getHeaderNames() {
            return Collections.emptyList();
        }

        public List<Locale> getLocales() {
            return Collections.emptyList();
        }

        public String[] getParameterValues(String name) {
            return this.parameters.get(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameters;
        }

        public Collection<String> getParameterNames() {
            return this.parameters.keySet();
        }

        public boolean doesRequestMatch(HttpServletRequest request, PortResolver portResolver) {
            boolean result = UrlUtils.buildFullRequestUrl((HttpServletRequest)request).equals(this.redirectUrl);
            String formRedirect = request.getParameter("form_redirect_uri");
            if (!result && HttpMethod.POST.name().equals(request.getMethod()) && StringUtils.hasText((String)formRedirect)) {
                result = formRedirect.equals(this.getRedirectUrl());
            }
            return result;
        }
    }
}

