/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.cloudfoundry.identity.uaa.authentication.AccountNotVerifiedException;
import org.cloudfoundry.identity.uaa.authentication.AuthenticationPolicyRejectionException;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.authentication.event.IdentityProviderAuthenticationFailureEvent;
import org.cloudfoundry.identity.uaa.authentication.event.IdentityProviderAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.authentication.event.UnverifiedUserAuthenticationEvent;
import org.cloudfoundry.identity.uaa.authentication.event.UserAuthenticationFailureEvent;
import org.cloudfoundry.identity.uaa.authentication.event.UserNotFoundEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.AccountLoginPolicy;
import org.cloudfoundry.identity.uaa.logging.SanitizedLogFactory;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationFailureLockedEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class AuthzAuthenticationManager
implements AuthenticationManager,
ApplicationEventPublisherAware {
    private final SanitizedLogFactory.SanitizedLog logger = SanitizedLogFactory.getLog(this.getClass());
    private final PasswordEncoder encoder;
    private final UaaUserDatabase userDatabase;
    private ApplicationEventPublisher eventPublisher;
    private AccountLoginPolicy accountLoginPolicy;
    private IdentityProviderProvisioning providerProvisioning;
    private String origin;
    private boolean allowUnverifiedUsers = true;

    public AuthzAuthenticationManager(UaaUserDatabase userDatabase, PasswordEncoder encoder, IdentityProviderProvisioning providerProvisioning) {
        this.userDatabase = userDatabase;
        this.encoder = encoder;
        this.providerProvisioning = providerProvisioning;
    }

    public Authentication authenticate(Authentication req) throws AuthenticationException {
        this.logger.debug("Processing authentication request for " + req.getName());
        if (req.getCredentials() == null) {
            BadCredentialsException e = new BadCredentialsException("No password supplied");
            this.publish((ApplicationEvent)new AuthenticationFailureBadCredentialsEvent(req, (AuthenticationException)((Object)e)));
            throw e;
        }
        UaaUser user = this.getUaaUser(req);
        if (user == null) {
            this.logger.debug("No user named '" + req.getName() + "' was found for origin:" + this.origin);
            this.publish(new UserNotFoundEvent(req));
        } else {
            boolean passwordMatches;
            if (!this.accountLoginPolicy.isAllowed(user, req)) {
                this.logger.warn("Login policy rejected authentication for " + user.getUsername() + ", " + user.getId() + ". Ignoring login request.");
                AuthenticationPolicyRejectionException e = new AuthenticationPolicyRejectionException("Your account has been locked because of too many failed attempts to login.");
                this.publish((ApplicationEvent)new AuthenticationFailureLockedEvent(req, (AuthenticationException)e));
                throw e;
            }
            boolean bl = passwordMatches = ((CharSequence)req.getCredentials()).length() != 0 && this.encoder.matches((CharSequence)req.getCredentials(), user.getPassword());
            if (!passwordMatches) {
                this.logger.debug("Password did not match for user " + req.getName());
                this.publish(new IdentityProviderAuthenticationFailureEvent(req, req.getName(), "uaa"));
                this.publish(new UserAuthenticationFailureEvent(user, req));
            } else {
                this.logger.debug("Password successfully matched for userId[" + user.getUsername() + "]:" + user.getId());
                if (!(this.allowUnverifiedUsers && user.isLegacyVerificationBehavior() || user.isVerified())) {
                    this.publish(new UnverifiedUserAuthenticationEvent(user, req));
                    this.logger.debug("Account not verified: " + user.getId());
                    throw new AccountNotVerifiedException("Account not verified");
                }
                UaaAuthentication success = new UaaAuthentication(new UaaPrincipal(user), user.getAuthorities(), (UaaAuthenticationDetails)req.getDetails());
                if (this.checkPasswordExpired(user.getPasswordLastModified())) {
                    user.setPasswordChangeRequired(true);
                }
                success.setAuthenticationMethods(Collections.singleton("pwd"));
                Date passwordNewerThan = this.getPasswordNewerThan();
                if (passwordNewerThan != null && (user.getPasswordLastModified() == null || passwordNewerThan.getTime() > user.getPasswordLastModified().getTime())) {
                    this.logger.info("Password change required for user: " + user.getEmail());
                    success.setRequiresPasswordChange(true);
                }
                if (user.isPasswordChangeRequired()) {
                    this.logger.info("Password change required for user: " + user.getEmail());
                    success.setRequiresPasswordChange(true);
                }
                this.publish(new IdentityProviderAuthenticationSuccessEvent(user, success, "uaa"));
                return success;
            }
        }
        BadCredentialsException e = new BadCredentialsException("Bad credentials");
        this.publish((ApplicationEvent)new AuthenticationFailureBadCredentialsEvent(req, (AuthenticationException)((Object)e)));
        throw e;
    }

    protected int getPasswordExpiresInMonths() {
        UaaIdentityProviderDefinition idpDefinition;
        int result = 0;
        IdentityProvider provider = this.providerProvisioning.retrieveByOrigin("uaa", IdentityZoneHolder.get().getId());
        if (provider != null && (idpDefinition = (UaaIdentityProviderDefinition)ObjectUtils.castInstance((Object)provider.getConfig(), UaaIdentityProviderDefinition.class)) != null && null != idpDefinition.getPasswordPolicy()) {
            return idpDefinition.getPasswordPolicy().getExpirePasswordInMonths();
        }
        return result;
    }

    protected Date getPasswordNewerThan() {
        UaaIdentityProviderDefinition idpDefinition;
        Date result = null;
        IdentityProvider provider = this.providerProvisioning.retrieveByOrigin("uaa", IdentityZoneHolder.get().getId());
        if (provider != null && (idpDefinition = (UaaIdentityProviderDefinition)ObjectUtils.castInstance((Object)provider.getConfig(), UaaIdentityProviderDefinition.class)) != null && idpDefinition.getPasswordPolicy() != null) {
            return idpDefinition.getPasswordPolicy().getPasswordNewerThan();
        }
        return result;
    }

    private UaaUser getUaaUser(Authentication req) {
        try {
            UaaUser user = this.userDatabase.retrieveUserByName(req.getName().toLowerCase(Locale.US), this.getOrigin());
            if (user != null) {
                return user;
            }
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private void publish(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public AccountLoginPolicy getAccountLoginPolicy() {
        return this.accountLoginPolicy;
    }

    public void setAccountLoginPolicy(AccountLoginPolicy accountLoginPolicy) {
        this.accountLoginPolicy = accountLoginPolicy;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setAllowUnverifiedUsers(boolean allowUnverifiedUsers) {
        this.allowUnverifiedUsers = allowUnverifiedUsers;
    }

    private boolean checkPasswordExpired(Date passwordLastModified) {
        int expiringPassword = this.getPasswordExpiresInMonths();
        if (expiringPassword > 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(passwordLastModified.getTime());
            cal.add(2, expiringPassword);
            if (cal.getTimeInMillis() < System.currentTimeMillis()) {
                return true;
            }
        }
        return false;
    }
}

