/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.springframework.http.MediaType;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.csrf.InvalidCsrfTokenException;
import org.springframework.security.web.csrf.MissingCsrfTokenException;
import org.springframework.util.StringUtils;

public class CsrfAwareEntryPointAndDeniedHandler
implements AccessDeniedHandler,
AuthenticationEntryPoint {
    private static Log logger = LogFactory.getLog(CsrfAwareEntryPointAndDeniedHandler.class);
    private LoginUrlAuthenticationEntryPoint notloggedInCsrfEntryPoint;
    private LoginUrlAuthenticationEntryPoint loggedInCsrfEntryPoint;
    private LoginUrlAuthenticationEntryPoint loginEntryPoint;

    public CsrfAwareEntryPointAndDeniedHandler(String login, String redirectCsrf, String redirectNotLoggedIn) {
        if (redirectCsrf == null || !redirectCsrf.startsWith("/")) {
            throw new NullPointerException("Invalid CSRF redirect URL, must start with '/'");
        }
        if (login == null || !login.startsWith("/")) {
            throw new NullPointerException("Invalid CSRF redirect URL, must start with '/'");
        }
        if (redirectNotLoggedIn == null || !redirectNotLoggedIn.startsWith("/")) {
            throw new NullPointerException("Invalid login redirect URL, must start with '/'");
        }
        this.loginEntryPoint = new LoginUrlAuthenticationEntryPoint(login);
        this.notloggedInCsrfEntryPoint = new LoginUrlAuthenticationEntryPoint(redirectNotLoggedIn);
        this.loggedInCsrfEntryPoint = new LoginUrlAuthenticationEntryPoint(redirectCsrf){

            public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
                response.setStatus(403);
                super.commence(request, response, authException);
            }
        };
        this.loggedInCsrfEntryPoint.setUseForward(true);
    }

    public CsrfAwareEntryPointAndDeniedHandler(String redirectCsrf, String redirectNotLoggedIn) {
        this("/login", redirectCsrf, redirectNotLoggedIn);
    }

    protected boolean isUserLoggedIn() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth != null && auth.isAuthenticated() && auth.getPrincipal() instanceof UaaPrincipal;
    }

    protected boolean wantJson(HttpServletRequest request) {
        String accept = request.getHeader("Accept");
        boolean json = false;
        if (StringUtils.hasText((String)accept)) {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)accept)) {
                if (!mediaType.equals((Object)MediaType.APPLICATION_JSON)) continue;
                json = true;
                break;
            }
        }
        return json;
    }

    protected void internalHandle(HttpServletRequest request, HttpServletResponse response, Exception exception) throws IOException, ServletException {
        Object authEx;
        Object object = authEx = exception instanceof AuthenticationException ? (AuthenticationException)exception : new InternalAuthenticationServiceException("Access denied.", (Throwable)exception);
        if (this.wantJson(request)) {
            response.setStatus(403);
            response.setContentType("application/json");
            response.getWriter().append(String.format("{\"error\":\"%s\"}", exception.getMessage()));
        } else {
            LoginUrlAuthenticationEntryPoint entryPoint = this.getLoginUrlAuthenticationEntryPoint(exception);
            entryPoint.commence(request, response, authEx);
        }
    }

    protected LoginUrlAuthenticationEntryPoint getLoginUrlAuthenticationEntryPoint(Exception exception) {
        if (exception instanceof MissingCsrfTokenException || exception instanceof InvalidCsrfTokenException) {
            if (!this.isUserLoggedIn()) {
                return this.notloggedInCsrfEntryPoint;
            }
            return this.loggedInCsrfEntryPoint;
        }
        return this.loginEntryPoint;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
        this.internalHandle(request, response, (Exception)accessDeniedException);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        this.internalHandle(request, response, (Exception)authException);
    }
}

