/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.util.Arrays;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlConfigurationValidator<T>
implements FactoryBean<T>,
InitializingBean,
EnvironmentAware {
    private static final Log logger = LogFactory.getLog(YamlConfigurationValidator.class);
    private Constructor constructor;
    private boolean exceptionIfInvalid;
    private String yaml;
    private T configuration;

    public YamlConfigurationValidator(Constructor constructor) {
        Assert.notNull((Object)constructor);
        this.constructor = constructor;
    }

    public void setYaml(String yaml) {
        this.yaml = yaml;
    }

    public void setExceptionIfInvalid(boolean exceptionIfInvalid) {
        this.exceptionIfInvalid = exceptionIfInvalid;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.yaml != null ? 1 : 0) != 0, (String)"Yaml document should not be null");
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        try {
            logger.trace((Object)("Yaml document is\n" + this.yaml));
            this.configuration = new Yaml((BaseConstructor)this.constructor).load(this.yaml);
            Set errors = validator.validate(this.configuration, new Class[0]);
            if (!errors.isEmpty()) {
                logger.error((Object)"YAML configuration failed validation");
                for (ConstraintViolation error : errors) {
                    logger.error((Object)(error.getPropertyPath() + ": " + error.getMessage()));
                }
                if (this.exceptionIfInvalid) {
                    ConstraintViolationException summary = new ConstraintViolationException(errors);
                    throw summary;
                }
            }
        }
        catch (YAMLException e) {
            if (this.exceptionIfInvalid) {
                throw e;
            }
            logger.error((Object)"Failed to load YAML validation bean. Your YAML file may be invalid.", (Throwable)e);
        }
    }

    public Class<?> getObjectType() {
        if (this.configuration == null) {
            return Object.class;
        }
        return this.configuration.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public T getObject() throws Exception {
        if (this.configuration == null) {
            this.afterPropertiesSet();
        }
        return this.configuration;
    }

    public void setEnvironment(Environment environment) {
        if (Arrays.asList(environment.getActiveProfiles()).contains("strict")) {
            this.exceptionIfInvalid = true;
        }
    }
}

