/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.security.Principal;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKey;
import org.cloudfoundry.identity.uaa.oauth.token.VerificationKeyResponse;
import org.cloudfoundry.identity.uaa.oauth.token.VerificationKeysListResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TokenKeyEndpoint {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @RequestMapping(value={"/token_key"}, method={RequestMethod.GET})
    @ResponseBody
    public VerificationKeyResponse getKey(Principal principal) {
        KeyInfo key = KeyInfo.getActiveKey();
        if (!this.includeSymmetricalKeys(principal) && !key.isAssymetricKey()) {
            throw new AccessDeniedException("You need to authenticate to see a shared key");
        }
        return TokenKeyEndpoint.getVerificationKeyResponse(key);
    }

    public static VerificationKeyResponse getVerificationKeyResponse(KeyInfo key) {
        RSAPublicKey rsaKey;
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("alg", key.getSigner().algorithm());
        result.put("value", key.getVerifierKey());
        result.put("use", JsonWebKey.KeyUse.sig.name());
        result.put("kid", key.getKeyId());
        result.put("kty", key.getType());
        if (key.isAssymetricKey() && "RSA".equals(key.getType()) && (rsaKey = key.getRsaPublicKey()) != null) {
            Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
            String n = encoder.encodeToString(rsaKey.getModulus().toByteArray());
            String e = encoder.encodeToString(rsaKey.getPublicExponent().toByteArray());
            result.put("n", n);
            result.put("e", e);
        }
        return new VerificationKeyResponse(result);
    }

    @RequestMapping(value={"/token_keys"}, method={RequestMethod.GET})
    @ResponseBody
    public VerificationKeysListResponse getKeys(Principal principal) {
        boolean includeSymmetric = this.includeSymmetricalKeys(principal);
        Map<String, KeyInfo> keys = KeyInfo.getKeys();
        List keyResponses = keys.values().stream().filter(k -> includeSymmetric || k.isAssymetricKey()).map(TokenKeyEndpoint::getVerificationKeyResponse).collect(Collectors.toList());
        return new VerificationKeysListResponse(keyResponses);
    }

    protected boolean includeSymmetricalKeys(Principal principal) {
        if (principal != null) {
            Authentication auth;
            if (principal instanceof AnonymousAuthenticationToken) {
                return false;
            }
            if (principal instanceof Authentication && (auth = (Authentication)principal).getAuthorities() != null) {
                for (GrantedAuthority authority : auth.getAuthorities()) {
                    if (!"uaa.resource".equals(authority.getAuthority())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

