/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.event;

import java.security.Principal;
import java.util.HashMap;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.security.core.Authentication;

public class TokenRevocationEvent
extends AbstractUaaEvent {
    private static final long serialVersionUID = 8857827649236565674L;
    private String userId;
    private String clientId;
    private String zoneId;

    public TokenRevocationEvent(String userId, String clientId, String zoneId, Authentication authentication) {
        super(authentication);
        this.userId = userId;
        this.zoneId = zoneId;
        this.clientId = clientId;
    }

    @Override
    public AuditEvent getAuditEvent() {
        HashMap<String, String> data = new HashMap<String, String>();
        if (this.clientId != null) {
            data.put("ClientID", this.clientId);
        }
        if (this.userId != null) {
            data.put("UserID", this.userId);
        }
        data.put("ZoneID", this.zoneId);
        return this.createAuditRecord("clientId:" + this.clientId + ",userId:" + this.userId, AuditEventType.TokenRevocationEvent, this.getOrigin((Principal)this.getAuthentication()), JsonUtils.writeValueAsString(data));
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getZoneId() {
        return this.zoneId;
    }
}

