/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.oauth;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.OIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.oauth.OidcMetadataFetcher;
import org.cloudfoundry.identity.uaa.provider.oauth.OidcMetadataFetchingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;

public class XOAuthProviderConfigurator
implements IdentityProviderProvisioning {
    private static Logger log = LoggerFactory.getLogger(XOAuthProviderConfigurator.class);
    private final IdentityProviderProvisioning providerProvisioning;
    private OidcMetadataFetcher oidcMetadataFetcher;

    public XOAuthProviderConfigurator(IdentityProviderProvisioning providerProvisioning, OidcMetadataFetcher oidcMetadataFetcher) {
        this.providerProvisioning = providerProvisioning;
        this.oidcMetadataFetcher = oidcMetadataFetcher;
    }

    protected OIDCIdentityProviderDefinition overlay(OIDCIdentityProviderDefinition definition) {
        try {
            this.oidcMetadataFetcher.fetchMetadataAndUpdateDefinition(definition);
            return definition;
        }
        catch (OidcMetadataFetchingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getCompleteAuthorizationURI(String alias, String baseURL, AbstractXOAuthIdentityProviderDefinition definition) {
        try {
            String authUrlBase = definition instanceof OIDCIdentityProviderDefinition ? this.overlay((OIDCIdentityProviderDefinition)definition).getAuthUrl().toString() : definition.getAuthUrl().toString();
            String queryAppendDelimiter = authUrlBase.contains("?") ? "&" : "?";
            ArrayList<String> query = new ArrayList<String>();
            query.add("client_id=" + definition.getRelyingPartyId());
            query.add("response_type=" + URLEncoder.encode(definition.getResponseType(), "UTF-8"));
            query.add("redirect_uri=" + URLEncoder.encode(baseURL + "/login/callback/" + alias, "UTF-8"));
            query.add("state=" + RandomStringUtils.randomAlphanumeric((int)10));
            if (definition.getScopes() != null && !definition.getScopes().isEmpty()) {
                query.add("scope=" + URLEncoder.encode(String.join((CharSequence)" ", definition.getScopes()), "UTF-8"));
            }
            if (OIDCIdentityProviderDefinition.class.equals((Object)definition.getParameterizedClass())) {
                RandomValueStringGenerator nonceGenerator = new RandomValueStringGenerator(12);
                query.add("nonce=" + nonceGenerator.generate());
            }
            String queryString = String.join((CharSequence)"&", query);
            return authUrlBase + queryAppendDelimiter + queryString;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public IdentityProvider create(IdentityProvider identityProvider, String zoneId) {
        return this.providerProvisioning.create(identityProvider, zoneId);
    }

    @Override
    public IdentityProvider update(IdentityProvider identityProvider, String zoneId) {
        return this.providerProvisioning.update(identityProvider, zoneId);
    }

    @Override
    public IdentityProvider retrieve(String id, String zoneId) {
        IdentityProvider p = this.providerProvisioning.retrieve(id, zoneId);
        if (p != null && p.getType().equals("oidc1.0")) {
            p.setConfig((AbstractIdentityProviderDefinition)this.overlay((OIDCIdentityProviderDefinition)p.getConfig()));
        }
        return p;
    }

    @Override
    public List<IdentityProvider> retrieveActive(String zoneId) {
        return this.retrieveAll(true, zoneId);
    }

    public IdentityProvider retrieveByIssuer(String issuer, String zoneId) throws IncorrectResultSizeDataAccessException {
        List providers = this.retrieveAll(true, zoneId).stream().filter(p -> "oidc1.0".equals(p.getType()) && issuer.equals(((OIDCIdentityProviderDefinition)p.getConfig()).getIssuer())).collect(Collectors.toList());
        if (providers.isEmpty()) {
            throw new IncorrectResultSizeDataAccessException(String.format("Active provider with issuer[%s] not found", issuer), 1);
        }
        if (providers.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(String.format("Duplicate providers with issuer[%s] not found", issuer), 1);
        }
        return (IdentityProvider)providers.get(0);
    }

    @Override
    public List<IdentityProvider> retrieveAll(boolean activeOnly, String zoneId) {
        List<String> types = Arrays.asList("oauth2.0", "oidc1.0");
        List<IdentityProvider> providers = this.providerProvisioning.retrieveAll(activeOnly, zoneId);
        ArrayList<IdentityProvider> overlayedProviders = new ArrayList<IdentityProvider>();
        Optional.ofNullable(providers).orElse(Collections.emptyList()).stream().filter(p -> types.contains(p.getType())).forEach(p -> {
            if (p.getType().equals("oidc1.0")) {
                try {
                    OIDCIdentityProviderDefinition overlayedDefinition = this.overlay((OIDCIdentityProviderDefinition)p.getConfig());
                    p.setConfig((AbstractIdentityProviderDefinition)overlayedDefinition);
                }
                catch (Exception e) {
                    log.error("Identity provider excluded from login page due to a problem.", (Throwable)e);
                    return;
                }
            }
            overlayedProviders.add((IdentityProvider)p);
        });
        return overlayedProviders;
    }

    @Override
    public IdentityProvider retrieveByOrigin(String origin, String zoneId) {
        IdentityProvider p = this.providerProvisioning.retrieveByOrigin(origin, zoneId);
        if (p != null && p.getType().equals("oidc1.0")) {
            p.setConfig((AbstractIdentityProviderDefinition)this.overlay((OIDCIdentityProviderDefinition)p.getConfig()));
        }
        return p;
    }

    @Override
    public IdentityProvider retrieveByOriginIgnoreActiveFlag(String origin, String zoneId) {
        IdentityProvider p = this.providerProvisioning.retrieveByOriginIgnoreActiveFlag(origin, zoneId);
        if (p != null && p.getType().equals("oidc1.0")) {
            p.setConfig((AbstractIdentityProviderDefinition)this.overlay((OIDCIdentityProviderDefinition)p.getConfig()));
        }
        return p;
    }
}

