/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.ResponseBuilder;
import org.opensaml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml2.core.impl.StatusMessageBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public class SamlRedirectUtils {
    public static String getIdpRedirectUrl(SamlIdentityProviderDefinition definition, String entityId) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)"saml/discovery");
        builder.queryParam("returnIDParam", new Object[]{"idp"});
        builder.queryParam("entityID", new Object[]{SamlRedirectUtils.getZonifiedEntityId(entityId)});
        builder.queryParam("idp", new Object[]{definition.getIdpEntityAlias()});
        builder.queryParam("isPassive", new Object[]{"true"});
        return builder.build().toUriString();
    }

    public static String getZonifiedEntityId(String entityID) {
        try {
            String url;
            if (!IdentityZoneHolder.isUaa() && (url = IdentityZoneHolder.get().getConfig().getSamlConfig().getEntityID()) != null) {
                return url;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (UaaUrlUtils.isUrl(entityID)) {
            return UaaUrlUtils.addSubdomainToUrl(entityID, IdentityZoneHolder.get().getSubdomain());
        }
        return UaaUrlUtils.getSubdomain(IdentityZoneHolder.get().getSubdomain()) + entityID;
    }

    public static Response wrapAssertionIntoResponse(Assertion assertion, String assertionIssuer) {
        Response response = new ResponseBuilder().buildObject();
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(assertionIssuer);
        response.setIssuer(issuer);
        response.setID("id-" + System.currentTimeMillis());
        Status stat = new StatusBuilder().buildObject();
        StatusCode statCode = new StatusCodeBuilder().buildObject();
        statCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        stat.setStatusCode(statCode);
        StatusMessage statMesssage = new StatusMessageBuilder().buildObject();
        statMesssage.setMessage(null);
        stat.setStatusMessage(statMesssage);
        response.setStatus(stat);
        response.setVersion(SAMLVersion.VERSION_20);
        response.setIssueInstant(new DateTime());
        response.getAssertions().add(assertion);
        return response;
    }
}

