/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xml.security.credential.UsageType;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.util.SAMLUtil;

public class ZoneAwareMetadataGenerator
extends MetadataGenerator {
    public ExtendedMetadata generateExtendedMetadata() {
        ExtendedMetadata metadata = super.generateExtendedMetadata();
        metadata.setAlias(UaaUrlUtils.getSubdomain(IdentityZoneHolder.get().getSubdomain()) + metadata.getAlias());
        return metadata;
    }

    public String getEntityId() {
        String url;
        if (!IdentityZoneHolder.isUaa() && (url = this.getZoneDefinition().getSamlConfig().getEntityID()) != null) {
            return url;
        }
        String entityId = super.getEntityId();
        if (UaaUrlUtils.isUrl(entityId)) {
            return UaaUrlUtils.addSubdomainToUrl(entityId, IdentityZoneHolder.get().getSubdomain());
        }
        return UaaUrlUtils.getSubdomain(IdentityZoneHolder.get().getSubdomain()) + entityId;
    }

    public String getEntityBaseURL() {
        return UaaUrlUtils.addSubdomainToUrl(super.getEntityBaseURL(), IdentityZoneHolder.get().getSubdomain());
    }

    protected String getEntityAlias() {
        return UaaUrlUtils.getSubdomain(IdentityZoneHolder.get().getSubdomain()) + super.getEntityAlias();
    }

    public boolean isRequestSigned() {
        if (!IdentityZoneHolder.isUaa()) {
            return this.getZoneDefinition().getSamlConfig().isRequestSigned();
        }
        return super.isRequestSigned();
    }

    public boolean isWantAssertionSigned() {
        if (!IdentityZoneHolder.isUaa()) {
            return this.getZoneDefinition().getSamlConfig().isWantAssertionSigned();
        }
        return super.isWantAssertionSigned();
    }

    protected IdentityZoneConfiguration getZoneDefinition() {
        IdentityZone zone = IdentityZoneHolder.get();
        IdentityZoneConfiguration definition = zone.getConfig();
        return definition != null ? definition : new IdentityZoneConfiguration();
    }

    public EntityDescriptor generateMetadata() {
        EntityDescriptor result = super.generateMetadata();
        result.setID(SAMLUtil.getNCNameString((String)result.getEntityID()));
        return result;
    }

    protected SPSSODescriptor buildSPSSODescriptor(String entityBaseURL, String entityAlias, boolean requestSigned, boolean wantAssertionSigned, Collection<String> includedNameID) {
        SPSSODescriptor result = super.buildSPSSODescriptor(entityBaseURL, entityAlias, requestSigned, wantAssertionSigned, includedNameID);
        KeyManager samlSPKeyManager = IdentityZoneHolder.getSamlSPKeyManager();
        if (samlSPKeyManager != null && samlSPKeyManager.getAvailableCredentials() != null) {
            HashSet allKeyAliases = new HashSet(samlSPKeyManager.getAvailableCredentials());
            String activeKeyAlias = samlSPKeyManager.getDefaultCredentialName();
            allKeyAliases.remove(activeKeyAlias);
            for (String keyAlias : allKeyAliases) {
                result.getKeyDescriptors().add(this.getKeyDescriptor(UsageType.SIGNING, this.getServerKeyInfo(keyAlias)));
            }
        }
        int index = result.getAssertionConsumerServices().size();
        result.getAssertionConsumerServices().add(this.getAssertionConsumerService(this.getEntityBaseURL(), this.getEntityAlias(), false, index, "/oauth/token", "urn:oasis:names:tc:SAML:2.0:bindings:URI"));
        return result;
    }

    public Collection<String> getBindingsSSO() {
        return Collections.singleton("post");
    }
}

