/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public class PasswordEncoderFactory {
    private static Log logger = LogFactory.getLog(PasswordEncoderFactory.class);

    public PasswordEncoder get() {
        try {
            return this.createFakePasswordEncoder();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return this.createRealPasswordEncoder();
        }
    }

    PasswordEncoder createFakePasswordEncoder() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String testPasswdEncoderclassName = "org.cloudfoundry.identity.uaa.util.FakePasswordEncoder";
        Class<?> klass = Class.forName(testPasswdEncoderclassName);
        PasswordEncoder passwordEncoder = (PasswordEncoder)klass.newInstance();
        logger.error((Object)"Created instance of FakePasswordEncoder. This should only happen in unit tests! This is a serious error in production!");
        return passwordEncoder;
    }

    PasswordEncoder createRealPasswordEncoder() {
        logger.info((Object)"Created instance of BCryptPasswordEncoder");
        return new BCryptPasswordEncoder();
    }
}

