/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.account.PasswordConfirmationValidation;
import org.cloudfoundry.identity.uaa.account.ResetPasswordService;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.login.AccountSavingAuthenticationSuccessHandler;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ForcePasswordChangeController {
    private ResourcePropertySource resourcePropertySource;
    public static final String FORCE_PASSWORD_EXPIRED_USER = "FORCE_PASSWORD_EXPIRED_USER";
    private Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    @Qualifier(value="accountSavingAuthenticationSuccessHandler")
    private AccountSavingAuthenticationSuccessHandler successHandler;
    @Autowired
    @Qualifier(value="resetPasswordService")
    private ResetPasswordService resetPasswordService;

    public void setSuccessHandler(AccountSavingAuthenticationSuccessHandler successHandler) {
        this.successHandler = successHandler;
    }

    @RequestMapping(value={"/force_password_change"}, method={RequestMethod.GET})
    public String forcePasswordChangePage(Model model, HttpSession session) throws IOException {
        if (session.getAttribute(FORCE_PASSWORD_EXPIRED_USER) == null) {
            return "redirect:/login";
        }
        String email = ((UaaAuthentication)session.getAttribute(FORCE_PASSWORD_EXPIRED_USER)).getPrincipal().getEmail();
        model.addAttribute("email", (Object)email);
        return "force_password_change";
    }

    @RequestMapping(value={"/force_password_change"}, method={RequestMethod.POST})
    public String handleForcePasswordChange(Model model, @RequestParam(value="password") String password, @RequestParam(value="password_confirmation") String passwordConfirmation, HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException {
        if (session.getAttribute(FORCE_PASSWORD_EXPIRED_USER) == null) {
            return "redirect:" + request.getContextPath() + "/login";
        }
        UaaAuthentication authentication = (UaaAuthentication)session.getAttribute(FORCE_PASSWORD_EXPIRED_USER);
        UaaPrincipal principal = authentication.getPrincipal();
        String email = principal.getEmail();
        PasswordConfirmationValidation validation = new PasswordConfirmationValidation(email, password, passwordConfirmation);
        if (!validation.valid()) {
            return this.handleUnprocessableEntity(model, response, email, this.resourcePropertySource.getProperty("force_password_change.form_error").toString());
        }
        this.logger.debug((Object)("Processing handleForcePasswordChange for user: " + email));
        try {
            this.resetPasswordService.resetUserPassword(principal.getId(), password);
        }
        catch (InvalidPasswordException exception) {
            return this.handleUnprocessableEntity(model, response, email, exception.getMessagesAsOneString());
        }
        SavedRequest savedRequest = (SavedRequest)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        request.getSession().invalidate();
        request.getSession(true);
        if (authentication instanceof UaaAuthentication) {
            UaaAuthentication uaaAuthentication = authentication;
            authentication = new UaaAuthentication(uaaAuthentication.getPrincipal(), new LinkedList<GrantedAuthority>(uaaAuthentication.getAuthorities()), new UaaAuthenticationDetails(request));
            Optional.ofNullable(this.successHandler).ifPresent(handler -> handler.setSavedAccountOptionCookie(request, response, uaaAuthentication));
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        if (savedRequest != null) {
            return "redirect:" + savedRequest.getRedirectUrl();
        }
        return "redirect:/";
    }

    public void setResetPasswordService(ResetPasswordService resetPasswordService) {
        this.resetPasswordService = resetPasswordService;
    }

    private String handleUnprocessableEntity(Model model, HttpServletResponse response, String email, String message) {
        model.addAttribute("message", (Object)message);
        model.addAttribute("email", (Object)email);
        response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
        return "force_password_change";
    }

    public void setResourcePropertySource(ResourcePropertySource resourcePropertySource) {
        this.resourcePropertySource = resourcePropertySource;
    }
}

