/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security.web;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DefaultCsrfToken;

public class CookieBasedCsrfTokenRepository
implements CsrfTokenRepository {
    public static final String DEFAULT_CSRF_HEADER_NAME = "X-CSRF-TOKEN";
    public static final String DEFAULT_CSRF_COOKIE_NAME = "X-Uaa-Csrf";
    public static final int DEFAULT_COOKIE_MAX_AGE = 2592000;
    private RandomValueStringGenerator generator = new RandomValueStringGenerator(22);
    private String parameterName = "X-Uaa-Csrf";
    private String headerName = "X-CSRF-TOKEN";
    private int cookieMaxAge = 2592000;
    private boolean secure;

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setGenerator(RandomValueStringGenerator generator) {
        this.generator = generator;
    }

    public RandomValueStringGenerator getGenerator() {
        return this.generator;
    }

    public CsrfToken generateToken(HttpServletRequest request) {
        String token = this.generator.generate();
        return new DefaultCsrfToken(this.getHeaderName(), this.getParameterName(), token);
    }

    public void saveToken(CsrfToken token, HttpServletRequest request, HttpServletResponse response) {
        boolean expire = false;
        if (token == null) {
            token = this.generateToken(request);
            expire = true;
        }
        Cookie csrfCookie = new Cookie(token.getParameterName(), token.getToken());
        csrfCookie.setHttpOnly(true);
        csrfCookie.setSecure(this.secure || request.getProtocol().equals("https"));
        if (expire) {
            csrfCookie.setMaxAge(0);
        } else {
            csrfCookie.setMaxAge(this.getCookieMaxAge());
        }
        response.addCookie(csrfCookie);
    }

    public CsrfToken loadToken(HttpServletRequest request) {
        Cookie[] cookies;
        boolean requiresCsrfProtection = CsrfFilter.DEFAULT_CSRF_MATCHER.matches(request);
        if (requiresCsrfProtection && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!this.getParameterName().equals(cookie.getName())) continue;
                return new DefaultCsrfToken(this.getHeaderName(), this.getParameterName(), cookie.getValue());
            }
        }
        return null;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }
}

