/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.MultiValueMap;

public class LinkedMaskingMultiValueMap<K, V>
implements MultiValueMap<K, V>,
Serializable {
    private static final long serialVersionUID = 3801124242820219132L;
    private final Map<K, List<V>> targetMap;
    private final Set<K> maskedAttributeSet = new HashSet<K>();

    public LinkedMaskingMultiValueMap() {
        this.targetMap = new LinkedHashMap<K, List<V>>();
    }

    public LinkedMaskingMultiValueMap(K maskedAttribute) {
        this.targetMap = new LinkedHashMap<K, List<V>>();
        this.maskedAttributeSet.add(maskedAttribute);
    }

    public LinkedMaskingMultiValueMap(Set<K> maskedAttributes) {
        this.targetMap = new LinkedHashMap<K, List<V>>();
        this.maskedAttributeSet.addAll(maskedAttributes);
    }

    public LinkedMaskingMultiValueMap(int initialCapacity) {
        this.targetMap = new LinkedHashMap<K, List<V>>(initialCapacity);
    }

    public LinkedMaskingMultiValueMap(Map<K, List<V>> otherMap) {
        this.targetMap = new LinkedHashMap<K, List<List<V>>>(otherMap);
    }

    public void add(K key, V value) {
        List<V> values = this.targetMap.get(key);
        if (values == null) {
            values = new LinkedList<V>();
            this.targetMap.put(key, values);
        }
        values.add(value);
    }

    public V getFirst(K key) {
        List<V> values = this.targetMap.get(key);
        return values != null ? (V)values.get(0) : null;
    }

    public void set(K key, V value) {
        LinkedList<V> values = new LinkedList<V>();
        values.add(value);
        this.targetMap.put(key, values);
    }

    public void setAll(Map<K, V> values) {
        for (Map.Entry<K, V> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public Map<K, V> toSingleValueMap() {
        LinkedHashMap<K, V> singleValueMap = new LinkedHashMap<K, V>(this.targetMap.size());
        for (Map.Entry<K, List<V>> entry : this.targetMap.entrySet()) {
            singleValueMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return singleValueMap;
    }

    public int size() {
        return this.targetMap.size();
    }

    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.targetMap.containsValue(value);
    }

    public List<V> get(Object key) {
        return this.targetMap.get(key);
    }

    public List<V> put(K key, List<V> value) {
        return this.targetMap.put(key, value);
    }

    public List<V> remove(Object key) {
        return this.targetMap.remove(key);
    }

    public void putAll(Map<? extends K, ? extends List<V>> m) {
        this.targetMap.putAll(m);
    }

    public void clear() {
        this.targetMap.clear();
    }

    public Set<K> keySet() {
        return this.targetMap.keySet();
    }

    public Collection<List<V>> values() {
        return this.targetMap.values();
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.targetMap.entrySet();
    }

    public boolean equals(Object obj) {
        return this.targetMap.equals(obj);
    }

    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, List<V>>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            int keyHash = 1;
            Map.Entry<K, List<V>> entry = i.next();
            if (entry.getKey() != null && entry.getKey() != this) {
                keyHash += entry.getKey().hashCode();
            }
            List<V> value = entry.getValue();
            int valueHash = 1;
            for (V v : value) {
                valueHash = 31 * valueHash + (v == null ? 0 : (v == this ? 0 : v.hashCode()));
            }
            h += keyHash ^ valueHash;
        }
        return h;
    }

    public String toString() {
        Iterator<Map.Entry<K, List<V>>> i = this.targetMap.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (i.hasNext()) {
            Map.Entry<K, List<V>> e = i.next();
            List<V> value = e.getValue();
            K key = e.getKey();
            sb.append((Object)(key == this ? "(this map)" : key));
            sb.append('=');
            if (this.maskedAttributeSet.contains(key)) {
                sb.append("[PROTECTED]");
            } else if (value == null) {
                sb.append("[]");
            } else {
                Iterator<V> it = value.iterator();
                sb.append('[');
                while (it.hasNext()) {
                    V v = it.next();
                    sb.append((Object)(v == this ? "(this map)" : v));
                    if (!it.hasNext()) continue;
                    sb.append(',').append(' ');
                }
                sb.append(']');
            }
            if (!i.hasNext()) continue;
            sb.append(',').append(' ');
        }
        return sb.toString();
    }
}

