/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.cloudfoundry.identity.uaa.provider.ldap.extension.NestedLdapAuthoritiesPopulator;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class LdapGroupsConfig {
    @Bean
    public LdapAuthoritiesPopulator nestedLdapAuthoritiesPopulator(ContextSource contextSource, Environment environment, String configuredGroupRoleAttribute) {
        String searchBase = Optional.ofNullable(environment.getProperty("ldap.groups.searchBase")).orElse("ou=scopes,dc=test,dc=com");
        boolean searchSubtree = Optional.ofNullable(environment.getProperty("ldap.groups.searchSubtree")).map(Boolean::parseBoolean).orElse(true);
        String groupSearchFilter = Optional.ofNullable(environment.getProperty("ldap.groups.groupSearchFilter")).orElse("member={0}");
        NestedLdapAuthoritiesPopulator nestedLdapAuthoritiesPopulator = new NestedLdapAuthoritiesPopulator(contextSource, searchBase);
        nestedLdapAuthoritiesPopulator.setGroupRoleAttribute(configuredGroupRoleAttribute);
        nestedLdapAuthoritiesPopulator.setSearchSubtree(searchSubtree);
        nestedLdapAuthoritiesPopulator.setRolePrefix("");
        nestedLdapAuthoritiesPopulator.setConvertToUpperCase(false);
        nestedLdapAuthoritiesPopulator.setGroupSearchFilter(groupSearchFilter);
        nestedLdapAuthoritiesPopulator.setMaxSearchDepth(Optional.ofNullable(Integer.parseInt(environment.getProperty("ldap.groups.maxSearchDepth"))).orElse(10));
        nestedLdapAuthoritiesPopulator.setAttributeNames(new HashSet<String>(Arrays.asList("cn")));
        nestedLdapAuthoritiesPopulator.setIgnorePartialResultException(Optional.ofNullable(environment.getProperty("ldap.groups.ignorePartialResultException")).map(Boolean::parseBoolean).orElse(true));
        return nestedLdapAuthoritiesPopulator;
    }
}

