/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.validation.Valid;
import org.cloudfoundry.identity.uaa.audit.event.EntityDeletedEvent;
import org.cloudfoundry.identity.uaa.client.InvalidClientDetailsException;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.saml.SamlKey;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneEndpointClientRegistrationService;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneValidator;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneDetailsException;
import org.cloudfoundry.identity.uaa.zone.SamlConfig;
import org.cloudfoundry.identity.uaa.zone.UserConfig;
import org.cloudfoundry.identity.uaa.zone.ZoneAlreadyExistsException;
import org.cloudfoundry.identity.uaa.zone.ZoneDoesNotExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/identity-zones"})
public class IdentityZoneEndpoints
implements ApplicationEventPublisherAware {
    @Autowired
    private MessageSource messageSource;
    private ApplicationEventPublisher publisher;
    private static final Logger logger = LoggerFactory.getLogger(IdentityZoneEndpoints.class);
    private final IdentityZoneProvisioning zoneDao;
    private final IdentityProviderProvisioning idpDao;
    private final IdentityZoneEndpointClientRegistrationService clientRegistrationService;
    private final ScimGroupProvisioning groupProvisioning;
    private IdentityZoneValidator validator;

    public IdentityZoneEndpoints(IdentityZoneProvisioning zoneDao, IdentityProviderProvisioning idpDao, IdentityZoneEndpointClientRegistrationService clientRegistrationService, ScimGroupProvisioning groupProvisioning) {
        this.zoneDao = zoneDao;
        this.idpDao = idpDao;
        this.clientRegistrationService = clientRegistrationService;
        this.groupProvisioning = groupProvisioning;
    }

    public void setValidator(IdentityZoneValidator validator) {
        this.validator = validator;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public IdentityZone getIdentityZone(@PathVariable String id) {
        List<IdentityZone> result = this.filterForCurrentZone(Arrays.asList(this.zoneDao.retrieve(id)));
        if (result.size() == 0) {
            throw new ZoneDoesNotExistsException("Zone does not exist or is not accessible.");
        }
        return this.removeKeys(result.get(0));
    }

    protected IdentityZone removeKeys(IdentityZone identityZone) {
        if (identityZone.getConfig() != null && identityZone.getConfig().getTokenPolicy() != null) {
            identityZone.getConfig().getTokenPolicy().setKeys(null);
        }
        if (identityZone.getConfig() != null && identityZone.getConfig().getSamlConfig() != null) {
            identityZone.getConfig().getSamlConfig().setPrivateKeyPassword(null);
            identityZone.getConfig().getSamlConfig().setPrivateKey(null);
            identityZone.getConfig().getSamlConfig().getKeys().entrySet().forEach(entry -> {
                ((SamlKey)entry.getValue()).setPassphrase(null);
                ((SamlKey)entry.getValue()).setKey(null);
            });
        }
        return identityZone;
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<IdentityZone> getIdentityZones() {
        return this.filterForCurrentZone(this.zoneDao.retrieveAll());
    }

    protected List<IdentityZone> filterForCurrentZone(List<IdentityZone> zones) {
        LinkedList<IdentityZone> result = new LinkedList<IdentityZone>();
        if (IdentityZoneHolder.isUaa()) {
            for (IdentityZone zone : zones) {
                result.add(this.removeKeys(zone));
            }
            return result;
        }
        String currentId = IdentityZoneHolder.get().getId();
        for (IdentityZone zone : zones) {
            if (!currentId.equals(zone.getId())) continue;
            result.add(this.removeKeys(this.filterForZonesDotRead(zone)));
            break;
        }
        return result;
    }

    protected IdentityZone filterForZonesDotRead(IdentityZone zone) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && this.hasReadOnlyAuthority(zone.getId(), auth)) {
            zone.getConfig().setSamlConfig(null);
            zone.getConfig().setTokenPolicy(null);
        }
        return zone;
    }

    protected boolean hasReadOnlyAuthority(String zoneId, Authentication authentication) {
        boolean hasRead = false;
        boolean doesNotHaveAdmin = true;
        String adminScope = "zones." + zoneId + ".admin";
        String readScope = "zones." + zoneId + ".read";
        for (GrantedAuthority a : authentication.getAuthorities()) {
            if (adminScope.equals(a.getAuthority())) {
                doesNotHaveAdmin = false;
                continue;
            }
            if (!readScope.equals(a.getAuthority())) continue;
            hasRead = true;
        }
        return hasRead && doesNotHaveAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<IdentityZone> createIdentityZone(@RequestBody @Valid IdentityZone body, BindingResult result) {
        if (result.hasErrors()) {
            throw new UnprocessableEntityException(this.getErrorMessages((Errors)result));
        }
        if (!IdentityZoneHolder.isUaa()) {
            throw new AccessDeniedException("Zones can only be created by being authenticated in the default zone.");
        }
        try {
            body = this.validator.validate(body, IdentityZoneValidator.Mode.CREATE);
        }
        catch (InvalidIdentityZoneDetailsException ex) {
            throw new UnprocessableEntityException("The identity zone details are invalid.", ex);
        }
        if (!StringUtils.hasText((String)body.getId())) {
            body.setId(UUID.randomUUID().toString());
        }
        IdentityZone previous = IdentityZoneHolder.get();
        try {
            logger.debug("Zone - creating id[" + body.getId() + "] subdomain[" + body.getSubdomain() + "]");
            IdentityZone created = this.zoneDao.create(body);
            logger.debug("Zone - created id[" + created.getId() + "] subdomain[" + created.getSubdomain() + "]");
            IdentityZoneHolder.set(created);
            IdentityProvider defaultIdp = new IdentityProvider();
            defaultIdp.setName("uaa");
            defaultIdp.setType("uaa");
            defaultIdp.setOriginKey("uaa");
            defaultIdp.setIdentityZoneId(created.getId());
            UaaIdentityProviderDefinition idpDefinition = new UaaIdentityProviderDefinition();
            idpDefinition.setPasswordPolicy(null);
            defaultIdp.setConfig((AbstractIdentityProviderDefinition)idpDefinition);
            this.idpDao.create(defaultIdp);
            logger.debug("Created default IDP in zone - created id[" + created.getId() + "] subdomain[" + created.getSubdomain() + "]");
            this.createUserGroups(created);
            ResponseEntity responseEntity = new ResponseEntity((Object)this.removeKeys(created), HttpStatus.CREATED);
            return responseEntity;
        }
        finally {
            IdentityZoneHolder.set(previous);
        }
    }

    public void createUserGroups(IdentityZone zone) {
        UserConfig userConfig = zone.getConfig().getUserConfig();
        if (userConfig != null) {
            List defaultGroups = Optional.ofNullable(userConfig.getDefaultGroups()).orElse(Collections.emptyList());
            logger.debug(String.format("About to create default groups count: %s for subdomain: %s", defaultGroups.size(), zone.getSubdomain()));
            for (String group : defaultGroups) {
                logger.debug(String.format("Creating zone default group: %s for subdomain: %s", group, zone.getSubdomain()));
                this.groupProvisioning.createOrGet(new ScimGroup(null, group, zone.getId()), zone.getId());
            }
        }
    }

    private String getErrorMessages(Errors errors) {
        ArrayList<String> messages = new ArrayList<String>();
        for (ObjectError error : errors.getAllErrors()) {
            messages.add(this.messageSource.getMessage((MessageSourceResolvable)error, Locale.getDefault()));
        }
        return String.join((CharSequence)"\r\n", messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<IdentityZone> updateIdentityZone(@RequestBody @Valid IdentityZone body, @PathVariable String id) {
        if (id == null) {
            throw new ZoneDoesNotExistsException(id);
        }
        if (!IdentityZoneHolder.isUaa() && !id.equals(IdentityZoneHolder.get().getId())) {
            throw new AccessDeniedException("Zone admins can only update their own zone.");
        }
        IdentityZone existingZone = this.zoneDao.retrieve(id);
        this.restoreSecretProperties(existingZone, body);
        try {
            body = this.validator.validate(body, IdentityZoneValidator.Mode.MODIFY);
        }
        catch (InvalidIdentityZoneDetailsException ex) {
            throw new UnprocessableEntityException("The identity zone details are invalid.", ex);
        }
        IdentityZone previous = IdentityZoneHolder.get();
        try {
            logger.debug("Zone - updating id[" + id + "] subdomain[" + body.getSubdomain() + "]");
            body.setId(id);
            IdentityZone updated = this.zoneDao.update(body);
            IdentityZoneHolder.set(updated);
            logger.debug("Zone - updated id[" + updated.getId() + "] subdomain[" + updated.getSubdomain() + "]");
            this.createUserGroups(updated);
            ResponseEntity responseEntity = new ResponseEntity((Object)this.removeKeys(updated), HttpStatus.OK);
            return responseEntity;
        }
        finally {
            IdentityZoneHolder.set(previous);
        }
    }

    protected void restoreSecretProperties(IdentityZone existingZone, IdentityZone newZone) {
        if (newZone.getConfig() != null) {
            if (newZone.getConfig().getTokenPolicy() != null && (newZone.getConfig().getTokenPolicy().getKeys() == null || newZone.getConfig().getTokenPolicy().getKeys().isEmpty())) {
                newZone.getConfig().getTokenPolicy().setKeys(existingZone.getConfig().getTokenPolicy().getKeys());
            }
            if (newZone.getConfig().getSamlConfig() != null) {
                SamlConfig config = newZone.getConfig().getSamlConfig();
                SamlConfig oldConfig = existingZone.getConfig().getSamlConfig();
                for (Map.Entry entry : config.getKeys().entrySet()) {
                    SamlKey original = (SamlKey)oldConfig.getKeys().get(entry.getKey());
                    if (((SamlKey)entry.getValue()).getKey() != null || ((SamlKey)entry.getValue()).getPassphrase() != null || original == null || original.getCertificate() == null || !original.getCertificate().equals(((SamlKey)entry.getValue()).getCertificate())) continue;
                    ((SamlKey)entry.getValue()).setKey(original.getKey());
                    ((SamlKey)entry.getValue()).setPassphrase(original.getPassphrase());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @Transactional
    public ResponseEntity<IdentityZone> deleteIdentityZone(@PathVariable String id) {
        if (id == null) {
            throw new ZoneDoesNotExistsException(id);
        }
        if (!IdentityZoneHolder.isUaa() && !id.equals(IdentityZoneHolder.get().getId())) {
            throw new AccessDeniedException("Zone admins can only update their own zone.");
        }
        IdentityZone previous = IdentityZoneHolder.get();
        try {
            logger.debug("Zone - deleting id[" + id + "]");
            IdentityZone zone = this.zoneDao.retrieve(id);
            IdentityZoneHolder.set(zone);
            if (this.publisher != null && zone != null) {
                this.publisher.publishEvent(new EntityDeletedEvent<IdentityZone>(zone, SecurityContextHolder.getContext().getAuthentication()));
                logger.debug("Zone - deleted id[" + zone.getId() + "]");
                ResponseEntity responseEntity = new ResponseEntity((Object)this.removeKeys(zone), HttpStatus.OK);
                return responseEntity;
            }
            ResponseEntity responseEntity = new ResponseEntity(HttpStatus.UNPROCESSABLE_ENTITY);
            return responseEntity;
        }
        finally {
            IdentityZoneHolder.set(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, value={"{identityZoneId}/clients"})
    public ResponseEntity<? extends ClientDetails> createClient(@PathVariable String identityZoneId, @RequestBody BaseClientDetails clientDetails) {
        if (identityZoneId == null) {
            throw new ZoneDoesNotExistsException(identityZoneId);
        }
        if (!IdentityZoneHolder.isUaa() && !identityZoneId.equals(IdentityZoneHolder.get().getId())) {
            throw new AccessDeniedException("Zone admins can only create clients in their own zone.");
        }
        IdentityZone previous = IdentityZoneHolder.get();
        try {
            logger.debug("Zone creating client zone[" + identityZoneId + "] client[" + clientDetails.getClientId() + "]");
            IdentityZone identityZone = this.zoneDao.retrieve(identityZoneId);
            IdentityZoneHolder.set(identityZone);
            ClientDetails createdClient = this.clientRegistrationService.createClient((ClientDetails)clientDetails);
            logger.debug("Zone client created zone[" + identityZoneId + "] client[" + clientDetails.getClientId() + "]");
            ResponseEntity responseEntity = new ResponseEntity((Object)this.removeSecret(createdClient), HttpStatus.CREATED);
            return responseEntity;
        }
        finally {
            IdentityZoneHolder.set(previous);
        }
    }

    private ClientDetails removeSecret(ClientDetails createdClient) {
        BaseClientDetails response = (BaseClientDetails)createdClient;
        response.setClientSecret(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.DELETE}, value={"{identityZoneId}/clients/{clientId}"})
    public ResponseEntity<? extends ClientDetails> deleteClient(@PathVariable String identityZoneId, @PathVariable String clientId) {
        if (identityZoneId == null) {
            throw new ZoneDoesNotExistsException(identityZoneId);
        }
        if (!IdentityZoneHolder.isUaa() && !identityZoneId.equals(IdentityZoneHolder.get().getId())) {
            throw new AccessDeniedException("Zone admins can only delete their own zone.");
        }
        IdentityZone previous = IdentityZoneHolder.get();
        try {
            logger.debug("Zone deleting client zone[" + identityZoneId + "] client[" + clientId + "]");
            IdentityZone identityZone = this.zoneDao.retrieve(identityZoneId);
            IdentityZoneHolder.set(identityZone);
            ClientDetails deleted = this.clientRegistrationService.deleteClient(clientId);
            logger.debug("Zone client deleted zone[" + identityZoneId + "] client[" + clientId + "]");
            ResponseEntity responseEntity = new ResponseEntity((Object)this.removeSecret(deleted), HttpStatus.OK);
            return responseEntity;
        }
        finally {
            IdentityZoneHolder.set(previous);
        }
    }

    @ExceptionHandler(value={ZoneAlreadyExistsException.class})
    public ResponseEntity<ZoneAlreadyExistsException> handleZoneAlreadyExistsException(ZoneAlreadyExistsException e) {
        return new ResponseEntity((Object)e, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InvalidClientDetailsException.class})
    public ResponseEntity<InvalidClientDetailsException> handleInvalidClientDetails(InvalidClientDetailsException e) {
        return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NoSuchClientException.class})
    public ResponseEntity<Void> handleNoSuchClient(NoSuchClientException e) {
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ClientAlreadyExistsException.class})
    public ResponseEntity<InvalidClientDetailsException> handleClientAlreadyExists(ClientAlreadyExistsException e) {
        return new ResponseEntity((Object)new InvalidClientDetailsException(e.getMessage()), HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ZoneDoesNotExistsException.class})
    public ResponseEntity<ZoneDoesNotExistsException> handleZoneDoesNotExistsException(ZoneDoesNotExistsException e) {
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<Void> handleValidationException(MethodArgumentNotValidException e) {
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<Void> handleAccessDeniedException(AccessDeniedException e) {
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={UnprocessableEntityException.class})
    public ResponseEntity<UnprocessableEntityException> handleUnprocessableEntityException(UnprocessableEntityException e) {
        return new ResponseEntity((Object)e, HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Void> handleException(Exception e) {
        logger.error(e.getClass() + ": " + e.getMessage(), (Throwable)e);
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private class UnprocessableEntityException
    extends UaaException {
        public UnprocessableEntityException(String message) {
            super("invalid_identity_zone", message, 422);
        }

        public UnprocessableEntityException(String message, Throwable cause) {
            super(cause, "invalid_identity_zone", message, 422);
        }
    }
}

