/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.identity.uaa.login.Prompt;
import org.cloudfoundry.identity.uaa.saml.SamlKey;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.BrandingInformation;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneValidator;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneDetailsException;
import org.cloudfoundry.identity.uaa.zone.TokenPolicy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class IdentityZoneConfigurationBootstrap
implements InitializingBean {
    private TokenPolicy tokenPolicy;
    private IdentityZoneProvisioning provisioning;
    private boolean selfServiceLinksEnabled = true;
    private String homeRedirect = null;
    private Map<String, Object> selfServiceLinks;
    private List<String> logoutRedirectWhitelist;
    private String logoutRedirectParameterName;
    private String logoutDefaultRedirectUrl;
    private boolean logoutDisableRedirectParameter = true;
    private List<Prompt> prompts;
    private String samlSpPrivateKey;
    private String samlSpPrivateKeyPassphrase;
    private String samlSpCertificate;
    private Map<String, Map<String, String>> samlKeys;
    private String activeKeyId;
    private boolean idpDiscoveryEnabled = false;
    private boolean accountChooserEnabled;
    private Collection<String> defaultUserGroups;
    private IdentityZoneValidator validator = (config, mode) -> config;
    private Map<String, Object> branding;

    public void setValidator(IdentityZoneValidator validator) {
        this.validator = validator;
    }

    public IdentityZoneConfigurationBootstrap(IdentityZoneProvisioning provisioning) {
        this.provisioning = provisioning;
    }

    public void afterPropertiesSet() throws InvalidIdentityZoneDetailsException {
        IdentityZone identityZone = this.provisioning.retrieve(IdentityZone.getUaa().getId());
        IdentityZoneConfiguration definition = new IdentityZoneConfiguration(this.tokenPolicy);
        definition.getLinks().getSelfService().setSelfServiceLinksEnabled(this.selfServiceLinksEnabled);
        definition.getLinks().setHomeRedirect(this.homeRedirect);
        definition.getSamlConfig().setCertificate(this.samlSpCertificate);
        definition.getSamlConfig().setPrivateKey(this.samlSpPrivateKey);
        definition.getSamlConfig().setPrivateKeyPassword(this.samlSpPrivateKeyPassphrase);
        definition.setIdpDiscoveryEnabled(this.idpDiscoveryEnabled);
        definition.setAccountChooserEnabled(this.accountChooserEnabled);
        this.samlKeys = Optional.ofNullable(this.samlKeys).orElse(Collections.EMPTY_MAP);
        for (Map.Entry<String, Map<String, String>> entry : this.samlKeys.entrySet()) {
            SamlKey samlKey = new SamlKey(entry.getValue().get("key"), entry.getValue().get("passphrase"), entry.getValue().get("certificate"));
            definition.getSamlConfig().addKey(entry.getKey(), samlKey);
        }
        definition.getSamlConfig().setActiveKeyId(this.activeKeyId);
        if (this.selfServiceLinks != null) {
            String signup = (String)this.selfServiceLinks.get("signup");
            String passwd = (String)this.selfServiceLinks.get("passwd");
            if (StringUtils.hasText((String)signup)) {
                definition.getLinks().getSelfService().setSignup(signup);
            }
            if (StringUtils.hasText((String)passwd)) {
                definition.getLinks().getSelfService().setPasswd(passwd);
            }
        }
        if (Objects.nonNull(this.logoutRedirectWhitelist)) {
            definition.getLinks().getLogout().setWhitelist(this.logoutRedirectWhitelist);
        }
        if (StringUtils.hasText((String)this.logoutRedirectParameterName)) {
            definition.getLinks().getLogout().setRedirectParameterName(this.logoutRedirectParameterName);
        }
        if (StringUtils.hasText((String)this.logoutDefaultRedirectUrl)) {
            definition.getLinks().getLogout().setRedirectUrl(this.logoutDefaultRedirectUrl);
        }
        definition.getLinks().getLogout().setDisableRedirectParameter(this.logoutDisableRedirectParameter);
        if (Objects.nonNull(this.prompts)) {
            definition.setPrompts(this.prompts);
        }
        BrandingInformation brandingInfo = (BrandingInformation)JsonUtils.convertValue(this.branding, BrandingInformation.class);
        definition.setBranding(brandingInfo);
        if (this.defaultUserGroups != null) {
            definition.getUserConfig().setDefaultGroups(new LinkedList<String>(this.defaultUserGroups));
        }
        identityZone.setConfig(definition);
        identityZone = this.validator.validate(identityZone, IdentityZoneValidator.Mode.MODIFY);
        this.provisioning.update(identityZone);
    }

    public IdentityZoneConfigurationBootstrap setSamlKeys(Map<String, Map<String, String>> samlKeys) {
        this.samlKeys = samlKeys;
        return this;
    }

    public IdentityZoneConfigurationBootstrap setActiveKeyId(String activeKeyId) {
        this.activeKeyId = activeKeyId;
        return this;
    }

    public void setTokenPolicy(TokenPolicy tokenPolicy) {
        this.tokenPolicy = tokenPolicy;
    }

    public void setSelfServiceLinksEnabled(boolean selfServiceLinksEnabled) {
        this.selfServiceLinksEnabled = selfServiceLinksEnabled;
    }

    public void setHomeRedirect(String homeRedirect) {
        this.homeRedirect = homeRedirect;
    }

    public String getHomeRedirect() {
        return this.homeRedirect;
    }

    public void setSelfServiceLinks(Map<String, Object> links) {
        this.selfServiceLinks = links;
    }

    public void setLogoutDefaultRedirectUrl(String logoutDefaultRedirectUrl) {
        this.logoutDefaultRedirectUrl = logoutDefaultRedirectUrl;
    }

    public void setLogoutDisableRedirectParameter(boolean logoutDisableRedirectParameter) {
        this.logoutDisableRedirectParameter = logoutDisableRedirectParameter;
    }

    public void setLogoutRedirectParameterName(String logoutRedirectParameterName) {
        this.logoutRedirectParameterName = logoutRedirectParameterName;
    }

    public void setLogoutRedirectWhitelist(List<String> logoutRedirectWhitelist) {
        this.logoutRedirectWhitelist = logoutRedirectWhitelist;
    }

    public void setPrompts(List<Prompt> prompts) {
        this.prompts = prompts;
    }

    public void setSamlSpCertificate(String samlSpCertificate) {
        this.samlSpCertificate = samlSpCertificate;
    }

    public void setSamlSpPrivateKey(String samlSpPrivateKey) {
        this.samlSpPrivateKey = samlSpPrivateKey;
    }

    public void setSamlSpPrivateKeyPassphrase(String samlSpPrivateKeyPassphrase) {
        this.samlSpPrivateKeyPassphrase = samlSpPrivateKeyPassphrase;
    }

    public boolean isIdpDiscoveryEnabled() {
        return this.idpDiscoveryEnabled;
    }

    public void setIdpDiscoveryEnabled(boolean idpDiscoveryEnabled) {
        this.idpDiscoveryEnabled = idpDiscoveryEnabled;
    }

    public boolean isAccountChooserEnabled() {
        return this.accountChooserEnabled;
    }

    public void setAccountChooserEnabled(boolean accountChooserEnabled) {
        this.accountChooserEnabled = accountChooserEnabled;
    }

    public void setBranding(Map<String, Object> branding) {
        this.branding = branding;
    }

    public Map<String, Object> getBranding() {
        return this.branding;
    }

    public void setDefaultUserGroups(Collection<String> defaultUserGroups) {
        this.defaultUserGroups = defaultUserGroups;
    }
}

