/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.security;

import javax.servlet.http.HttpServletRequest;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public class GroupRoleCheck {
    private final ScimGroupMembershipManager manager;

    public GroupRoleCheck(ScimGroupMembershipManager manager) {
        this.manager = manager;
    }

    public boolean isGroupWriter(HttpServletRequest request, int pathVariableIndex) {
        return this.isGroupRole(request, pathVariableIndex, ScimGroupMember.Role.WRITER);
    }

    public boolean isGroupReader(HttpServletRequest request, int pathVariableIndex) {
        return this.isGroupRole(request, pathVariableIndex, ScimGroupMember.Role.READER);
    }

    public boolean isGroupMember(HttpServletRequest request, int pathVariableIndex) {
        return this.isGroupRole(request, pathVariableIndex, ScimGroupMember.Role.MEMBER);
    }

    public boolean isGroupRole(HttpServletRequest request, int pathVariableIndex, ScimGroupMember.Role role) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof UaaPrincipal) {
            String groupId;
            String userId = ((UaaPrincipal)authentication.getPrincipal()).getId();
            String path = UaaUrlUtils.getRequestPath(request);
            if (StringUtils.hasText((String)path) && this.manager.getMembers(groupId = UaaUrlUtils.extractPathVariableFromUrl(pathVariableIndex, path), role, IdentityZoneHolder.get().getId()).contains(new ScimGroupMember(userId))) {
                return true;
            }
        }
        return false;
    }
}

