--
-- Cloud Foundry 
-- Copyright (c) [2014] Pivotal Software, Inc. All Rights Reserved.
--
-- This product is licensed to you under the Apache License, Version 2.0 (the "License").
-- You may not use this product except in compliance with the License.
--
-- This product includes a number of subcomponents with
-- separate copyright notices and license terms. Your use of these
-- subcomponents is subject to the terms and conditions of the
-- subcomponent's license, as noted in the LICENSE file.
--
-- Autogenerated: do not edit this file

CREATE TABLE users (
   id CHAR(36) NOT NULL PRIMARY KEY,
   created TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
   lastmodified TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
   version BIGINT DEFAULT 0 NOT NULL,
   username VARCHAR_IGNORECASE(255) NOT NULL,
   password VARCHAR(255) NOT NULL,
   email VARCHAR(255) NOT NULL,
   authorities VARCHAR(1024) DEFAULT 'uaa.user' NOT NULL,
   givenname VARCHAR(255),
   familyname VARCHAR(255),
   active BOOLEAN DEFAULT TRUE NOT NULL,
   phonenumber VARCHAR(255),
   verified BOOLEAN DEFAULT FALSE NOT NULL
) ;

CREATE UNIQUE INDEX unique_uk_1 ON users (username);

CREATE TABLE sec_audit (
   principal_id CHAR(36) NOT NULL,
   event_type INTEGER NOT NULL,
   origin VARCHAR(255) NOT NULL,
   event_data VARCHAR(255),
   created TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ;

CREATE TABLE oauth_client_details (
  client_id VARCHAR(256) PRIMARY KEY,
  resource_ids VARCHAR(1024),
  client_secret VARCHAR(256),
  scope VARCHAR(256),
  authorized_grant_types VARCHAR(256),
  web_server_redirect_uri VARCHAR(1024),
  authorities VARCHAR(256),
  access_token_validity INTEGER DEFAULT 0,
  refresh_token_validity INTEGER DEFAULT 0,
  additional_information VARCHAR(4096)
) ;

create table oauth_code (
  code VARCHAR(256), authentication LONGVARBINARY
) ;

CREATE TABLE authz_approvals (
  username VARCHAR(36) NOT NULL,
  clientid VARCHAR(36) NOT NULL,
  scope VARCHAR(255) NOT NULL,
  expiresat TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  status VARCHAR(50) DEFAULT 'APPROVED' NOT NULL,
  lastmodifiedat TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  primary key (username, clientid, scope)
) ;

CREATE TABLE groups (
  id VARCHAR(36) NOT NULL PRIMARY KEY,
  displayname VARCHAR(255) NOT NULL,
  created TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  lastmodified TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  version INTEGER DEFAULT 0 NOT NULL,
  CONSTRAINT unique_uk_2 UNIQUE(displayname)
) ;

CREATE TABLE group_membership (
  group_id VARCHAR(36) NOT NULL,
  member_id VARCHAR(36) NOT NULL,
  member_type VARCHAR(8) DEFAULT 'USER' NOT NULL,
  authorities VARCHAR(255) DEFAULT 'READ' NOT NULL,
  added TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  PRIMARY KEY (group_id, member_id)
) ;

CREATE TABLE external_group_mapping (
  group_id VARCHAR(36) NOT NULL,
  external_group VARCHAR(255) NOT NULL,
  added TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  PRIMARY KEY (group_id, external_group)
);
