/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.EntityDeletedEvent;
import org.cloudfoundry.identity.uaa.authentication.SystemAuthentication;
import org.cloudfoundry.identity.uaa.authentication.manager.AuthEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.ExternalGroupAuthorizationEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.InvitedUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.NewUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberNotFoundException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScimUserBootstrap
implements InitializingBean,
ApplicationListener<ApplicationEvent>,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(ScimUserBootstrap.class);
    private final ScimUserProvisioning scimUserProvisioning;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final ScimGroupMembershipManager membershipManager;
    private boolean override = false;
    private final Collection<UaaUser> users;
    private List<String> usersToDelete;
    private ApplicationEventPublisher publisher;

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isOverride() {
        return this.override;
    }

    public ScimUserBootstrap(ScimUserProvisioning scimUserProvisioning, ScimGroupProvisioning scimGroupProvisioning, ScimGroupMembershipManager membershipManager, Collection<UaaUser> users) {
        Assert.notNull((Object)scimUserProvisioning, (String)"scimUserProvisioning cannot be null");
        Assert.notNull((Object)scimGroupProvisioning, (String)"scimGroupProvisioning cannont be null");
        Assert.notNull((Object)membershipManager, (String)"memberShipManager cannot be null");
        Assert.notNull(users, (String)"users list cannot be null");
        this.scimUserProvisioning = scimUserProvisioning;
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.membershipManager = membershipManager;
        this.users = Collections.unmodifiableCollection(users);
    }

    public void setUsersToDelete(List<String> usersToDelete) {
        this.usersToDelete = usersToDelete;
    }

    public void afterPropertiesSet() throws Exception {
        LinkedList<UaaUser> users = new LinkedList<UaaUser>(Optional.ofNullable(this.users).orElse(Collections.emptyList()));
        List deleteMe = Optional.ofNullable(this.usersToDelete).orElse(Collections.emptyList());
        users.removeIf(u -> deleteMe.contains(u.getUsername()));
        for (UaaUser u2 : users) {
            this.addUser(u2);
        }
    }

    public void deleteUsers(@NotNull List<String> deleteList) throws Exception {
        if (deleteList.size() == 0) {
            return;
        }
        StringBuilder filter = new StringBuilder();
        for (int i = deleteList.size() - 1; i >= 0; --i) {
            filter.append("username eq \"");
            filter.append(deleteList.get(i));
            filter.append("\"");
            if (i <= 0) continue;
            filter.append(" or ");
        }
        List list = this.scimUserProvisioning.query("origin eq \"uaa\" and (" + filter.toString() + ")", IdentityZoneHolder.get().getId());
        for (ScimUser delete : list) {
            this.publish(new EntityDeletedEvent<ScimUser>(delete, (Authentication)SystemAuthentication.SYSTEM_AUTHENTICATION));
        }
    }

    protected ScimUser getScimUser(UaaUser user) {
        List<Object> users = this.scimUserProvisioning.query("userName eq \"" + user.getUsername() + "\" and origin eq \"" + (user.getOrigin() == null ? "uaa" : user.getOrigin()) + "\"", IdentityZoneHolder.get().getId());
        if (users.isEmpty() && StringUtils.hasText((String)user.getId())) {
            try {
                users = Arrays.asList((ScimUser)this.scimUserProvisioning.retrieve(user.getId(), IdentityZoneHolder.get().getId()));
            }
            catch (ScimResourceNotFoundException x) {
                logger.debug((Object)("Unable to find scim user based on ID:" + user.getId()));
            }
        }
        return users.isEmpty() ? null : (ScimUser)users.get(0);
    }

    protected void addUser(UaaUser user) {
        ScimUser scimUser = this.getScimUser(user);
        if (scimUser == null) {
            if (StringUtils.isEmpty((Object)user.getPassword()) && user.getOrigin().equals("uaa")) {
                logger.debug((Object)"User's password cannot be empty");
                throw new InvalidPasswordException("Password cannot be empty", HttpStatus.BAD_REQUEST);
            }
            this.createNewUser(user);
        } else if (this.override) {
            this.updateUser(scimUser, user);
        } else {
            logger.debug((Object)("Override flag not set. Not registering existing user: " + user));
        }
    }

    private void updateUser(ScimUser existingUser, UaaUser updatedUser) {
        this.updateUser(existingUser, updatedUser, true);
    }

    private void updateUser(ScimUser existingUser, UaaUser updatedUser, boolean updateGroups) {
        String id = existingUser.getId();
        logger.debug((Object)("Updating user account: " + updatedUser + " with SCIM Id: " + id));
        if (updateGroups) {
            logger.debug((Object)"Removing existing group memberships ...");
            Set<ScimGroup> existingGroups = this.membershipManager.getGroupsWithMember(id, true, IdentityZoneHolder.get().getId());
            for (ScimGroup g : existingGroups) {
                this.removeFromGroup(id, g.getDisplayName());
            }
        }
        ScimUser newScimUser = this.convertToScimUser(updatedUser);
        newScimUser.setVersion(existingUser.getVersion());
        this.scimUserProvisioning.update(id, newScimUser, IdentityZoneHolder.get().getId());
        if ("uaa".equals(newScimUser.getOrigin()) && StringUtils.hasText((String)updatedUser.getPassword())) {
            this.scimUserProvisioning.changePassword(id, null, updatedUser.getPassword(), IdentityZoneHolder.get().getId());
        }
        if (updateGroups) {
            Collection<String> newGroups = this.convertToGroups(updatedUser.getAuthorities());
            logger.debug((Object)("Adding new groups " + newGroups));
            this.addGroups(id, newGroups);
        }
    }

    private void createNewUser(UaaUser user) {
        logger.debug((Object)("Registering new user account: " + user));
        ScimUser newScimUser = this.scimUserProvisioning.createUser(this.convertToScimUser(user), user.getPassword(), IdentityZoneHolder.get().getId());
        this.addGroups(newScimUser.getId(), this.convertToGroups(user.getAuthorities()));
    }

    private void addGroups(String scimUserid, Collection<String> groups) {
        for (String group : groups) {
            this.addToGroup(scimUserid, group);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof AuthEvent) {
            this.onApplicationEvent((AuthEvent)event);
        } else if (event instanceof ContextRefreshedEvent) {
            List<String> deleteMe = Optional.ofNullable(this.usersToDelete).orElse(Collections.emptyList());
            try {
                this.deleteUsers(deleteMe);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to delete users from manifest.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void onApplicationEvent(AuthEvent event) {
        if (event instanceof InvitedUserAuthenticatedEvent) {
            ScimUser user = this.getScimUser(event.getUser());
            this.updateUser(user, event.getUser(), false);
            return;
        }
        if (event instanceof ExternalGroupAuthorizationEvent) {
            ExternalGroupAuthorizationEvent exEvent = (ExternalGroupAuthorizationEvent)event;
            String origin = exEvent.getUser().getOrigin();
            if (!"uaa".equals(origin)) {
                this.membershipManager.removeMembersByMemberId(event.getUser().getId(), origin, IdentityZoneHolder.get().getId());
            }
            for (GrantedAuthority grantedAuthority : exEvent.getExternalAuthorities()) {
                this.addToGroup(exEvent.getUser().getId(), grantedAuthority.getAuthority(), exEvent.getUser().getOrigin(), exEvent.isAddGroups());
            }
            if (event.isUserModified()) {
                ScimUser user = this.getScimUser(event.getUser());
                this.updateUser(user, event.getUser(), false);
            }
            return;
        }
        if (event instanceof NewUserAuthenticatedEvent) {
            this.addUser(event.getUser());
            return;
        }
    }

    private void addToGroup(String scimUserId, String gName) {
        this.addToGroup(scimUserId, gName, "uaa", true);
    }

    private void addToGroup(String scimUserId, String gName, String origin, boolean addGroup) {
        ScimGroup group;
        if (!StringUtils.hasText((String)gName)) {
            return;
        }
        logger.debug((Object)("Adding to group: " + gName));
        List g = this.scimGroupProvisioning.query(String.format("displayName eq \"%s\"", gName), IdentityZoneHolder.get().getId());
        if ((g == null || g.isEmpty()) && !addGroup) {
            logger.debug((Object)("No group found with name:" + gName + ". Group membership will not be added."));
            return;
        }
        if (g == null || g.isEmpty()) {
            group = new ScimGroup(null, gName, IdentityZoneHolder.get().getId());
            group = this.scimGroupProvisioning.create(group, IdentityZoneHolder.get().getId());
        } else {
            group = (ScimGroup)g.get(0);
        }
        try {
            ScimGroupMember groupMember = new ScimGroupMember(scimUserId);
            groupMember.setOrigin(origin);
            this.membershipManager.addMember(group.getId(), groupMember, IdentityZoneHolder.get().getId());
        }
        catch (MemberAlreadyExistsException memberAlreadyExistsException) {
            // empty catch block
        }
    }

    private void removeFromGroup(String scimUserId, String gName) {
        if (!StringUtils.hasText((String)gName)) {
            return;
        }
        logger.debug((Object)("Removing membership of group: " + gName));
        List g = this.scimGroupProvisioning.query(String.format("displayName eq \"%s\"", gName), IdentityZoneHolder.get().getId());
        if (g == null || g.isEmpty()) {
            return;
        }
        ScimGroup group = (ScimGroup)g.get(0);
        try {
            this.membershipManager.removeMemberById(group.getId(), scimUserId, IdentityZoneHolder.get().getId());
        }
        catch (MemberNotFoundException memberNotFoundException) {
            // empty catch block
        }
    }

    private ScimUser convertToScimUser(UaaUser user) {
        ScimUser scim = new ScimUser(user.getId(), user.getUsername(), user.getGivenName(), user.getFamilyName());
        scim.addPhoneNumber(user.getPhoneNumber());
        scim.addEmail(user.getEmail());
        scim.setOrigin(user.getOrigin());
        scim.setExternalId(user.getExternalId());
        scim.setVerified(true);
        return scim;
    }

    private Collection<String> convertToGroups(List<? extends GrantedAuthority> authorities) {
        ArrayList<String> groups = new ArrayList<String>();
        for (GrantedAuthority grantedAuthority : authorities) {
            groups.add(grantedAuthority.toString());
        }
        return groups;
    }

    public void publish(ApplicationEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }
}

