/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.oauth;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.manager.ExternalGroupAuthorizationEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.ExternalLoginAuthenticationManager;
import org.cloudfoundry.identity.uaa.authentication.manager.InvitedUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.TokenKeyEndpoint;
import org.cloudfoundry.identity.uaa.oauth.UaaTokenServices;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKey;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKeyHelper;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKeySet;
import org.cloudfoundry.identity.uaa.oauth.jwt.ChainedSignatureVerifier;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.oauth.token.CompositeAccessToken;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.OIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.RawXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthCodeToken;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthProviderConfigurator;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthUserAuthority;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserPrototype;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.LinkedMaskingMultiValueMap;
import org.cloudfoundry.identity.uaa.util.RestTemplateFactory;
import org.cloudfoundry.identity.uaa.util.TokenValidation;
import org.cloudfoundry.identity.uaa.util.UaaHttpRequestUtils;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;

public class XOAuthAuthenticationManager
extends ExternalLoginAuthenticationManager<AuthenticationData> {
    public static Log logger = LogFactory.getLog(XOAuthAuthenticationManager.class);
    private final RestTemplateFactory restTemplateFactory;
    private UaaTokenServices tokenServices;
    private final ThreadLocal<String> origin = ThreadLocal.withInitial(() -> "unknown");

    public XOAuthAuthenticationManager(IdentityProviderProvisioning providerProvisioning, RestTemplateFactory restTemplateFactory) {
        super(providerProvisioning);
        this.restTemplateFactory = restTemplateFactory;
    }

    @Override
    public String getOrigin() {
        return this.origin.get();
    }

    @Override
    public void setOrigin(String origin) {
        this.origin.set(origin);
    }

    public IdentityProvider resolveOriginProvider(String idToken, String contextPath) throws AuthenticationException {
        try {
            String claimsString = JwtHelper.decode(Optional.ofNullable(idToken).orElse("")).getClaims();
            Map claims = (Map)JsonUtils.readValue((String)claimsString, (TypeReference)new TypeReference<Map<String, Object>>(){});
            String issuer = (String)claims.get("iss");
            if (StringUtils.isEmpty((Object)issuer)) {
                throw new InsufficientAuthenticationException("Issuer is missing in id_token");
            }
            if (this.tokenServices.getTokenEndpoint().equals(issuer)) {
                OIDCIdentityProviderDefinition uaaOidcProviderConfig = new OIDCIdentityProviderDefinition();
                uaaOidcProviderConfig.setTokenKeyUrl(new URL(contextPath + "/token_keys"));
                uaaOidcProviderConfig.setIssuer(issuer);
                IdentityProvider uaaIdp = new IdentityProvider();
                uaaIdp.setOriginKey("uaa");
                uaaIdp.setConfig((AbstractIdentityProviderDefinition)uaaOidcProviderConfig);
                return uaaIdp;
            }
            try {
                return ((XOAuthProviderConfigurator)this.getProviderProvisioning()).retrieveByIssuer(issuer, IdentityZoneHolder.get().getId());
            }
            catch (IncorrectResultSizeDataAccessException x) {
                throw new InsufficientAuthenticationException(String.format("Unable to map issuer, %s , to a single registered provider", issuer));
            }
        }
        catch (IllegalArgumentException | JsonUtils.JsonUtilException x) {
            throw new InsufficientAuthenticationException("Unable to decode expected id_token");
        }
        catch (MalformedURLException x) {
            throw new InsufficientAuthenticationException("Unable to derive context path from request URL");
        }
    }

    @Override
    public AuthenticationData getExternalAuthenticationDetails(Authentication authentication) {
        IdentityProvider provider = null;
        XOAuthCodeToken codeToken = (XOAuthCodeToken)authentication;
        if (StringUtils.isEmpty((Object)codeToken.getOrigin())) {
            provider = this.resolveOriginProvider(codeToken.getIdToken(), codeToken.getRequestContextPath());
            codeToken.setOrigin(provider.getOriginKey());
        }
        this.setOrigin(codeToken.getOrigin());
        if (provider == null) {
            provider = this.getProviderProvisioning().retrieveByOrigin(this.getOrigin(), IdentityZoneHolder.get().getId());
        }
        if (provider != null && provider.getConfig() instanceof AbstractXOAuthIdentityProviderDefinition) {
            String username;
            AuthenticationData authenticationData = new AuthenticationData();
            AbstractXOAuthIdentityProviderDefinition config = (AbstractXOAuthIdentityProviderDefinition)provider.getConfig();
            Map<String, Object> claims = this.getClaimsFromToken(codeToken, config);
            if (claims == null) {
                return null;
            }
            authenticationData.setClaims(claims);
            Map attributeMappings = config.getAttributeMappings();
            String userNameAttributePrefix = (String)attributeMappings.get("user_name");
            String preferredUsername = "preferred_username";
            if (StringUtils.hasText((String)userNameAttributePrefix)) {
                username = (String)claims.get(userNameAttributePrefix);
                logger.debug((Object)String.format("Extracted username for claim: %s and username is: %s", userNameAttributePrefix, username));
            } else if (claims.get(preferredUsername) != null) {
                username = (String)claims.get(preferredUsername);
                logger.debug((Object)String.format("Extracted username for claim: %s and username is: %s", preferredUsername, username));
            } else {
                username = (String)claims.get("sub");
                logger.debug((Object)String.format("Extracted username for claim: %s and username is: %s", "sub", username));
            }
            if (!StringUtils.hasText((String)username)) {
                throw new InsufficientAuthenticationException("Unable to map claim to a username");
            }
            authenticationData.setUsername(username);
            List groupWhiteList = config.getExternalGroupsWhitelist();
            authenticationData.setAuthorities(this.extractXOAuthUserAuthorities(attributeMappings, claims, groupWhiteList));
            Optional.ofNullable(attributeMappings).ifPresent(map -> authenticationData.setAttributeMappings(new HashMap<String, Object>((Map<String, Object>)map)));
            return authenticationData;
        }
        logger.debug((Object)("No identity provider found for origin:" + this.getOrigin() + " and zone:" + IdentityZoneHolder.get().getId()));
        return null;
    }

    @Override
    protected void populateAuthenticationAttributes(UaaAuthentication authentication, Authentication request, AuthenticationData authenticationData) {
        Map<String, Object> claims = authenticationData.getClaims();
        if (claims != null) {
            Object acr;
            if (claims.get("amr") != null) {
                if (authentication.getAuthenticationMethods() == null) {
                    authentication.setAuthenticationMethods(new HashSet<String>((Collection)claims.get("amr")));
                } else {
                    authentication.getAuthenticationMethods().addAll((Collection)claims.get("amr"));
                }
            }
            if ((acr = claims.get("acr")) != null) {
                if (acr instanceof Map) {
                    Map acrMap = (Map)acr;
                    Object values = acrMap.get("values");
                    if (values instanceof Collection) {
                        authentication.setAuthContextClassRef(new HashSet<String>((Collection)values));
                    } else if (values instanceof String[]) {
                        authentication.setAuthContextClassRef(new HashSet<String>(Arrays.asList((String[])values)));
                    } else {
                        logger.debug((Object)String.format("Unrecognized ACR claim[%s] for user_id: %s", values, authentication.getPrincipal().getId()));
                    }
                } else if (acr instanceof String) {
                    authentication.setAuthContextClassRef(new HashSet<String>(Arrays.asList((String)acr)));
                } else {
                    logger.debug((Object)String.format("Unrecognized ACR claim[%s] for user_id: %s", acr, authentication.getPrincipal().getId()));
                }
            }
            LinkedMultiValueMap userAttributes = new LinkedMultiValueMap();
            logger.debug((Object)"Mapping XOauth custom attributes");
            for (Map.Entry<String, Object> entry : authenticationData.getAttributeMappings().entrySet()) {
                if (!entry.getKey().startsWith("user.attribute.") || entry.getValue() == null) continue;
                String key = entry.getKey().substring("user.attribute.".length());
                Object values = claims.get(entry.getValue());
                if (values == null) continue;
                logger.debug((Object)String.format("Mapped XOauth attribute %s to %s", key, values));
                if (values instanceof List) {
                    List list = (List)values;
                    List strings = list.stream().map(object -> Objects.toString(object, null)).collect(Collectors.toList());
                    userAttributes.put((Object)key, strings);
                    continue;
                }
                if (values instanceof String) {
                    userAttributes.put((Object)key, Arrays.asList((String)values));
                    continue;
                }
                userAttributes.put((Object)key, Arrays.asList(values.toString()));
            }
            authentication.setUserAttributes((MultiValueMap<String, String>)userAttributes);
            authentication.setExternalGroups(Optional.ofNullable(authenticationData.getAuthorities()).orElse(Collections.emptyList()).stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
        }
        super.populateAuthenticationAttributes(authentication, request, authenticationData);
    }

    @Override
    protected List<String> getExternalUserAuthorities(UserDetails request) {
        return super.getExternalUserAuthorities(request);
    }

    @Override
    protected UaaUser getUser(Authentication request, AuthenticationData authenticationData) {
        if (authenticationData != null) {
            Map<String, Object> claims = authenticationData.getClaims();
            String username = authenticationData.getUsername();
            String email = (String)claims.get("email");
            if (email == null) {
                email = this.generateEmailIfNull(username);
            }
            logger.debug((Object)String.format("Returning user data for username:%s, email:%s", username, email));
            return new UaaUser(new UaaUserPrototype().withEmail(email).withGivenName((String)claims.get("given_name")).withFamilyName((String)claims.get("family_name")).withPhoneNumber((String)claims.get("phone_number")).withModified(new Date()).withUsername(username).withPassword("").withAuthorities(authenticationData.getAuthorities()).withCreated(new Date()).withOrigin(this.getOrigin()).withExternalId(null).withVerified(true).withZoneId(IdentityZoneHolder.get().getId()).withSalt(null).withPasswordLastModified(null));
        }
        logger.debug((Object)"Authenticate data is missing, unable to return user");
        return null;
    }

    protected List<? extends GrantedAuthority> extractXOAuthUserAuthorities(Map<String, Object> attributeMappings, Map<String, Object> claims, Collection<String> groupWhiteList) {
        LinkedList<String> groupNames = new LinkedList<String>();
        if (attributeMappings.get("external_groups") instanceof String) {
            groupNames.add((String)attributeMappings.get("external_groups"));
        } else if (attributeMappings.get("external_groups") instanceof Collection) {
            groupNames.addAll((Collection)attributeMappings.get("external_groups"));
        }
        logger.debug((Object)("Extracting XOauth group names:" + groupNames));
        Set scopes = new HashSet<String>();
        for (String g : groupNames) {
            Object roles = claims.get(g);
            if (roles instanceof String) {
                scopes.addAll(Arrays.asList(((String)roles).split(",")));
                continue;
            }
            if (!(roles instanceof Collection)) continue;
            scopes.addAll((Collection)roles);
        }
        logger.debug((Object)("Filtering XOauth scopes:" + scopes));
        scopes = UaaStringUtils.retainAllMatches(scopes, groupWhiteList);
        logger.debug((Object)("Filtered XOauth scopes:" + scopes));
        ArrayList<XOAuthUserAuthority> authorities = new ArrayList<XOAuthUserAuthority>();
        for (String scope : scopes) {
            authorities.add(new XOAuthUserAuthority(scope));
        }
        return authorities;
    }

    @Override
    protected UaaUser userAuthenticated(Authentication request, UaaUser userFromRequest, UaaUser userFromDb) {
        boolean userModified = false;
        boolean is_invitation_acceptance = UaaHttpRequestUtils.isAcceptedInvitationAuthentication();
        String email = userFromRequest.getEmail();
        logger.debug((Object)("XOAUTH user authenticated:" + email));
        if (is_invitation_acceptance) {
            String invitedUserId = (String)RequestContextHolder.currentRequestAttributes().getAttribute("user_id", 1);
            logger.debug((Object)("XOAUTH user accepted invitation, user_id:" + invitedUserId));
            userFromDb = this.getUserDatabase().retrieveUserById(invitedUserId);
            if (email != null && !email.equalsIgnoreCase(userFromDb.getEmail())) {
                throw new BadCredentialsException("OAuth User email mismatch. Authenticated email doesn't match invited email.");
            }
            this.publish(new InvitedUserAuthenticatedEvent(userFromDb));
            userFromDb = this.getUserDatabase().retrieveUserById(invitedUserId);
        }
        if (request.getPrincipal() != null && this.haveUserAttributesChanged(userFromDb, userFromRequest)) {
            logger.debug((Object)"User attributed have changed, updating them.");
            userFromDb = userFromDb.modifyAttributes(email, userFromRequest.getGivenName(), userFromRequest.getFamilyName(), userFromRequest.getPhoneNumber()).modifyUsername(userFromRequest.getUsername());
            userModified = true;
        }
        ExternalGroupAuthorizationEvent event = new ExternalGroupAuthorizationEvent(userFromDb, userModified, userFromRequest.getAuthorities(), true);
        this.publish(event);
        return this.getUserDatabase().retrieveUserById(userFromDb.getId());
    }

    @Override
    protected boolean isAddNewShadowUser() {
        if (!super.isAddNewShadowUser()) {
            return false;
        }
        IdentityProvider provider = this.getProviderProvisioning().retrieveByOrigin(this.getOrigin(), IdentityZoneHolder.get().getId());
        return ((AbstractXOAuthIdentityProviderDefinition)provider.getConfig()).isAddShadowUserOnLogin();
    }

    public RestTemplate getRestTemplate(AbstractXOAuthIdentityProviderDefinition config) {
        return this.restTemplateFactory.getRestTemplate(config.isSkipSslValidation());
    }

    private String getResponseType(AbstractXOAuthIdentityProviderDefinition config) {
        if (RawXOAuthIdentityProviderDefinition.class.isAssignableFrom(config.getClass())) {
            return "token";
        }
        if (OIDCIdentityProviderDefinition.class.isAssignableFrom(config.getClass())) {
            return "id_token";
        }
        throw new IllegalArgumentException("Unknown type for provider.");
    }

    protected Map<String, Object> getClaimsFromToken(XOAuthCodeToken codeToken, AbstractXOAuthIdentityProviderDefinition config) {
        String idToken = this.getTokenFromCode(codeToken, config);
        return this.getClaimsFromToken(idToken, config);
    }

    protected Map<String, Object> getClaimsFromToken(String idToken, AbstractXOAuthIdentityProviderDefinition config) {
        logger.debug((Object)"Extracting claims from id_token");
        if (idToken == null) {
            logger.debug((Object)"id_token is null, no claims returned.");
            return null;
        }
        TokenValidation validation = this.validateToken(idToken, config);
        logger.debug((Object)"Decoding id_token");
        Jwt decodeIdToken = validation.getJwt();
        logger.debug((Object)"Deserializing id_token claims");
        return (Map)JsonUtils.readValue((String)decodeIdToken.getClaims(), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    private TokenValidation validateToken(String idToken, AbstractXOAuthIdentityProviderDefinition config) {
        TokenValidation validation;
        logger.debug((Object)"Validating id_token");
        if (this.tokenServices.getTokenEndpoint().equals(config.getIssuer())) {
            JsonWebKeySet<JsonWebKey> tokenKey = this.getTokenKeyForUaaOrigin();
            validation = TokenValidation.validate(idToken).checkSignature(new ChainedSignatureVerifier(tokenKey));
        } else {
            JsonWebKeySet<JsonWebKey> tokenKey = this.getTokenKeyFromOAuth(config);
            validation = TokenValidation.validate(idToken).checkSignature(new ChainedSignatureVerifier(tokenKey)).checkIssuer(StringUtils.isEmpty((Object)config.getIssuer()) ? config.getTokenUrl().toString() : config.getIssuer()).checkAudience(config.getRelyingPartyId());
        }
        return validation.checkExpiry().throwIfInvalid();
    }

    protected JsonWebKeySet<JsonWebKey> getTokenKeyForUaaOrigin() {
        Map<String, KeyInfo> keys = KeyInfo.getKeys();
        List<Map<String, Object>> resultMaps = keys.values().stream().map(TokenKeyEndpoint::getResultMap).collect(Collectors.toList());
        return JsonWebKeyHelper.fromResultMaps(resultMaps);
    }

    private JsonWebKeySet<JsonWebKey> getTokenKeyFromOAuth(AbstractXOAuthIdentityProviderDefinition config) {
        String tokenKey = config.getTokenKey();
        if (StringUtils.hasText((String)tokenKey)) {
            HashMap<String, String> p = new HashMap<String, String>();
            p.put("value", tokenKey);
            p.put("kty", KeyInfo.isAssymetricKey(tokenKey) ? JsonWebKey.KeyType.RSA.name() : JsonWebKey.KeyType.MAC.name());
            logger.debug((Object)"Key configured, returning.");
            return new JsonWebKeySet(Arrays.asList(new JsonWebKey(p)));
        }
        URL tokenKeyUrl = config.getTokenKeyUrl();
        if (tokenKeyUrl == null || !StringUtils.hasText((String)tokenKeyUrl.toString())) {
            return new JsonWebKeySet(Collections.emptyList());
        }
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Authorization", (Object)this.getClientAuthHeader(config));
        headers.add((Object)"Accept", (Object)"application/json");
        HttpEntity tokenKeyRequest = new HttpEntity(null, (MultiValueMap)headers);
        logger.debug((Object)("Fetching token keys from:" + tokenKeyUrl));
        ResponseEntity responseEntity = this.getRestTemplate(config).exchange(tokenKeyUrl.toString(), HttpMethod.GET, tokenKeyRequest, String.class, new Object[0]);
        logger.debug((Object)("Token key response:" + responseEntity.getStatusCode()));
        if (responseEntity.getStatusCode() == HttpStatus.OK) {
            return JsonWebKeyHelper.deserialize((String)responseEntity.getBody());
        }
        throw new InvalidTokenException("Unable to fetch verification keys, status:" + responseEntity.getStatusCode());
    }

    private String getTokenFromCode(XOAuthCodeToken codeToken, AbstractXOAuthIdentityProviderDefinition config) {
        URI requestUri;
        if (StringUtils.hasText((String)codeToken.getIdToken()) && "id_token".equals(this.getResponseType(config))) {
            logger.debug((Object)"XOauthCodeToken contains id_token, not exchanging code.");
            return codeToken.getIdToken();
        }
        LinkedMaskingMultiValueMap body = new LinkedMaskingMultiValueMap("code");
        body.add("grant_type", "authorization_code");
        body.add("response_type", this.getResponseType(config));
        body.add("code", codeToken.getCode());
        body.add("redirect_uri", codeToken.getRedirectUrl());
        HttpHeaders headers = new HttpHeaders();
        String clientAuthHeader = this.getClientAuthHeader(config);
        headers.add("Authorization", clientAuthHeader);
        headers.add("Accept", "application/json");
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            requestUri = config.getTokenUrl().toURI();
        }
        catch (URISyntaxException e) {
            logger.error((Object)("Invalid URI configured:" + config.getTokenUrl()), (Throwable)e);
            return null;
        }
        logger.debug((Object)String.format("Performing token exchange with url:%s and request:%s", requestUri, body));
        ResponseEntity responseEntity = this.getRestTemplate(config).exchange(requestUri, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, String>>(){});
        logger.debug((Object)String.format("Request completed with status:%s", responseEntity.getStatusCode()));
        return (String)((Map)responseEntity.getBody()).get(CompositeAccessToken.ID_TOKEN);
    }

    private String getClientAuthHeader(AbstractXOAuthIdentityProviderDefinition config) {
        String clientAuth = new String(Base64.encodeBase64((byte[])(config.getRelyingPartyId() + ":" + config.getRelyingPartySecret()).getBytes()));
        return "Basic " + clientAuth;
    }

    public void setUaaTokenServices(UaaTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    protected static class AuthenticationData {
        private Map<String, Object> claims;
        private String username;
        private List<? extends GrantedAuthority> authorities;
        private Map<String, Object> attributeMappings;

        protected AuthenticationData() {
        }

        public Map<String, Object> getAttributeMappings() {
            return this.attributeMappings;
        }

        public void setAttributeMappings(Map<String, Object> attributeMappings) {
            this.attributeMappings = attributeMappings;
        }

        public void setClaims(Map<String, Object> claims) {
            this.claims = claims;
        }

        public Map<String, Object> getClaims() {
            return this.claims;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getUsername() {
            return this.username;
        }

        public List<? extends GrantedAuthority> getAuthorities() {
            return this.authorities;
        }

        public void setAuthorities(List<? extends GrantedAuthority> authorities) {
            this.authorities = authorities;
        }
    }
}

