/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.jdbc;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidScimResourceException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberNotFoundException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceConstraintFailedException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.util.TimeBasedExpiringValueMap;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.TimeServiceImpl;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcScimGroupMembershipManager
implements ScimGroupMembershipManager,
InitializingBean {
    private JdbcTemplate jdbcTemplate;
    private TimeService timeService = new TimeServiceImpl();
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final String MEMBERSHIP_FIELDS = "group_id,member_id,member_type,authorities,added,origin";
    public static final String MEMBERSHIP_TABLE = "group_membership";
    public static final String ADD_MEMBER_SQL = String.format("insert into %s ( %s ) values (?,?,?,?,?,?,?)", "group_membership", "group_id,member_id,member_type,authorities,added,origin,identity_zone_id");
    public static final String UPDATE_MEMBER_SQL = String.format("update %s set authorities=? where group_id=? and member_id=? and identity_zone_id=?", "group_membership");
    public static final String GET_GROUPS_BY_MEMBER_SQL = String.format("select distinct(group_id) from %s where member_id=? and identity_zone_id=?", "group_membership");
    public static final String GET_MEMBERS_WITH_AUTHORITY_SQL = String.format("select %s from %s where group_id=? and lower(authorities) like ? and identity_zone_id=?", "group_id,member_id,member_type,authorities,added,origin", "group_membership");
    public static final String GET_MEMBERS_SQL = String.format("select %s from %s where group_id=? and identity_zone_id=?", "group_id,member_id,member_type,authorities,added,origin", "group_membership");
    public static final String GET_MEMBER_SQL = String.format("select %s from %s where member_id=? and group_id=? and identity_zone_id=?", "group_id,member_id,member_type,authorities,added,origin", "group_membership");
    public static final String DELETE_MEMBER_WITH_ORIGIN_SQL = String.format("delete from %s where member_id=? and origin = ? and identity_zone_id=?", "group_membership");
    public static final String DELETE_MEMBER_SQL = String.format("delete from %s where member_id=? and group_id = ? and identity_zone_id=?", "group_membership");
    public static final String DELETE_MEMBERS_WITH_ORIGIN_GROUP_SQL = String.format("delete from %s where origin=? and identity_zone_id=?", "group_membership");
    public static final String DELETE_MEMBERS_IN_GROUP_SQL = String.format("delete from %s where group_id=? and identity_zone_id=?", "group_membership");
    public static final String DELETE_MEMBER_IN_GROUPS_SQL_USER = String.format("delete from %s where member_id=? and member_type='USER' and identity_zone_id=?", "group_membership");
    public static final String DELETE_MEMBER_IN_GROUPS_SQL_GROUP = String.format("delete from %s where member_id=? and member_type='GROUP' and identity_zone_id=?", "group_membership");
    private ScimUserProvisioning userProvisioning;
    private ScimGroupProvisioning groupProvisioning;
    private IdentityZoneProvisioning zoneProvisioning;
    private ScimGroupMemberRowMapper rowMapper;
    private TimeBasedExpiringValueMap<String, ScimGroup> defaultGroupCache = new TimeBasedExpiringValueMap(this.timeService);

    public void afterPropertiesSet() {
        this.defaultGroupCache = new TimeBasedExpiringValueMap(this.timeService);
    }

    public Set<ScimGroup> getDefaultUserGroups(String zoneId) {
        if (!StringUtils.hasText((String)zoneId)) {
            return Collections.emptySet();
        }
        IdentityZone currentZone = IdentityZoneHolder.get();
        List zoneDefaultGroups = currentZone.getConfig().getUserConfig().getDefaultGroups();
        if (!zoneId.equals(currentZone.getId())) {
            zoneDefaultGroups = this.zoneProvisioning.retrieve(zoneId).getConfig().getUserConfig().getDefaultGroups();
        }
        return zoneDefaultGroups.stream().map(groupName -> this.createOrGetGroup((String)groupName, zoneId)).collect(Collectors.toSet());
    }

    public ScimGroup createOrGetGroup(String displayName, String zoneId) {
        String key = zoneId + displayName;
        ScimGroup group = this.defaultGroupCache.get(key);
        if (group == null) {
            group = this.groupProvisioning.createOrGet(new ScimGroup(null, displayName, zoneId), zoneId);
            this.defaultGroupCache.put(key, group);
        }
        return group;
    }

    public void setZoneProvisioning(IdentityZoneProvisioning zoneProvisioning) {
        this.zoneProvisioning = zoneProvisioning;
    }

    public void setScimUserProvisioning(ScimUserProvisioning userProvisioning) {
        this.userProvisioning = userProvisioning;
    }

    public void setScimGroupProvisioning(ScimGroupProvisioning groupProvisioning) {
        this.groupProvisioning = groupProvisioning;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    public JdbcScimGroupMembershipManager(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
        this.rowMapper = new ScimGroupMemberRowMapper();
    }

    public boolean isDefaultGroup(String groupId, String zoneId) {
        for (ScimGroup g : this.getDefaultUserGroups(zoneId)) {
            if (!g.getId().equals(groupId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ScimGroupMember addMember(final String groupId, final ScimGroupMember member, final String zoneId) throws ScimResourceNotFoundException, MemberAlreadyExistsException {
        if (this.isDefaultGroup(groupId, zoneId)) {
            throw new MemberAlreadyExistsException("Trying to add member to default group");
        }
        this.validateRequest(groupId, member, zoneId);
        final String authorities = this.getGroupAuthorities(member);
        final String type = (member.getType() == null ? ScimGroupMember.Type.USER : member.getType()).toString();
        try {
            this.logger.debug((Object)("Associating group:" + groupId + " with member:" + member));
            this.jdbcTemplate.update(ADD_MEMBER_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, groupId);
                    ps.setString(2, member.getMemberId());
                    ps.setString(3, type);
                    ps.setString(4, authorities);
                    ps.setTimestamp(5, new Timestamp(new java.util.Date().getTime()));
                    ps.setString(6, member.getOrigin());
                    ps.setString(7, zoneId);
                }
            });
        }
        catch (DuplicateKeyException e) {
            throw new MemberAlreadyExistsException(member.getMemberId() + " is already part of the group: " + groupId);
        }
        return this.getMemberById(groupId, member.getMemberId(), zoneId);
    }

    @Override
    public List<ScimGroupMember> getMembers(String groupId, boolean includeEntities, String zoneId) throws ScimResourceNotFoundException {
        List result = this.jdbcTemplate.query(GET_MEMBERS_SQL, (RowMapper)this.rowMapper, new Object[]{groupId, zoneId});
        if (includeEntities) {
            for (ScimGroupMember member : result) {
                if (member.getType().equals((Object)ScimGroupMember.Type.USER)) {
                    ScimUser user = (ScimUser)this.userProvisioning.retrieve(member.getMemberId(), IdentityZoneHolder.get().getId());
                    member.setEntity((ScimCore)user);
                    continue;
                }
                if (!member.getType().equals((Object)ScimGroupMember.Type.GROUP)) continue;
                ScimGroup group = (ScimGroup)this.groupProvisioning.retrieve(member.getMemberId(), IdentityZoneHolder.get().getId());
                member.setEntity((ScimCore)group);
            }
        }
        return new ArrayList<ScimGroupMember>(result);
    }

    @Override
    public Set<ScimGroup> getGroupsWithMember(String memberId, boolean transitive, String zoneId) throws ScimResourceNotFoundException {
        ArrayList<ScimGroup> results = new ArrayList<ScimGroup>();
        this.getGroupsWithMember(results, memberId, transitive, zoneId);
        if (this.isUser(memberId)) {
            results.addAll(this.getDefaultUserGroups(zoneId));
        }
        return new HashSet<ScimGroup>(results);
    }

    private void getGroupsWithMember(List<ScimGroup> results, final String memberId, boolean transitive, final String zoneId) {
        List groupIds;
        if (results == null) {
            return;
        }
        try {
            groupIds = this.jdbcTemplate.query(GET_GROUPS_BY_MEMBER_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, memberId);
                    ps.setString(2, zoneId);
                }
            }, (RowMapper)new SingleColumnRowMapper(String.class));
        }
        catch (EmptyResultDataAccessException ex) {
            groupIds = Collections.EMPTY_LIST;
        }
        for (String groupId : groupIds) {
            ScimGroup group;
            try {
                group = (ScimGroup)this.groupProvisioning.retrieve(groupId, IdentityZoneHolder.get().getId());
            }
            catch (ScimResourceNotFoundException ex) {
                continue;
            }
            if (results.contains(group)) continue;
            results.add(group);
            if (!transitive) continue;
            this.getGroupsWithMember(results, groupId, transitive, zoneId);
        }
    }

    @Override
    public List<ScimGroupMember> getMembers(final String groupId, final ScimGroupMember.Role permission, final String zoneId) throws ScimResourceNotFoundException {
        this.logger.debug((Object)("getting members of type: " + permission + " from group: " + groupId));
        ArrayList<ScimGroupMember> members = new ArrayList<ScimGroupMember>();
        members.addAll(this.jdbcTemplate.query(GET_MEMBERS_WITH_AUTHORITY_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, groupId);
                ps.setString(2, "%" + permission.toString().toLowerCase() + "%");
                ps.setString(3, zoneId);
            }
        }, (RowMapper)this.rowMapper));
        return members;
    }

    @Override
    public ScimGroupMember getMemberById(String groupId, String memberId, String zoneId) throws ScimResourceNotFoundException, MemberNotFoundException {
        try {
            ScimGroupMember u = (ScimGroupMember)this.jdbcTemplate.queryForObject(GET_MEMBER_SQL, (RowMapper)this.rowMapper, new Object[]{memberId, groupId, zoneId});
            return u;
        }
        catch (EmptyResultDataAccessException e) {
            throw new MemberNotFoundException("Member " + memberId + " does not exist in group " + groupId);
        }
    }

    @Override
    public ScimGroupMember updateMember(final String groupId, final ScimGroupMember member, final String zoneId) throws ScimResourceNotFoundException, MemberNotFoundException {
        this.validateRequest(groupId, member, zoneId);
        final String authorities = this.getGroupAuthorities(member);
        int updated = this.jdbcTemplate.update(UPDATE_MEMBER_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, authorities);
                ps.setString(2, groupId);
                ps.setString(3, member.getMemberId());
                ps.setString(4, zoneId);
            }
        });
        if (updated == 0) {
            throw new MemberNotFoundException("Member " + member.getMemberId() + " does not exist in group " + groupId);
        }
        if (updated != 1) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members updated", 1, updated);
        }
        return this.getMemberById(groupId, member.getMemberId(), zoneId);
    }

    @Override
    public List<ScimGroupMember> updateOrAddMembers(String groupId, List<ScimGroupMember> members, String zoneId) throws ScimResourceNotFoundException {
        List<ScimGroupMember> currentMembers = this.getMembers(groupId, false, zoneId);
        this.logger.debug((Object)("current-members: " + currentMembers + ", in request: " + members));
        ArrayList<ScimGroupMember> currentMembersToRemove = new ArrayList<ScimGroupMember>(currentMembers);
        currentMembersToRemove.removeAll(members);
        this.logger.debug((Object)("removing members: " + currentMembersToRemove));
        for (ScimGroupMember scimGroupMember : currentMembersToRemove) {
            this.removeMemberById(groupId, scimGroupMember.getMemberId(), zoneId);
        }
        ArrayList<ScimGroupMember> newMembersToAdd = new ArrayList<ScimGroupMember>(members);
        newMembersToAdd.removeAll(currentMembers);
        this.logger.debug((Object)("adding new members: " + newMembersToAdd));
        for (ScimGroupMember member : newMembersToAdd) {
            this.addMember(groupId, member, zoneId);
        }
        ArrayList<ScimGroupMember> arrayList = new ArrayList<ScimGroupMember>(members);
        arrayList.retainAll(currentMembers);
        this.logger.debug((Object)("updating members: " + arrayList));
        for (ScimGroupMember member : arrayList) {
            this.updateMember(groupId, member, zoneId);
        }
        return this.getMembers(groupId, false, zoneId);
    }

    @Override
    public ScimGroupMember removeMemberById(final String groupId, final String memberId, final String zoneId) throws ScimResourceNotFoundException, MemberNotFoundException {
        ScimGroupMember member = this.getMemberById(groupId, memberId, zoneId);
        int deleted = this.jdbcTemplate.update(DELETE_MEMBER_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(2, groupId);
                ps.setString(1, memberId);
                ps.setString(3, zoneId);
            }
        });
        if (deleted != 1) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members removed", 1, deleted);
        }
        return member;
    }

    @Override
    public List<ScimGroupMember> removeMembersByGroupId(final String groupId, final String zoneId) throws ScimResourceNotFoundException {
        List<ScimGroupMember> members = this.getMembers(groupId, false, zoneId);
        this.logger.debug((Object)("removing " + members + " members from group: " + groupId));
        int deleted = this.jdbcTemplate.update(DELETE_MEMBERS_IN_GROUP_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, groupId);
                ps.setString(2, zoneId);
            }
        });
        if (deleted != members.size()) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members removed", members.size(), deleted);
        }
        return members;
    }

    @Override
    public Set<ScimGroup> removeMembersByMemberId(final String memberId, final String zoneId) throws ScimResourceNotFoundException {
        int expectedDelete;
        Set<ScimGroup> groups = this.getGroupsWithMember(memberId, false, zoneId);
        this.logger.debug((Object)("removing " + memberId + " from groups: " + groups));
        int deleted = 0;
        String sql = DELETE_MEMBER_IN_GROUPS_SQL_GROUP;
        if (this.isUser(memberId)) {
            sql = DELETE_MEMBER_IN_GROUPS_SQL_USER;
        }
        deleted = this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, memberId);
                ps.setString(2, zoneId);
            }
        });
        int n = expectedDelete = this.isUser(memberId) ? groups.size() - this.getDefaultUserGroups(zoneId).size() : groups.size();
        if (deleted != expectedDelete) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members removed", expectedDelete, deleted);
        }
        return groups;
    }

    @Override
    public Set<ScimGroup> removeMembersByMemberId(final String memberId, final String origin, final String zoneId) throws ScimResourceNotFoundException {
        Set<ScimGroup> groups = this.getGroupsWithMember(memberId, false, zoneId);
        this.logger.debug((Object)("removing " + memberId + " from groups: " + groups));
        int deleted = 0;
        String sql = DELETE_MEMBER_WITH_ORIGIN_SQL;
        deleted = this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, memberId);
                ps.setString(2, origin);
                ps.setString(3, zoneId);
            }
        });
        this.logger.debug((Object)String.format("Deleted %s memberships for member %s", deleted, memberId));
        return groups;
    }

    private boolean isUser(String uuid) {
        try {
            this.userProvisioning.retrieve(uuid, IdentityZoneHolder.get().getId());
            return true;
        }
        catch (ScimResourceNotFoundException ex) {
            return false;
        }
    }

    private void validateRequest(String groupId, ScimGroupMember member, String zoneId) {
        if (!(StringUtils.hasText((String)groupId) && StringUtils.hasText((String)member.getMemberId()) && StringUtils.hasText((String)member.getOrigin()))) {
            throw new InvalidScimResourceException("group-id, member-id, origin and member-type must be non-empty");
        }
        if (groupId.equals(member.getMemberId())) {
            throw new InvalidScimResourceException("trying to nest group within itself, aborting");
        }
        ScimGroup group = (ScimGroup)this.groupProvisioning.retrieve(groupId, IdentityZoneHolder.get().getId());
        String memberZoneId = member.getType() == ScimGroupMember.Type.GROUP ? ((ScimGroup)this.groupProvisioning.retrieve(member.getMemberId(), IdentityZoneHolder.get().getId())).getZoneId() : ((ScimUser)this.userProvisioning.retrieve(member.getMemberId(), IdentityZoneHolder.get().getId())).getZoneId();
        if (!memberZoneId.equals(group.getZoneId())) {
            throw new ScimResourceConstraintFailedException("The zone of the group and the member must be the same.");
        }
        if (!memberZoneId.equals(zoneId)) {
            throw new ScimResourceConstraintFailedException("Unable to make membership changes in a different zone");
        }
    }

    private String getGroupAuthorities(ScimGroupMember member) {
        if (member.getRoles() != null && !member.getRoles().isEmpty()) {
            return StringUtils.collectionToCommaDelimitedString((Collection)member.getRoles());
        }
        return StringUtils.collectionToCommaDelimitedString((Collection)ScimGroupMember.GROUP_MEMBER);
    }

    @Override
    public void deleteMembersByOrigin(String origin, String zoneId) throws ScimResourceNotFoundException {
        this.jdbcTemplate.update(DELETE_MEMBERS_WITH_ORIGIN_GROUP_SQL, new Object[]{origin, zoneId});
    }

    protected static final class ScimGroupMemberRowMapper
    implements RowMapper<ScimGroupMember> {
        protected ScimGroupMemberRowMapper() {
        }

        public ScimGroupMember mapRow(ResultSet rs, int rowNum) throws SQLException {
            String memberId = rs.getString(2);
            String memberType = rs.getString(3);
            String authorities = rs.getString(4);
            Date added = rs.getDate(5);
            String origin = rs.getString(6);
            ScimGroupMember sgm = new ScimGroupMember(memberId, ScimGroupMember.Type.valueOf((String)memberType), this.getAuthorities(authorities));
            sgm.setOrigin(origin);
            return sgm;
        }

        private List<ScimGroupMember.Role> getAuthorities(String authorities) {
            ArrayList<ScimGroupMember.Role> result = new ArrayList<ScimGroupMember.Role>();
            for (String a : authorities.split(",")) {
                if ("read".equalsIgnoreCase(a)) {
                    a = "reader";
                } else if ("write".equalsIgnoreCase(a)) {
                    a = "writer";
                }
                result.add(ScimGroupMember.Role.valueOf((String)a.toUpperCase()));
            }
            return result;
        }
    }
}

