/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.message;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class LocalUaaRestTemplate
extends OAuth2RestTemplate
implements InitializingBean {
    protected AuthorizationServerTokenServices tokenServices;
    protected String clientId;
    protected ClientServicesExtension clientDetailsService;
    protected boolean verifySsl = true;

    public LocalUaaRestTemplate(OAuth2ProtectedResourceDetails resource) {
        super(resource);
    }

    public LocalUaaRestTemplate(OAuth2ProtectedResourceDetails resource, OAuth2ClientContext context) {
        super(resource, context);
    }

    public OAuth2AccessToken acquireAccessToken(OAuth2ClientContext oauth2Context) throws UserRedirectRequiredException {
        ClientDetails client = this.clientDetailsService.loadClientByClientId(this.getClientId(), IdentityZoneHolder.get().getId());
        HashSet<String> scopes = new HashSet<String>();
        for (GrantedAuthority authority : client.getAuthorities()) {
            scopes.add(authority.getAuthority());
        }
        HashSet<String> resourceIds = new HashSet<String>();
        resourceIds.add("uaa");
        HashSet<String> responseTypes = new HashSet<String>();
        responseTypes.add("token");
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("client_id", "login");
        requestParameters.put("grant_type", "client_credentials");
        OAuth2Request request = new OAuth2Request(requestParameters, "login", (Collection)Collections.EMPTY_SET, true, scopes, resourceIds, null, responseTypes, Collections.EMPTY_MAP);
        OAuth2Authentication authentication = new OAuth2Authentication(request, null);
        OAuth2AccessToken result = this.tokenServices.createAccessToken(authentication);
        oauth2Context.setAccessToken(result);
        return result;
    }

    public AuthorizationServerTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public void setTokenServices(AuthorizationServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public void setClientDetailsService(ClientServicesExtension clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public boolean isVerifySsl() {
        return this.verifySsl;
    }

    public void setVerifySsl(boolean verifySsl) {
        this.verifySsl = verifySsl;
    }

    protected void skipSslValidation() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        CloseableHttpClient httpClient = HttpClients.custom().setSslcontext(sslContext).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        this.setRequestFactory((ClientHttpRequestFactory)requestFactory);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.tokenServices == null) {
            throw new NullPointerException("tokenServices property is null!");
        }
        if (this.clientId == null) {
            throw new NullPointerException("clientId property is null!");
        }
        if (this.clientDetailsService == null) {
            throw new NullPointerException("clientDetailsService property is null!");
        }
        if (!this.isVerifySsl()) {
            this.skipSslValidation();
        }
    }
}

