/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.cloudfoundry.identity.uaa.metrics.RequestMetric;
import org.cloudfoundry.identity.uaa.metrics.RequestMetricSummary;

public class MetricsQueue {
    public static final int MAX_ENTRIES = 1000;
    public static final int MAX_TIME = 3000;
    ConcurrentLinkedDeque<RequestMetric> queue = new ConcurrentLinkedDeque();
    AtomicInteger size = new AtomicInteger(0);
    Map<Integer, RequestMetricSummary> statistics = new ConcurrentHashMap<Integer, RequestMetricSummary>();

    public boolean offer(RequestMetric metric) {
        if (this.queue.offer(metric)) {
            this.size.incrementAndGet();
        }
        while (this.size.decrementAndGet() >= 1000) {
            this.queue.removeLast();
        }
        Integer statusCode = metric.getStatusCode();
        if (!this.statistics.containsKey(statusCode)) {
            this.statistics.putIfAbsent(statusCode, new RequestMetricSummary());
        }
        RequestMetricSummary totals = this.statistics.get(statusCode);
        totals.add(metric.getRequestCompleteTime() - metric.getRequestStartTime(), metric.getNrOfDatabaseQueries(), metric.getDatabaseQueryTime(), metric.getQueries().stream().filter(q -> !q.isSuccess()).count(), metric.getQueries().stream().filter(q -> !q.isSuccess()).mapToLong(q -> q.getRequestCompleteTime() - q.getRequestStartTime()).sum());
        return true;
    }

    public Map<Integer, RequestMetricSummary> getSummary() {
        return this.statistics;
    }
}

