/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.metrics;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.concurrent.atomic.AtomicLong;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RequestMetricSummary {
    AtomicLong count = new AtomicLong(0L);
    AtomicLong totalTime = new AtomicLong(0L);
    AtomicLong intolerableCount = new AtomicLong(0L);
    AtomicLong intolerableTime = new AtomicLong(0L);
    AtomicLong databaseQueryCount = new AtomicLong(0L);
    AtomicLong databaseQueryTime = new AtomicLong(0L);
    AtomicLong databaseFailedQueryCount = new AtomicLong(0L);
    AtomicLong databaseFailedQueryTime = new AtomicLong(0L);

    public void add(long time, long dbQueries, long dbTime, long failedDbQueries, long failedDbQueryTime) {
        this.count.incrementAndGet();
        this.totalTime.addAndGet(time);
        if (time > 3000L) {
            this.intolerableCount.incrementAndGet();
            this.intolerableTime.addAndGet(time);
        }
        this.databaseQueryCount.addAndGet(dbQueries);
        this.databaseQueryTime.addAndGet(dbTime);
        this.databaseFailedQueryCount.addAndGet(failedDbQueries);
        this.databaseFailedQueryTime.addAndGet(failedDbQueryTime);
    }

    public long getCount() {
        return this.count.get();
    }

    public long getTotalTime() {
        return this.totalTime.get();
    }

    public long getIntolerableCount() {
        return this.intolerableCount.get();
    }

    public long getIntolerableTime() {
        return this.intolerableTime.get();
    }

    public long getDatabaseQueryCount() {
        return this.databaseQueryCount.get();
    }

    public long getDatabaseQueryTime() {
        return this.databaseQueryTime.get();
    }

    public long getDatabaseFailedQueryCount() {
        return this.databaseFailedQueryCount.get();
    }

    public long getDatabaseFailedQueryTime() {
        return this.databaseFailedQueryTime.get();
    }
}

