/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.metrics.IdleTimer;
import org.cloudfoundry.identity.uaa.metrics.MetricsAccessor;
import org.cloudfoundry.identity.uaa.metrics.MetricsQueue;
import org.cloudfoundry.identity.uaa.metrics.RequestMetric;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.TimeServiceImpl;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@ManagedResource(objectName="cloudfoundry.identity:name=ServerRequests", description="UAA Performance Metrics")
public class UaaMetricsFilter
extends OncePerRequestFilter {
    private TimeService timeService = new TimeServiceImpl();
    private IdleTimer inflight = new IdleTimer();
    Map<String, MetricsQueue> perUriMetrics = new ConcurrentHashMap<String, MetricsQueue>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String uriGroup = this.getUriGroup(request);
        if (StringUtils.hasText((String)uriGroup)) {
            RequestMetric metric = RequestMetric.start(request.getRequestURI(), this.timeService.getCurrentTimeMillis());
            try {
                MetricsAccessor.setCurrent(metric);
                this.inflight.startRequest();
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                MetricsAccessor.clear();
                this.inflight.endRequest();
                metric.stop(response.getStatus(), this.timeService.getCurrentTimeMillis());
                MetricsQueue queue = this.getMetricsQueue(uriGroup);
                queue.offer(metric);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected MetricsQueue getMetricsQueue(String uri) {
        if (!this.perUriMetrics.containsKey(uri)) {
            this.perUriMetrics.putIfAbsent(uri, new MetricsQueue());
        }
        return this.perUriMetrics.get(uri);
    }

    protected String getUriGroup(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (StringUtils.hasText((String)contextPath) && uri != null && uri.startsWith(contextPath)) {
            uri = uri.substring(contextPath.length());
        }
        for (String urlGroup : Arrays.asList("/oauth/token/list", "/oauth/token/revoke", "/oauth/token", "/oauth/authorize", "/approvals", "/Users", "/oauth/clients/tx", "/oauth/clients", "/Codes", "/login/callback", "/identity-providers", "/saml/service-providers", "/Groups/external", "/Groups/zones", "/Groups", "/identity-zones", "/saml/login")) {
            if (!uri.startsWith(urlGroup)) continue;
            return urlGroup;
        }
        if (uri != null && (uri.startsWith("/resources/") || uri.startsWith("/vendor/"))) {
            return "/static-content";
        }
        return uri;
    }

    @ManagedMetric(category="performance", displayName="Inflight Requests")
    public int getInflightRequests() {
        return this.inflight.getInflightRequests();
    }

    @ManagedMetric(category="performance", displayName="Idle time (ms)")
    public long getIdleTime() {
        return this.inflight.getIdleTime();
    }

    @ManagedMetric(category="performance", displayName="Processing request time (ms)")
    public long getProcessingTime() {
        return this.inflight.getRunTime() - this.inflight.getIdleTime();
    }

    @ManagedMetric(category="performance", displayName="Total server run time (ms)")
    public long getRunTime() {
        return this.inflight.getRunTime();
    }

    @ManagedMetric(category="performance", displayName="Number of completed requests")
    public long getCompletedRequests() {
        return this.inflight.getRequestCount();
    }

    @ManagedMetric(category="performance", displayName="Server Request Summary")
    public Map<String, String> getSummary() {
        HashMap<String, String> data = new HashMap<String, String>();
        this.perUriMetrics.entrySet().stream().forEach(entry -> data.put((String)entry.getKey(), JsonUtils.writeValueAsString(((MetricsQueue)entry.getValue()).getSummary())));
        return data;
    }

    public TimeService getTimeService() {
        return this.timeService;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }
}

