/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.oauth2.common.util.SerializationUtils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;

public class UaaTokenStore
implements AuthorizationCodeServices {
    public static final long EXPIRATION_TIME = 300000L;
    public static final long LEGACY_CODE_EXPIRATION_TIME = 259200000L;
    public static final String USER_AUTHENTICATION_UAA_AUTHENTICATION = "userAuthentication.uaaAuthentication";
    public static final String USER_AUTHENTICATION_UAA_PRINCIPAL = "userAuthentication.uaaPrincipal";
    public static final String USER_AUTHENTICATION_AUTHORITIES = "userAuthentication.authorities";
    public static final String OAUTH2_REQUEST_PARAMETERS = "oauth2Request.requestParameters";
    public static final String OAUTH2_REQUEST_CLIENT_ID = "oauth2Request.clientId";
    public static final String OAUTH2_REQUEST_AUTHORITIES = "oauth2Request.authorities";
    public static final String OAUTH2_REQUEST_APPROVED = "oauth2Request.approved";
    public static final String OAUTH2_REQUEST_SCOPE = "oauth2Request.scope";
    public static final String OAUTH2_REQUEST_RESOURCE_IDS = "oauth2Request.resourceIds";
    public static final String OAUTH2_REQUEST_REDIRECT_URI = "oauth2Request.redirectUri";
    public static final String OAUTH2_REQUEST_RESPONSE_TYPES = "oauth2Request.responseTypes";
    protected static Log logger = LogFactory.getLog(UaaTokenStore.class);
    private static final String SQL_SELECT_STATEMENT = "select code, user_id, client_id, expiresat, created, authentication from oauth_code where code = ?";
    private static final String SQL_INSERT_STATEMENT = "insert into oauth_code (code, user_id, client_id, expiresat, authentication, identity_zone_id) values (?, ?, ?, ?, ?, ?)";
    private static final String SQL_DELETE_STATEMENT = "delete from oauth_code where code = ?";
    private static final String SQL_EXPIRE_STATEMENT = "delete from oauth_code where expiresat > 0 AND expiresat < ?";
    private static final String SQL_CLEAN_STATEMENT = "delete from oauth_code where created < ? and expiresat = 0";
    private final DataSource dataSource;
    private final long expirationTime;
    private final RandomValueStringGenerator generator = new RandomValueStringGenerator(10);
    private final RowMapper rowMapper = new TokenCodeRowMapper();
    private final AtomicLong lastClean = new AtomicLong(0L);

    public UaaTokenStore(DataSource dataSource) {
        this(dataSource, 300000L);
    }

    public UaaTokenStore(DataSource dataSource, long expirationTime) {
        this.dataSource = dataSource;
        this.expirationTime = expirationTime;
    }

    public String createAuthorizationCode(OAuth2Authentication authentication) {
        int max_tries = 3;
        this.performExpirationClean();
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        int tries = 0;
        while (tries++ <= 3) {
            try {
                String code = this.generator.generate();
                long expiresAt = System.currentTimeMillis() + this.getExpirationTime();
                String userId = authentication.getUserAuthentication() == null ? null : ((UaaPrincipal)authentication.getUserAuthentication().getPrincipal()).getId();
                String clientId = authentication.getOAuth2Request().getClientId();
                SqlLobValue data = new SqlLobValue(this.serializeOauth2Authentication(authentication));
                int updated = template.update(SQL_INSERT_STATEMENT, new Object[]{code, userId, clientId, expiresAt, data, IdentityZoneHolder.get().getId()}, new int[]{12, 12, 12, 2, 2004, 12});
                if (updated == 0) {
                    throw new DataIntegrityViolationException("[oauth_code] Failed to insert code. Result was 0");
                }
                return code;
            }
            catch (DataIntegrityViolationException exists) {
                if (tries < 3) continue;
                throw exists;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OAuth2Authentication consumeAuthorizationCode(String code) throws InvalidGrantException {
        this.performExpirationClean();
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        try {
            TokenCode tokenCode;
            block6: {
                OAuth2Authentication oAuth2Authentication;
                tokenCode = (TokenCode)template.queryForObject(SQL_SELECT_STATEMENT, this.rowMapper, new Object[]{code});
                if (tokenCode == null) throw new InvalidGrantException("Invalid authorization code: " + code);
                try {
                    if (tokenCode.isExpired()) {
                        logger.debug((Object)("[oauth_code] Found code, but it expired:" + tokenCode));
                        throw new InvalidGrantException("Authorization code expired: " + code);
                    }
                    if (tokenCode.getExpiresAt() != 0L) break block6;
                    oAuth2Authentication = (OAuth2Authentication)SerializationUtils.deserialize((byte[])tokenCode.getAuthentication());
                }
                catch (Throwable throwable) {
                    template.update(SQL_DELETE_STATEMENT, new Object[]{code});
                    throw throwable;
                }
                template.update(SQL_DELETE_STATEMENT, new Object[]{code});
                return oAuth2Authentication;
            }
            OAuth2Authentication oAuth2Authentication = this.deserializeOauth2Authentication(tokenCode.getAuthentication());
            template.update(SQL_DELETE_STATEMENT, new Object[]{code});
            return oAuth2Authentication;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        throw new InvalidGrantException("Invalid authorization code: " + code);
    }

    protected byte[] serializeOauth2Authentication(OAuth2Authentication auth2Authentication) {
        Authentication userAuthentication = auth2Authentication.getUserAuthentication();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (userAuthentication != null) {
            if (userAuthentication instanceof UaaAuthentication) {
                data.put(USER_AUTHENTICATION_UAA_AUTHENTICATION, JsonUtils.writeValueAsString((Object)userAuthentication));
            } else {
                data.put(USER_AUTHENTICATION_UAA_PRINCIPAL, JsonUtils.writeValueAsString((Object)userAuthentication.getPrincipal()));
                data.put(USER_AUTHENTICATION_AUTHORITIES, UaaStringUtils.getStringsFromAuthorities((Collection)userAuthentication.getAuthorities()));
            }
        }
        data.put(OAUTH2_REQUEST_PARAMETERS, auth2Authentication.getOAuth2Request().getRequestParameters());
        data.put(OAUTH2_REQUEST_CLIENT_ID, auth2Authentication.getOAuth2Request().getClientId());
        data.put(OAUTH2_REQUEST_AUTHORITIES, UaaStringUtils.getStringsFromAuthorities((Collection)auth2Authentication.getOAuth2Request().getAuthorities()));
        data.put(OAUTH2_REQUEST_APPROVED, auth2Authentication.getOAuth2Request().isApproved());
        data.put(OAUTH2_REQUEST_SCOPE, auth2Authentication.getOAuth2Request().getScope());
        data.put(OAUTH2_REQUEST_RESOURCE_IDS, auth2Authentication.getOAuth2Request().getResourceIds());
        data.put(OAUTH2_REQUEST_REDIRECT_URI, auth2Authentication.getOAuth2Request().getRedirectUri());
        data.put(OAUTH2_REQUEST_RESPONSE_TYPES, auth2Authentication.getOAuth2Request().getResponseTypes());
        if (auth2Authentication.getOAuth2Request().getExtensions() != null && auth2Authentication.getOAuth2Request().getExtensions().size() > 0) {
            logger.warn((Object)("[oauth_code] Unable to serialize extensions:" + auth2Authentication.getOAuth2Request().getExtensions()));
        }
        return JsonUtils.writeValueAsBytes(data);
    }

    protected OAuth2Authentication deserializeOauth2Authentication(byte[] data) {
        Map map = (Map)JsonUtils.readValue((byte[])data, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Authentication userAuthentication = null;
        if (map.get(USER_AUTHENTICATION_UAA_AUTHENTICATION) != null) {
            userAuthentication = (Authentication)JsonUtils.readValue((String)((String)map.get(USER_AUTHENTICATION_UAA_AUTHENTICATION)), UaaAuthentication.class);
        } else if (map.get(USER_AUTHENTICATION_UAA_PRINCIPAL) != null) {
            UaaPrincipal principal = (UaaPrincipal)JsonUtils.readValue((String)((String)map.get(USER_AUTHENTICATION_UAA_PRINCIPAL)), UaaPrincipal.class);
            List authorities = UaaStringUtils.getAuthoritiesFromStrings((Collection)((Collection)map.get(USER_AUTHENTICATION_AUTHORITIES)));
            userAuthentication = new UaaAuthentication(principal, authorities, UaaAuthenticationDetails.UNKNOWN);
        }
        Map requestParameters = (Map)map.get(OAUTH2_REQUEST_PARAMETERS);
        String clientId = (String)map.get(OAUTH2_REQUEST_CLIENT_ID);
        List authorities = UaaStringUtils.getAuthoritiesFromStrings((Collection)((Collection)map.get(OAUTH2_REQUEST_AUTHORITIES)));
        boolean approved = (Boolean)map.get(OAUTH2_REQUEST_APPROVED);
        Collection scope = (Collection)map.get(OAUTH2_REQUEST_SCOPE);
        Collection resourceIds = (Collection)map.get(OAUTH2_REQUEST_RESOURCE_IDS);
        String redirectUri = (String)map.get(OAUTH2_REQUEST_REDIRECT_URI);
        Collection responseTypes = (Collection)map.get(OAUTH2_REQUEST_RESPONSE_TYPES);
        OAuth2Request request = new OAuth2Request(requestParameters, clientId, (Collection)authorities, approved, new HashSet(scope), new HashSet(resourceIds), redirectUri, new HashSet(responseTypes), new HashMap());
        return new OAuth2Authentication(request, userAuthentication);
    }

    protected void performExpirationClean() {
        long last = this.lastClean.get();
        if (System.currentTimeMillis() - last > this.getExpirationTime() && this.lastClean.compareAndSet(last, last + this.getExpirationTime())) {
            JdbcTemplate template = new JdbcTemplate(this.dataSource);
            int expired = template.update(SQL_EXPIRE_STATEMENT, new Object[]{System.currentTimeMillis()});
            logger.debug((Object)("[oauth_code] Removed " + expired + " expired entries."));
            expired = template.update(SQL_CLEAN_STATEMENT, new Object[]{new Timestamp(System.currentTimeMillis() - 259200000L)});
            logger.debug((Object)("[oauth_code] Removed " + expired + " old entries."));
        }
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public TokenCode createTokenCode(String code, String userId, String clientId, long expiresAt, Timestamp created, byte[] authentication) {
        return new TokenCode(code, userId, clientId, expiresAt, created, authentication);
    }

    protected class TokenCode {
        private final String code;
        private final String userId;
        private final String clientId;
        private final long expiresAt;
        private final Timestamp created;
        private final byte[] authentication;

        public TokenCode(String code, String userId, String clientId, long expiresAt, Timestamp created, byte[] authentication) {
            this.code = code;
            this.userId = userId;
            this.clientId = clientId;
            this.expiresAt = expiresAt;
            this.created = created;
            this.authentication = authentication;
        }

        public byte[] getAuthentication() {
            return this.authentication;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getCode() {
            return this.code;
        }

        public Timestamp getCreated() {
            return this.created;
        }

        public long getExpiresAt() {
            return this.expiresAt;
        }

        public String getUserId() {
            return this.userId;
        }

        public boolean isExpired() {
            if (this.getExpiresAt() == 0L) {
                return new Timestamp(System.currentTimeMillis() - UaaTokenStore.this.getExpirationTime()).after(this.getCreated());
            }
            return this.getExpiresAt() < System.currentTimeMillis();
        }

        public String toString() {
            return "TokenCode{, code='" + this.code + '\'' + ", userId='" + this.userId + '\'' + ", clientId='" + this.clientId + '\'' + ", expiresAt=" + this.expiresAt + ", created=" + this.created + '}';
        }
    }

    protected class TokenCodeRowMapper
    implements RowMapper<TokenCode> {
        protected TokenCodeRowMapper() {
        }

        public TokenCode mapRow(ResultSet rs, int rowNum) throws SQLException {
            int pos = 1;
            String code = rs.getString(pos++);
            String userid = rs.getString(pos++);
            String client_id = rs.getString(pos++);
            long expiresat = rs.getLong(pos++);
            Timestamp created = rs.getTimestamp(pos++);
            byte[] authentication = rs.getBytes(pos++);
            return UaaTokenStore.this.createTokenCode(code, userid, client_id, expiresat, created, authentication);
        }
    }
}

