/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.endpoints;

import com.jayway.jsonpath.JsonPathException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.resources.SearchResults;
import org.cloudfoundry.identity.uaa.resources.SearchResultsFactory;
import org.cloudfoundry.identity.uaa.resources.SimpleAttributeNameMapper;
import org.cloudfoundry.identity.uaa.resources.jdbc.SimpleSearchQueryConverter;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidScimResourceException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.scim.jdbc.JdbcScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.security.DefaultSecurityContextAccessor;
import org.cloudfoundry.identity.uaa.security.SecurityContextAccessor;
import org.cloudfoundry.identity.uaa.util.UaaPagingUtils;
import org.cloudfoundry.identity.uaa.web.ConvertingExceptionView;
import org.cloudfoundry.identity.uaa.web.ExceptionReport;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;

@Controller
public class ScimGroupEndpoints {
    public static final String E_TAG = "ETag";
    private final ScimGroupProvisioning dao;
    private ScimGroupMembershipManager membershipManager;
    private JdbcScimGroupExternalMembershipManager externalMembershipManager;
    private Map<Class<? extends Exception>, HttpStatus> statuses = new HashMap<Class<? extends Exception>, HttpStatus>();
    private HttpMessageConverter<?>[] messageConverters = new RestTemplate().getMessageConverters().toArray(new HttpMessageConverter[0]);
    private final Log logger = LogFactory.getLog(this.getClass());
    private SecurityContextAccessor securityContextAccessor = new DefaultSecurityContextAccessor();

    public void setSecurityContextAccessor(SecurityContextAccessor securityContextAccessor) {
        this.securityContextAccessor = securityContextAccessor;
    }

    public void setStatuses(Map<Class<? extends Exception>, HttpStatus> statuses) {
        this.statuses = statuses;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    public JdbcScimGroupExternalMembershipManager getExternalMembershipManager() {
        return this.externalMembershipManager;
    }

    public void setExternalMembershipManager(JdbcScimGroupExternalMembershipManager externalMembershipManager) {
        this.externalMembershipManager = externalMembershipManager;
    }

    public ScimGroupEndpoints(ScimGroupProvisioning scimGroupProvisioning, ScimGroupMembershipManager membershipManager) {
        this.dao = scimGroupProvisioning;
        this.membershipManager = membershipManager;
    }

    private boolean isMember(ScimGroup group, String userId) {
        if (null == userId) {
            return true;
        }
        for (ScimGroupMember member : group.getMembers()) {
            if (!member.getMemberId().equals(userId)) continue;
            return true;
        }
        return false;
    }

    private List<ScimGroup> filterForCurrentUser(List<ScimGroup> input, int startIndex, int count) {
        boolean needMore;
        ArrayList<ScimGroup> response = new ArrayList<ScimGroup>();
        int expectedResponseSize = Math.min(count, input.size());
        boolean bl = needMore = response.size() < expectedResponseSize;
        while (needMore && startIndex <= input.size()) {
            for (ScimGroup group : UaaPagingUtils.subList(input, startIndex, count)) {
                group.setMembers(this.membershipManager.getMembers(group.getId(), false, IdentityZoneHolder.get().getId()));
                response.add(group);
                needMore = response.size() < expectedResponseSize;
                if (needMore) continue;
                break;
            }
            startIndex += count;
        }
        return response;
    }

    @RequestMapping(value={"/Groups"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResults<?> listGroups(@RequestParam(value="attributes", required=false) String attributesCommaSeparated, @RequestParam(required=false, defaultValue="id pr") String filter, @RequestParam(required=false, defaultValue="created") String sortBy, @RequestParam(required=false, defaultValue="ascending") String sortOrder, @RequestParam(required=false, defaultValue="1") int startIndex, @RequestParam(required=false, defaultValue="100") int count) {
        List<ScimGroup> result;
        try {
            result = this.dao.query(filter, sortBy, "ascending".equalsIgnoreCase(sortOrder), IdentityZoneHolder.get().getId());
        }
        catch (IllegalArgumentException e) {
            throw new ScimException("Invalid filter expression: [" + filter + "]", HttpStatus.BAD_REQUEST);
        }
        List<ScimGroup> input = this.filterForCurrentUser(result, startIndex, count);
        if (!StringUtils.hasLength((String)attributesCommaSeparated)) {
            return new SearchResults(Arrays.asList(ScimCore.SCHEMAS), input, startIndex, count, result.size());
        }
        SimpleAttributeNameMapper mapper = new SimpleAttributeNameMapper(Collections.emptyMap());
        String[] attributes = attributesCommaSeparated.split(",");
        try {
            return SearchResultsFactory.buildSearchResultFrom(input, startIndex, count, result.size(), attributes, mapper, Arrays.asList(ScimCore.SCHEMAS));
        }
        catch (JsonPathException e) {
            throw new ScimException("Invalid attributes: [" + attributesCommaSeparated + "]", HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/Groups/External/list"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated
    public SearchResults<?> listExternalGroups(@RequestParam(required=false, defaultValue="1") int startIndex, @RequestParam(required=false, defaultValue="100") int count, @RequestParam(required=false, defaultValue="") String filter) {
        return this.getExternalGroups(startIndex, count, filter, "", "");
    }

    @RequestMapping(value={"/Groups/External"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResults<?> getExternalGroups(@RequestParam(required=false, defaultValue="1") int startIndex, @RequestParam(required=false, defaultValue="100") int count, @RequestParam(required=false, defaultValue="") String filter, @RequestParam(required=false, defaultValue="") String origin, @RequestParam(required=false, defaultValue="") String externalGroup) {
        ArrayList<ScimGroupExternalMember> result;
        if (StringUtils.hasText((String)filter)) {
            if (StringUtils.hasText((String)origin) || StringUtils.hasText((String)externalGroup)) {
                throw new ScimException("Deprecated filter parameter may not be used in conjunction with origin or externalGroup parameters", HttpStatus.BAD_REQUEST);
            }
            SimpleSearchQueryConverter converter = new SimpleSearchQueryConverter();
            try {
                MultiValueMap<String, Object> filterData = converter.getFilterValues(filter, Arrays.asList("origin", "externalgroup"));
                origin = Optional.ofNullable(filterData.getFirst((Object)"origin")).orElse(origin).toString();
                externalGroup = Optional.ofNullable(filterData.getFirst((Object)"externalGroup")).orElse(externalGroup).toString();
            }
            catch (IllegalArgumentException e) {
                throw new ScimException("Filter not supported, please use origin and externalGroup parameters", e, HttpStatus.BAD_REQUEST);
            }
        }
        try {
            result = new ArrayList<ScimGroupExternalMember>(this.externalMembershipManager.getExternalGroupMappings(IdentityZoneHolder.get().getId()));
        }
        catch (IllegalArgumentException e) {
            throw new ScimException("Invalid filter expression: [" + filter + "]", e, HttpStatus.BAD_REQUEST);
        }
        String filterOrigin = origin;
        String filterGroup = externalGroup;
        result.removeIf(em -> StringUtils.hasText((String)filterOrigin) && !em.getOrigin().equals(filterOrigin));
        result.removeIf(em -> StringUtils.hasText((String)filterGroup) && !em.getExternalGroup().equals(filterGroup));
        return SearchResultsFactory.cropAndBuildSearchResultFrom(result, startIndex, count, result.size(), new String[]{"groupId", "displayName", "externalGroup", "origin"}, Arrays.asList(ScimCore.SCHEMAS));
    }

    @RequestMapping(value={"/Groups/External"}, method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public ScimGroupExternalMember mapExternalGroup(@RequestBody ScimGroupExternalMember sgm) {
        try {
            String displayName = sgm.getDisplayName();
            String groupId = StringUtils.hasText((String)sgm.getGroupId()) ? sgm.getGroupId() : this.getGroupId(displayName);
            String externalGroup = StringUtils.hasText((String)sgm.getExternalGroup()) ? sgm.getExternalGroup().trim() : sgm.getExternalGroup();
            String origin = StringUtils.hasText((String)sgm.getOrigin()) ? sgm.getOrigin() : "ldap";
            return this.externalMembershipManager.mapExternalGroup(groupId, externalGroup, origin, IdentityZoneHolder.get().getId());
        }
        catch (IllegalArgumentException e) {
            throw new ScimException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (ScimResourceNotFoundException e) {
            throw new ScimException(e.getMessage(), HttpStatus.NOT_FOUND);
        }
        catch (MemberAlreadyExistsException e) {
            throw new ScimException(e.getMessage(), HttpStatus.CONFLICT);
        }
    }

    @RequestMapping(value={"/Groups/External/groupId/{groupId}/externalGroup/{externalGroup}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @Deprecated
    public ScimGroupExternalMember deprecated2UnmapExternalGroup(@PathVariable String groupId, @PathVariable String externalGroup) {
        return this.unmapExternalGroup(groupId, externalGroup, null);
    }

    @RequestMapping(value={"/Groups/External/groupId/{groupId}/externalGroup/{externalGroup}/origin/{origin}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ScimGroupExternalMember unmapExternalGroup(@PathVariable String groupId, @PathVariable String externalGroup, @PathVariable String origin) {
        try {
            if (!StringUtils.hasText((String)origin)) {
                origin = "ldap";
            }
            return this.externalMembershipManager.unmapExternalGroup(groupId, externalGroup.trim(), origin, IdentityZoneHolder.get().getId());
        }
        catch (IllegalArgumentException e) {
            throw new ScimException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (ScimResourceNotFoundException e) {
            throw new ScimException(e.getMessage(), HttpStatus.NOT_FOUND);
        }
        catch (MemberAlreadyExistsException e) {
            throw new ScimException(e.getMessage(), HttpStatus.CONFLICT);
        }
    }

    @RequestMapping(value={"/Groups/External/id/{groupId}/{externalGroup}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @Deprecated
    public ScimGroupExternalMember deprecatedUnmapExternalGroup(@PathVariable String groupId, @PathVariable String externalGroup) {
        return this.unmapExternalGroup(groupId, externalGroup, "ldap");
    }

    @RequestMapping(value={"/Groups/External/displayName/{displayName}/externalGroup/{externalGroup}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @Deprecated
    public ScimGroupExternalMember unmapExternalGroupUsingName(@PathVariable String displayName, @PathVariable String externalGroup) {
        return this.unmapExternalGroupUsingName(displayName, externalGroup, "ldap");
    }

    @RequestMapping(value={"/Groups/External/displayName/{displayName}/externalGroup/{externalGroup}/origin/{origin}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ScimGroupExternalMember unmapExternalGroupUsingName(@PathVariable String displayName, @PathVariable String externalGroup, @PathVariable String origin) {
        try {
            if (!StringUtils.hasText((String)origin)) {
                origin = "ldap";
            }
            return this.externalMembershipManager.unmapExternalGroup(this.getGroupId(displayName), externalGroup.trim(), origin, IdentityZoneHolder.get().getId());
        }
        catch (IllegalArgumentException e) {
            throw new ScimException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (ScimResourceNotFoundException e) {
            throw new ScimException(e.getMessage(), HttpStatus.NOT_FOUND);
        }
        catch (MemberAlreadyExistsException e) {
            throw new ScimException(e.getMessage(), HttpStatus.CONFLICT);
        }
    }

    @RequestMapping(value={"/Groups/External/{displayName}/{externalGroup}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @Deprecated
    public ScimGroupExternalMember deprecatedUnmapExternalGroupUsingName(@PathVariable String displayName, @PathVariable String externalGroup) {
        return this.unmapExternalGroupUsingName(displayName, externalGroup);
    }

    private String getGroupId(String displayName) {
        if (displayName == null || displayName.trim().length() == 0) {
            throw new ScimException("Group not found, not name provided", HttpStatus.NOT_FOUND);
        }
        List result = this.dao.query("displayName eq \"" + displayName + "\"", IdentityZoneHolder.get().getId());
        if (result == null || result.size() == 0) {
            throw new ScimException("Group not found:" + displayName, HttpStatus.NOT_FOUND);
        }
        return ((ScimGroup)result.get(0)).getId();
    }

    @RequestMapping(value={"/Groups/{groupId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ScimGroup getGroup(@PathVariable String groupId, HttpServletResponse httpServletResponse) {
        this.logger.debug((Object)("retrieving group with id: " + groupId));
        ScimGroup group = (ScimGroup)this.dao.retrieve(groupId, IdentityZoneHolder.get().getId());
        group.setMembers(this.membershipManager.getMembers(groupId, false, IdentityZoneHolder.get().getId()));
        this.addETagHeader(httpServletResponse, group);
        return group;
    }

    @RequestMapping(value={"/Groups"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ScimGroup createGroup(@RequestBody ScimGroup group, HttpServletResponse httpServletResponse) {
        group.setZoneId(IdentityZoneHolder.get().getId());
        ScimGroup created = this.dao.create(group, IdentityZoneHolder.get().getId());
        if (group.getMembers() != null) {
            for (ScimGroupMember member : group.getMembers()) {
                try {
                    this.membershipManager.addMember(created.getId(), member, IdentityZoneHolder.get().getId());
                }
                catch (ScimException ex) {
                    this.logger.warn((Object)("Attempt to add invalid member: " + member.getMemberId() + " to group: " + created.getId()), (Throwable)ex);
                    this.dao.delete(created.getId(), created.getVersion(), IdentityZoneHolder.get().getId());
                    throw new InvalidScimResourceException("Invalid group member: " + member.getMemberId());
                }
            }
        }
        created.setMembers(this.membershipManager.getMembers(created.getId(), false, IdentityZoneHolder.get().getId()));
        this.addETagHeader(httpServletResponse, created);
        return created;
    }

    @RequestMapping(value={"/Groups/{groupId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ScimGroup updateGroup(@RequestBody ScimGroup group, @PathVariable String groupId, @RequestHeader(value="If-Match", required=false) String etag, HttpServletResponse httpServletResponse) {
        if (etag == null) {
            throw new ScimException("Missing If-Match for PUT", HttpStatus.BAD_REQUEST);
        }
        this.logger.debug((Object)("updating group: " + groupId));
        int version = this.getVersion(groupId, etag);
        group.setVersion(version);
        ScimGroup existing = this.getGroup(groupId, httpServletResponse);
        try {
            group.setZoneId(IdentityZoneHolder.get().getId());
            ScimGroup updated = this.dao.update(groupId, group, IdentityZoneHolder.get().getId());
            if (group.getMembers() != null && group.getMembers().size() > 0) {
                this.membershipManager.updateOrAddMembers(updated.getId(), group.getMembers(), IdentityZoneHolder.get().getId());
            } else {
                this.membershipManager.removeMembersByGroupId(updated.getId(), IdentityZoneHolder.get().getId());
            }
            updated.setMembers(this.membershipManager.getMembers(updated.getId(), false, IdentityZoneHolder.get().getId()));
            this.addETagHeader(httpServletResponse, updated);
            return updated;
        }
        catch (IncorrectResultSizeDataAccessException ex) {
            this.logger.error((Object)"Error updating group, restoring to previous state");
            existing.setVersion(this.getVersion(groupId, "*"));
            this.dao.update(groupId, existing, IdentityZoneHolder.get().getId());
            throw new ScimException(ex.getMessage(), ex, HttpStatus.CONFLICT);
        }
        catch (ScimResourceNotFoundException ex) {
            this.logger.error((Object)("Error updating group, restoring to previous state: " + existing));
            existing.setVersion(this.getVersion(groupId, "*"));
            this.dao.update(groupId, existing, IdentityZoneHolder.get().getId());
            throw new ScimException(ex.getMessage(), ex, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/Groups/{groupId}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public ScimGroup patchGroup(@RequestBody ScimGroup patch, @PathVariable String groupId, @RequestHeader(value="If-Match", required=false) String etag, HttpServletResponse httpServletResponse) {
        if (etag == null) {
            throw new ScimException("Missing If-Match for PATCH", HttpStatus.BAD_REQUEST);
        }
        this.logger.debug((Object)("patching group: " + groupId));
        int version = this.getVersion(groupId, etag);
        patch.setVersion(version);
        ScimGroup current = this.getGroup(groupId, httpServletResponse);
        current.patch(patch);
        return this.updateGroup(current, groupId, etag, httpServletResponse);
    }

    @RequestMapping(value={"/Groups/{groupId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ScimGroup deleteGroup(@PathVariable String groupId, @RequestHeader(value="If-Match", required=false, defaultValue="*") String etag, HttpServletResponse httpServletResponse) {
        ScimGroup group = this.getGroup(groupId, httpServletResponse);
        this.logger.debug((Object)("deleting group: " + group));
        try {
            this.membershipManager.removeMembersByGroupId(groupId, IdentityZoneHolder.get().getId());
            this.membershipManager.removeMembersByMemberId(groupId, IdentityZoneHolder.get().getId());
            this.dao.delete(groupId, this.getVersion(groupId, etag), IdentityZoneHolder.get().getId());
        }
        catch (IncorrectResultSizeDataAccessException ex) {
            this.logger.debug((Object)"error deleting group", (Throwable)ex);
            throw new ScimException("error deleting group: " + groupId, ex, HttpStatus.CONFLICT);
        }
        return group;
    }

    @RequestMapping(value={"/Groups/zones"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    @Deprecated
    public ScimGroup addZoneManagers(@RequestBody ScimGroup group, HttpServletResponse httpServletResponse) {
        if (!group.getDisplayName().matches("^zones\\.[^\\.]+\\.(admin|read|clients.(admin|read|write)|scim.(create|read|write)|idps.read)$")) {
            throw new ScimException("Invalid group name.", HttpStatus.BAD_REQUEST);
        }
        if (group.getMembers() == null || group.getMembers().size() == 0) {
            throw new ScimException("Invalid group members, you have to add at least one member.", HttpStatus.BAD_REQUEST);
        }
        try {
            ScimGroup existing = this.getGroup(this.getGroupId(group.getDisplayName()), httpServletResponse);
            LinkedList<ScimGroupMember> newMembers = new LinkedList<ScimGroupMember>(existing.getMembers());
            for (ScimGroupMember member : group.getMembers()) {
                if (this.isMember(existing, member.getMemberId())) continue;
                newMembers.add(member);
            }
            existing.setMembers(newMembers);
            return this.updateGroup(existing, existing.getId(), String.valueOf(existing.getVersion()), httpServletResponse);
        }
        catch (ScimException ex) {
            if (ex.getStatus().equals((Object)HttpStatus.NOT_FOUND)) {
                return this.createGroup(group, httpServletResponse);
            }
            throw ex;
        }
    }

    @RequestMapping(value={"/Groups/zones/{userId}/{zoneId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @Deprecated
    public ScimGroup deleteZoneAdmin(@PathVariable String userId, @PathVariable String zoneId, HttpServletResponse httpServletResponse) {
        return this.deleteZoneScope(userId, zoneId, "admin", httpServletResponse);
    }

    @RequestMapping(value={"/Groups/zones/{userId}/{zoneId}/{scope}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @Deprecated
    public ScimGroup deleteZoneScope(@PathVariable String userId, @PathVariable String zoneId, @PathVariable String scope, HttpServletResponse httpServletResponse) {
        String groupName = "zones." + zoneId + "." + scope;
        if (!groupName.matches("^zones\\.[^\\.]+\\.(admin|read|clients.(admin|read|write)|scim.(create|read|write)|idps.read)$")) {
            throw new ScimException("Invalid group name.", HttpStatus.BAD_REQUEST);
        }
        String groupId = this.getGroupId(groupName);
        ScimGroup group = this.getGroup(groupId, httpServletResponse);
        if (!StringUtils.hasText((String)userId) || !StringUtils.hasText((String)zoneId)) {
            throw new ScimException("User ID and Zone ID are required.", HttpStatus.BAD_REQUEST);
        }
        if (!this.isMember(group, userId)) {
            throw new ScimException("User is not a zone admin.", HttpStatus.NOT_FOUND);
        }
        LinkedList<ScimGroupMember> newZoneAdmins = new LinkedList<ScimGroupMember>();
        for (ScimGroupMember member : group.getMembers()) {
            if (member.getMemberId().equals(userId)) continue;
            newZoneAdmins.add(member);
        }
        group.setMembers(newZoneAdmins);
        return this.updateGroup(group, group.getId(), String.valueOf(group.getVersion()), httpServletResponse);
    }

    @RequestMapping(value={"/Groups/{groupId}/members/{memberId}"})
    public ResponseEntity<ScimGroupMember> getGroupMembership(@PathVariable String groupId, @PathVariable String memberId) {
        ScimGroupMember membership = this.membershipManager.getMemberById(groupId, memberId, IdentityZoneHolder.get().getId());
        return new ResponseEntity((Object)membership, HttpStatus.OK);
    }

    @RequestMapping(value={"/Groups/{groupId}/members"}, method={RequestMethod.GET})
    public ResponseEntity<List<ScimGroupMember>> listGroupMemberships(@PathVariable String groupId, @RequestParam(required=false, defaultValue="false") boolean returnEntities, @RequestParam(required=false, defaultValue="", name="filter") String deprecatedFilter) {
        this.dao.retrieve(groupId, IdentityZoneHolder.get().getId());
        List<ScimGroupMember> members = this.membershipManager.getMembers(groupId, returnEntities, IdentityZoneHolder.get().getId());
        return new ResponseEntity(members, HttpStatus.OK);
    }

    @RequestMapping(value={"/Groups/{groupId}/members"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ScimGroupMember addMemberToGroup(@PathVariable String groupId, @RequestBody ScimGroupMember member) {
        return this.membershipManager.addMember(groupId, member, IdentityZoneHolder.get().getId());
    }

    @RequestMapping(value={"/Groups/{groupId}/members/{memberId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ScimGroupMember deleteGroupMembership(@PathVariable String groupId, @PathVariable String memberId) {
        ScimGroupMember membership = this.membershipManager.removeMemberById(groupId, memberId, IdentityZoneHolder.get().getId());
        return membership;
    }

    @ExceptionHandler
    public View handleException(Exception t, HttpServletRequest request) throws ScimException {
        ScimException e = new ScimException("Unexpected error", t, HttpStatus.INTERNAL_SERVER_ERROR);
        if (t instanceof ScimException) {
            e = (ScimException)t;
        } else {
            Class<?> clazz = t.getClass();
            for (Class<? extends Exception> key : this.statuses.keySet()) {
                if (!key.isAssignableFrom(clazz)) continue;
                e = new ScimException(t.getMessage(), t, this.statuses.get(key));
                break;
            }
        }
        boolean trace = request.getParameter("trace") != null && !request.getParameter("trace").equals("false");
        return new ConvertingExceptionView((ResponseEntity<? extends ExceptionReport>)new ResponseEntity((Object)new ExceptionReport(e, trace), e.getStatus()), this.messageConverters);
    }

    private int getVersion(String groupId, String etag) {
        String value = etag.trim();
        while (value.startsWith("\"")) {
            value = value.substring(1);
        }
        while (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.equals("*")) {
            return ((ScimGroup)this.dao.retrieve(groupId, IdentityZoneHolder.get().getId())).getVersion();
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ScimException("Invalid version match header (should be a version number): " + etag, HttpStatus.BAD_REQUEST);
        }
    }

    private void addETagHeader(HttpServletResponse httpServletResponse, ScimGroup scimGroup) {
        httpServletResponse.setHeader(E_TAG, "\"" + scimGroup.getVersion() + "\"");
    }
}

