/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.cache;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.cache.UrlContentCache;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ExpiringUrlCache
implements UrlContentCache {
    private static Log logger = LogFactory.getLog(ExpiringUrlCache.class);
    private final long expiringTimeMillis;
    private final int maxEntries;
    private final TimeService ticker;
    protected Cache<String, CacheEntry> cache = null;

    public ExpiringUrlCache(long expiringTimeMillis, TimeService ticker, int maxEntries) {
        this.expiringTimeMillis = expiringTimeMillis;
        this.ticker = ticker;
        this.maxEntries = maxEntries;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(expiringTimeMillis, TimeUnit.MILLISECONDS).maximumSize((long)maxEntries).ticker(Ticker.systemTicker()).build();
    }

    @Override
    public byte[] getUrlContent(String uri, RestTemplate template) {
        try {
            URI netUri = new URI(uri);
            CacheEntry entry = (CacheEntry)this.cache.getIfPresent((Object)uri);
            byte[] metadata = entry != null ? entry.getData() : null;
            long now = this.ticker.getCurrentTimeMillis();
            if (metadata == null || now - entry.getTimeEntered() > this.expiringTimeMillis) {
                logger.debug((Object)("Fetching metadata for " + uri));
                metadata = (byte[])template.getForObject(netUri, byte[].class);
                this.cache.put((Object)uri, (Object)new CacheEntry(now, metadata));
            }
            return metadata;
        }
        catch (RestClientException x) {
            logger.warn((Object)("Unable to fetch metadata for " + uri), (Throwable)x);
            return null;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    static class CacheEntry {
        private final long timeEntered;
        private final byte[] data;

        public CacheEntry(long timeEntered, byte[] data) {
            this.timeEntered = timeEntered;
            this.data = data;
        }

        public long getTimeEntered() {
            return this.timeEntered;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

