/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.metrics;

public class IdleTimer {
    private int inflightRequests = 0;
    private long idleTime = 0L;
    private long lastIdleStart = System.currentTimeMillis();
    private final long startTime = System.currentTimeMillis();
    private long requestCount = 0L;

    public synchronized void endRequest() {
        switch (--this.inflightRequests) {
            case 0: {
                this.lastIdleStart = System.currentTimeMillis();
                break;
            }
            case -1: {
                throw new IllegalStateException("Illegal end request invocation, no request in flight");
            }
        }
        ++this.requestCount;
    }

    public synchronized void startRequest() {
        switch (++this.inflightRequests) {
            case 1: {
                this.idleTime += System.currentTimeMillis() - this.lastIdleStart;
                break;
            }
        }
    }

    public int getInflightRequests() {
        return this.inflightRequests;
    }

    public synchronized long getIdleTime() {
        if (this.inflightRequests == 0) {
            return System.currentTimeMillis() - this.lastIdleStart + this.idleTime;
        }
        return this.idleTime;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getRunTime() {
        return System.currentTimeMillis() - this.startTime;
    }
}

