/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.metrics;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.LinkedList;
import java.util.List;
import org.cloudfoundry.identity.uaa.metrics.QueryMetric;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RequestMetric {
    private String uri;
    private int statusCode;
    private long requestStartTime;
    private long requestCompleteTime;
    private List<QueryMetric> queries = new LinkedList<QueryMetric>();

    public static RequestMetric start(String uri, long start) {
        RequestMetric metric = new RequestMetric();
        metric.requestStartTime = start;
        metric.uri = uri;
        return metric;
    }

    public void stop(int statusCode, long stop) {
        this.requestCompleteTime = stop;
        this.statusCode = statusCode;
    }

    public void addQuery(QueryMetric query) {
        this.queries.add(query);
    }

    @JsonIgnore
    protected List<QueryMetric> getQueries() {
        return this.queries;
    }

    public String getUri() {
        return this.uri;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public long getRequestStartTime() {
        return this.requestStartTime;
    }

    public long getRequestCompleteTime() {
        return this.requestCompleteTime;
    }

    public long getNrOfDatabaseQueries() {
        return this.queries.size();
    }

    public long getDatabaseQueryTime() {
        return this.queries.stream().mapToLong(q -> q.getRequestCompleteTime() - q.getRequestStartTime()).sum();
    }
}

