/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.MetadataProviderNotFoundException;
import org.cloudfoundry.identity.uaa.provider.saml.SamlBindingNotSupportedException;
import org.cloudfoundry.identity.uaa.provider.saml.SamlIdentityProviderConfigurator;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.websso.WebSSOProfileOptions;

public class LoginSamlEntryPoint
extends SAMLEntryPoint {
    private SamlIdentityProviderConfigurator providerDefinitionList;

    public SamlIdentityProviderConfigurator getProviderDefinitionList() {
        return this.providerDefinitionList;
    }

    public void setProviderDefinitionList(SamlIdentityProviderConfigurator providerDefinitionList) {
        this.providerDefinitionList = providerDefinitionList;
    }

    public WebSSOProfileOptions getDefaultProfileOptions() {
        return this.defaultOptions;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException, ServletException {
        try {
            SAMLMessageContext context = this.contextProvider.getLocalAndPeerEntity(request, response);
            if (this.isECP(context)) {
                this.initializeECP(context, e);
            } else if (this.isDiscovery(context)) {
                this.initializeDiscovery(context);
            } else {
                this.initializeSSO(context, e);
            }
        }
        catch (SamlBindingNotSupportedException e1) {
            request.setAttribute("error_message_code", (Object)"error.sso.supported.binding");
            response.setStatus(400);
            request.getRequestDispatcher("/saml_error").include((ServletRequest)request, (ServletResponse)response);
        }
        catch (SAMLException e1) {
            logger.debug("Error initializing entry point", (Throwable)e1);
            throw new ServletException((Throwable)e1);
        }
        catch (MetadataProviderException e1) {
            logger.debug("Error initializing entry point", (Throwable)e1);
            throw new ServletException((Throwable)e1);
        }
        catch (MessageEncodingException e1) {
            logger.debug("Error initializing entry point", (Throwable)e1);
            throw new ServletException((Throwable)e1);
        }
    }

    protected WebSSOProfileOptions getProfileOptions(SAMLMessageContext context, AuthenticationException exception) throws MetadataProviderException {
        ExtendedMetadata extendedMetadata;
        WebSSOProfileOptions options = super.getProfileOptions(context, exception);
        String idpEntityId = context.getPeerEntityId();
        if (idpEntityId != null && (extendedMetadata = this.metadata.getExtendedMetadata(idpEntityId)) != null) {
            String alias = extendedMetadata.getAlias();
            SamlIdentityProviderDefinition def = this.getIDPDefinition(alias);
            if (def.getNameID() != null) {
                options.setNameID(def.getNameID());
            }
            if (def.getAssertionConsumerIndex() >= 0) {
                options.setAssertionConsumerIndex(Integer.valueOf(def.getAssertionConsumerIndex()));
            }
            if (def.getAuthnContext() != null) {
                options.setAuthnContexts((Collection)def.getAuthnContext());
            }
        }
        return options;
    }

    private SamlIdentityProviderDefinition getIDPDefinition(String alias) throws MetadataProviderException {
        if (alias != null) {
            for (SamlIdentityProviderDefinition def : this.getProviderDefinitionList().getIdentityProviderDefinitions()) {
                if (!alias.equals(def.getIdpEntityAlias()) || !IdentityZoneHolder.get().getId().equals(def.getZoneId())) continue;
                return def;
            }
        }
        throw new MetadataProviderNotFoundException("Unable to find SAML provider for alias:" + alias);
    }
}

