/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.security.cert.X509Certificate;
import java.util.Set;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.springframework.security.saml.key.KeyManager;

public class ZoneAwareKeyManager
implements KeyManager {
    public Credential getCredential(String keyName) {
        return IdentityZoneHolder.getSamlSPKeyManager().getCredential(keyName);
    }

    public Credential getDefaultCredential() {
        return IdentityZoneHolder.getSamlSPKeyManager().getDefaultCredential();
    }

    public String getDefaultCredentialName() {
        return IdentityZoneHolder.getSamlSPKeyManager().getDefaultCredentialName();
    }

    public Set<String> getAvailableCredentials() {
        return IdentityZoneHolder.getSamlSPKeyManager().getAvailableCredentials();
    }

    public X509Certificate getCertificate(String alias) {
        return IdentityZoneHolder.getSamlSPKeyManager().getCertificate(alias);
    }

    public Iterable<Credential> resolve(CriteriaSet criteria) throws SecurityException {
        return IdentityZoneHolder.getSamlSPKeyManager().resolve((Object)criteria);
    }

    public Credential resolveSingle(CriteriaSet criteria) throws SecurityException {
        return (Credential)IdentityZoneHolder.getSamlSPKeyManager().resolveSingle((Object)criteria);
    }
}

