/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.StringUtils;

public class AuthorizePromptNoneEntryPoint
implements AuthenticationEntryPoint {
    private static Log logger = LogFactory.getLog(AuthorizePromptNoneEntryPoint.class);
    private final AuthenticationFailureHandler failureHandler;
    private final ClientServicesExtension clientDetailsService;
    private final RedirectResolver redirectResolver;

    public AuthorizePromptNoneEntryPoint(AuthenticationFailureHandler failureHandler, ClientServicesExtension clientDetailsService, RedirectResolver redirectResolver) {
        this.failureHandler = failureHandler;
        this.clientDetailsService = clientDetailsService;
        this.redirectResolver = redirectResolver;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String resolvedRedirect;
        ClientDetails client;
        String clientId = request.getParameter("client_id");
        String redirectUri = request.getParameter("redirect_uri");
        String[] responseTypes = Optional.ofNullable(request.getParameter("response_type")).map(rt -> rt.split(" ")).orElse(new String[0]);
        if (!StringUtils.hasText((String)clientId)) {
            logger.debug((Object)"[prompt=none] Missing client_id parameter");
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        try {
            client = this.clientDetailsService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
        }
        catch (ClientRegistrationException e) {
            logger.debug((Object)("[prompt=none] Unable to look up client for client_id=" + clientId), (Throwable)e);
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        Set redirectUris = Optional.ofNullable(client.getRegisteredRedirectUri()).orElse(Collections.EMPTY_SET);
        if (redirectUris.size() == 0 && !StringUtils.hasText((String)redirectUri)) {
            logger.debug((Object)"[prompt=none] Missing redirect_uri");
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        try {
            resolvedRedirect = this.redirectResolver.resolveRedirect(redirectUri, client);
        }
        catch (RedirectMismatchException rme) {
            logger.debug((Object)("[prompt=none] Invalid redirect " + redirectUri + " did not match one of the registered values"));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        this.failureHandler.onAuthenticationFailure(request, response, authException);
        boolean implicit = Arrays.stream(responseTypes).noneMatch("code"::equalsIgnoreCase);
        String redirectLocation = implicit ? UaaUrlUtils.addFragmentComponent(resolvedRedirect, "error=login_required") : UaaUrlUtils.addQueryParameter(resolvedRedirect, "error", "login_required");
        response.sendRedirect(redirectLocation);
    }
}

